/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.worker;

import com.evolveum.midpoint.ninja.action.ExportOptions;
import com.evolveum.midpoint.ninja.action.worker.ExportConfigurationWorker;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismSerializer;
import com.evolveum.midpoint.prism.SerializationOptions;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import org.jetbrains.annotations.NotNull;

public class ExportConfigurationSeparateWorker
extends ExportConfigurationWorker {
    private final PrismSerializer<String> serializer;
    private final Path outputDir;

    public ExportConfigurationSeparateWorker(NinjaContext context, ExportOptions options, BlockingQueue<ObjectType> queue, OperationStatus operation) {
        super(context, options, queue, operation);
        this.serializer = context.getPrismContext().xmlSerializer().options(SerializationOptions.createSerializeForExport().skipContainerIds(options.isSkipContainerIds()));
        this.outputDir = this.resolveAndPrepareOutputDir();
        if (options.isZip()) {
            context.getLog().warn("Ignoring --zip for split-files mode; writing plain XML files into {}", new Object[]{this.outputDir});
        }
    }

    protected void init() {
        this.options = ((ExportOptions)this.options).setOutput(null);
    }

    protected String getProlog() {
        return "";
    }

    protected String getEpilog() {
        return "";
    }

    protected void write(Writer writer, ObjectType object) throws SchemaException, IOException {
        PrismObject prismObject = object.asPrismObject();
        if (this.shouldSkipObject(prismObject)) {
            return;
        }
        Path target = this.buildTargetPath(object);
        this.editObject(prismObject);
        @NotNull List itemsPaths = this.getExcludeItemsPaths();
        if (!itemsPaths.isEmpty()) {
            prismObject.getValue().removePaths(itemsPaths);
        }
        if (Files.exists(target, new LinkOption[0]) && !((ExportOptions)this.options).isOverwrite()) {
            this.context.getLog().warn("File {} exists and --overwrite not set; skipping", new Object[]{target});
            this.operation.incrementError();
            return;
        }
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        String xml = (String)this.serializer.serialize((Item)prismObject);
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(target, this.context.getCharset(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            bufferedWriter.write(xml);
        }
    }

    private Path resolveAndPrepareOutputDir() {
        Path dir;
        if (((ExportOptions)this.options).getOutput() == null) {
            this.context.getLog().warn("Output directory not specified, using default: /tmp/export", new Object[0]);
            dir = Path.of("/tmp/export-midpoint-config", new String[0]);
        } else {
            dir = ((ExportOptions)this.options).getOutput().toPath();
        }
        try {
            if (Files.exists(dir, new LinkOption[0]) && !Files.isDirectory(dir, new LinkOption[0])) {
                throw new NinjaException("--output must be a directory when using --split-files: " + dir);
            }
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new NinjaException("Couldn't prepare output directory '" + dir + "': " + e.getMessage(), (Throwable)e);
        }
        return dir;
    }

    private Path buildTargetPath(ObjectType obj) {
        String type = obj.asPrismObject().getCompileTimeClass().getSimpleName();
        String oidPart = obj.getOid() != null ? obj.getOid() : String.valueOf(System.currentTimeMillis());
        String name = obj.getName() != null && obj.getName().getOrig() != null ? obj.getName().getOrig() : "noname";
        String safeName = this.sanitizeForFilename(name);
        String filename = String.format(Locale.ROOT, "%s-%s.xml", safeName, oidPart);
        return this.outputDir.resolve(type).resolve(filename);
    }

    private String sanitizeForFilename(String input) {
        String s = input.trim();
        s = s.replaceAll("[^A-Za-z0-9._-]", "_");
        if ((s = s.replaceAll("_+", "_")).length() > 80) {
            s = s.substring(0, 80);
        }
        if (s.isEmpty()) {
            s = "noname";
        }
        return s;
    }
}

