/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.verify;

import com.evolveum.midpoint.ninja.action.VerifyOptions;
import com.evolveum.midpoint.ninja.action.VerifyResult;
import com.evolveum.midpoint.ninja.action.verify.VerificationReporter;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.schema.DeltaConvertor;
import com.evolveum.midpoint.schema.validator.ObjectUpgradeValidator;
import com.evolveum.midpoint.schema.validator.UpgradePhase;
import com.evolveum.midpoint.schema.validator.UpgradePriority;
import com.evolveum.midpoint.schema.validator.UpgradeType;
import com.evolveum.midpoint.schema.validator.UpgradeValidationItem;
import com.evolveum.midpoint.schema.validator.UpgradeValidationResult;
import com.evolveum.midpoint.schema.validator.ValidationItem;
import com.evolveum.midpoint.util.LocalizableMessage;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.prism.xml.ns._public.types_3.ObjectDeltaType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class VerificationReporter {
    public static final String DELTA_FILE_NAME_SUFFIX = ".delta.xml";
    public static final List<String> REPORT_HEADER = List.of("Oid", "Type", "Name", "Status", "Item path", "Message", "Identifier", "Phase", "Priority", "Type", "Upgrade description", "Skip upgrade [yes/no] Default: no");
    private static final int COLUMN_INDEX_OID = 0;
    private static final int COLUMN_INDEX_PATH = 4;
    private static final int COLUMN_INDEX_IDENTIFIER = 6;
    private static final int COLUMN_INDEX_SKIP_UPGRADE = REPORT_HEADER.size() - 1;
    public static final CSVFormat CSV_FORMAT = VerificationReporter.createCsvFormat();
    private final VerifyOptions options;
    private final PrismContext prismContext;
    private final Charset charset;
    private final Log log;
    private ObjectUpgradeValidator validator;
    private final VerifyResult result = new VerifyResult();
    private boolean createDeltaFile;
    private Writer deltaWriter;

    public VerificationReporter(@NotNull VerifyOptions options, @NotNull PrismContext prismContext, @NotNull Charset charset, @NotNull Log log) {
        this.options = options;
        this.prismContext = prismContext;
        this.charset = charset;
        this.log = log;
    }

    public void setCreateDeltaFile(boolean createDeltaFile) {
        this.createDeltaFile = createDeltaFile;
    }

    public void destroy() {
        if (this.deltaWriter != null) {
            try {
                this.deltaWriter.write("</deltas>\n");
            }
            catch (IOException ex) {
                throw new NinjaException("Couldn't finish file for XML deltas", (Throwable)ex);
            }
            IOUtils.closeQuietly((Writer)this.deltaWriter);
        }
    }

    public void init() {
        this.result.setVerificationFile(this.options.getOutput());
        if (this.createDeltaFile) {
            this.initDeltaXmlFile();
        }
        this.validator = new ObjectUpgradeValidator(this.prismContext);
        this.validator.setWarnPlannedRemovalVersion(this.options.getPlannedRemovalVersion());
        List categories = this.options.getVerificationCategories();
        if (categories.isEmpty()) {
            this.validator.showAllWarnings();
        } else {
            block6: for (VerifyOptions.VerificationCategory category : categories) {
                switch (1.$SwitchMap$com$evolveum$midpoint$ninja$action$VerifyOptions$VerificationCategory[category.ordinal()]) {
                    case 1: {
                        this.validator.setWarnDeprecated(true);
                        continue block6;
                    }
                    case 2: {
                        this.validator.setWarnIncorrectOids(true);
                        continue block6;
                    }
                    case 3: {
                        this.validator.setWarnPlannedRemoval(true);
                        continue block6;
                    }
                    case 4: {
                        this.validator.setWarnRemoved(true);
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unknown category " + category);
            }
        }
    }

    private void initDeltaXmlFile() {
        if (this.options.getOutput() == null || !VerifyOptions.ReportStyle.CSV.equals((Object)this.options.getReportStyle())) {
            return;
        }
        File deltaFile = new File(this.options.getOutput() + DELTA_FILE_NAME_SUFFIX);
        try {
            if (deltaFile.exists()) {
                if (this.options.isOverwrite()) {
                    deltaFile.delete();
                } else {
                    throw new NinjaException("Export file for XML delta '" + deltaFile.getPath() + "' already exists");
                }
            }
            deltaFile.createNewFile();
            this.deltaWriter = new FileWriter(deltaFile, this.charset);
            this.deltaWriter.write("<deltas xmlns=\"http://midpoint.evolveum.com/xml/ns/public/common/api-types-3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"ObjectDeltaListType\">\n");
        }
        catch (IOException ex) {
            throw new NinjaException("Couldn't create file for XML deltas " + deltaFile.getPath(), (Throwable)ex);
        }
    }

    public String getProlog() {
        if (this.options.getReportStyle() == VerifyOptions.ReportStyle.CSV) {
            try {
                StringWriter writer = new StringWriter();
                CSVPrinter printer = CSV_FORMAT.print((Appendable)writer);
                printer.printRecord((Iterable)REPORT_HEADER);
                return writer.toString();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Couldn't write CSV header", ex);
            }
        }
        return null;
    }

    public String getEpilog() {
        return null;
    }

    private static CSVFormat createCsvFormat() {
        return CSVFormat.Builder.create().setDelimiter(';').setEscape('\\').setIgnoreHeaderCase(false).setQuote('\"').setRecordSeparator('\n').setQuoteMode(QuoteMode.ALL).build();
    }

    public <T extends Objectable> UpgradeValidationResult verify(Writer writer, PrismObject<T> object) throws Exception {
        UpgradeValidationResult result = this.validator.validate(object);
        for (UpgradeValidationItem item : result.getItems()) {
            if (item.getPriority() == null) {
                this.result.incrementUnknownCount();
                continue;
            }
            this.result.incrementPriorityItemCount(item.getPriority());
        }
        switch (1.$SwitchMap$com$evolveum$midpoint$ninja$action$VerifyOptions$ReportStyle[this.options.getReportStyle().ordinal()]) {
            case 1: {
                this.verifyAsPlain(writer, object, result);
                break;
            }
            case 2: {
                this.verifyAsCsv(writer, object, result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown report style " + this.options.getReportStyle());
            }
        }
        if (this.createDeltaFile) {
            this.writeDeltaXml(result);
        }
        return result;
    }

    private void writeDeltaXml(UpgradeValidationResult result) {
        for (UpgradeValidationItem item : result.getItems()) {
            if (item.getDelta() == null || this.deltaWriter == null) continue;
            try {
                ObjectDeltaType deltaType = DeltaConvertor.toObjectDeltaType((ObjectDelta)item.getDelta());
                String xml = (String)this.prismContext.xmlSerializer().serializeRealValue((Object)deltaType, NinjaUtils.DELTA_LIST_DELTA);
                this.deltaWriter.write(xml);
            }
            catch (SchemaException | IOException ex) {
                this.log.error("Couldn't write object delta to XML file", (Exception)ex, new Object[0]);
            }
        }
    }

    public static String getItemPathFromRecord(CSVRecord record) {
        if (record == null || record.size() != REPORT_HEADER.size()) {
            return "";
        }
        String path = record.get(4);
        if (StringUtils.isBlank((CharSequence)path)) {
            return "";
        }
        return path.trim();
    }

    public static String getIdentifierFromRecord(CSVRecord record) {
        if (record == null || record.size() != REPORT_HEADER.size()) {
            return null;
        }
        return record.get(6);
    }

    public static UUID getUuidFromRecord(CSVRecord record) {
        if (record == null || record.size() != REPORT_HEADER.size()) {
            return null;
        }
        String oid = record.get(0);
        return StringUtils.isNotEmpty((CharSequence)oid) ? UUID.fromString(oid) : null;
    }

    public static boolean skipUpgradeForRecord(CSVRecord record) {
        if (record == null || record.size() != REPORT_HEADER.size()) {
            return true;
        }
        String value = record.get(COLUMN_INDEX_SKIP_UPGRADE);
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("y");
    }

    private void verifyAsPlain(Writer writer, PrismObject<?> object, UpgradeValidationResult result) throws IOException {
        for (UpgradeValidationItem validationItem : result.getItems()) {
            this.writeValidationItem(writer, object, validationItem);
        }
    }

    private void verifyAsCsv(Writer writer, PrismObject<?> object, UpgradeValidationResult result) throws IOException {
        CSVPrinter printer = CSV_FORMAT.print((Appendable)writer);
        for (UpgradeValidationItem item : result.getItems()) {
            printer.printRecord((Iterable)this.createReportRecord(item, object));
        }
    }

    private List<String> createReportRecord(UpgradeValidationItem item, PrismObject<?> object) {
        String identifier = item.getIdentifier();
        UpgradePhase phase = item.getPhase();
        UpgradePriority priority = item.getPriority();
        UpgradeType type = item.getType();
        String upgradeDescription = item.getDescription();
        return Arrays.asList(object.getOid(), object.getDefinition().getTypeName().getLocalPart(), object.getBusinessDisplayName(), Objects.toString(item.getItem().getStatus()), Objects.toString(item.getItem().getItemPath()), item.getItem().getMessage() != null ? item.getItem().getMessage().getFallbackMessage() : null, identifier, phase != null ? phase.name() : null, priority != null ? priority.name() : null, type != null ? type.name() : null, upgradeDescription, null);
    }

    private void writeValidationItem(Writer writer, PrismObject<?> object, UpgradeValidationItem item) throws IOException {
        String msg;
        ValidationItem validationItem = item.getItem();
        ArrayList<Object> items = new ArrayList<Object>();
        if (validationItem.getStatus() != null) {
            items.add(validationItem.getStatus());
        } else {
            writer.append("INFO ");
        }
        UpgradePriority priority = item.getPriority();
        if (priority != null) {
            items.add(priority);
        }
        items.add(this.getObjectDisplayName(object));
        if (validationItem.getItemPath() != null) {
            items.add(validationItem.getItemPath());
        }
        if ((msg = this.writeMessage(validationItem.getMessage())) != null) {
            items.add(msg);
        }
        writer.write(StringUtils.join(items, (String)" "));
        writer.write("\n");
    }

    private String getObjectDisplayName(PrismObject<?> object) {
        StringBuilder sb = new StringBuilder();
        sb.append(object.getName());
        sb.append(" (");
        sb.append(object.getOid());
        sb.append(", ");
        sb.append(object.getCompileTimeClass().getSimpleName());
        sb.append(")");
        return sb.toString();
    }

    private String writeMessage(LocalizableMessage message) {
        if (message == null) {
            return null;
        }
        return message.getFallbackMessage();
    }

    public VerifyResult getResult() {
        return this.result;
    }
}

