/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.upgrade.action;

import com.evolveum.midpoint.ninja.action.AbstractRepositorySearchAction;
import com.evolveum.midpoint.ninja.action.ActionResult;
import com.evolveum.midpoint.ninja.action.upgrade.SkipUpgradeItem;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectHandler;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectResult;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectsConsumerWorker;
import com.evolveum.midpoint.ninja.action.upgrade.UpgradeObjectsItemsSummary;
import com.evolveum.midpoint.ninja.action.upgrade.action.UpgradeObjectsOptions;
import com.evolveum.midpoint.ninja.action.verify.VerificationReporter;
import com.evolveum.midpoint.ninja.impl.Log;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.NinjaApplicationContextLevel;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.InputParameterException;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ParsingContext;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismParser;
import com.evolveum.midpoint.prism.PrismSerializer;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.validator.UpgradePriority;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class UpgradeObjectsAction
extends AbstractRepositorySearchAction<UpgradeObjectsOptions, ActionResult<UpgradeObjectsItemsSummary>> {
    public static final int ERROR_CODE_VERIFICATION_FILE_NOT_FOUND = 101;
    private Map<UUID, Set<SkipUpgradeItem>> skipUpgradeItems;

    public UpgradeObjectsAction() {
    }

    public UpgradeObjectsAction(boolean partial) {
        super(partial);
    }

    public LogTarget getLogTarget() {
        return LogTarget.SYSTEM_OUT;
    }

    @NotNull
    public NinjaApplicationContextLevel getApplicationContextLevel(List<Object> allOptions) {
        UpgradeObjectsOptions opts = (UpgradeObjectsOptions)NinjaUtils.getOptions(allOptions, UpgradeObjectsOptions.class);
        if (opts != null && !opts.getFiles().isEmpty()) {
            return NinjaApplicationContextLevel.NO_REPOSITORY;
        }
        return super.getApplicationContextLevel(allOptions);
    }

    public ActionResult<UpgradeObjectsItemsSummary> execute() throws Exception {
        this.skipUpgradeItems = this.loadVerificationFile();
        this.log.info("Upgrade will skip {} objects", new Object[]{this.skipUpgradeItems.size()});
        if (!((UpgradeObjectsOptions)this.options).getFiles().isEmpty()) {
            if (this.context.isUserMode() && !((UpgradeObjectsOptions)this.options).isSkipUpgradeWarning()) {
                this.log.warn("File update will remove XML comments and change formatting. Do you wish to proceed? (Y/n)", new Object[0]);
                String result = NinjaUtils.readInput((Log)this.log, input -> StringUtils.isEmpty((CharSequence)input) || input.matches("[Yn]"));
                if (result.trim().equalsIgnoreCase("n")) {
                    this.log.info("Upgrade aborted", new Object[0]);
                    return null;
                }
            }
            return this.upgradeObjectsInFiles();
        }
        if (this.context.isUserMode() && !((UpgradeObjectsOptions)this.options).isSkipUpgradeWarning()) {
            this.log.warn("Object now will be updated in repository. Do you wish to proceed? (Y/n)", new Object[0]);
            String result = NinjaUtils.readInput((Log)this.log, input -> StringUtils.isEmpty((CharSequence)input) || input.matches("[Yn]"));
            if (result.trim().equalsIgnoreCase("n")) {
                this.log.info("Upgrade aborted", new Object[0]);
                return null;
            }
        }
        return (ActionResult)super.execute();
    }

    private ActionResult<UpgradeObjectsItemsSummary> upgradeObjectsInFiles() {
        UpgradeObjectsItemsSummary summary = new UpgradeObjectsItemsSummary();
        for (File file : ((UpgradeObjectsOptions)this.options).getFiles()) {
            if (!file.isDirectory()) {
                this.upgradeFile(file, summary);
                continue;
            }
            Collection children = FileUtils.listFiles((File)file, (String[])new String[]{"xml"}, (boolean)true);
            for (File child : children) {
                if (child.isDirectory()) continue;
                this.upgradeFile(child, summary);
            }
        }
        return new ActionResult((Object)summary);
    }

    private void upgradeFile(File file, UpgradeObjectsItemsSummary summary) {
        List objects;
        PrismContext prismContext = this.context.getPrismContext();
        ParsingContext parsingContext = prismContext.createParsingContextForCompatibilityMode();
        PrismParser parser = prismContext.parserFor(file).language("xml").context(parsingContext);
        try {
            objects = parser.parseObjects();
        }
        catch (Exception ex) {
            this.log.error("Couldn't parse file '{}'", ex, new Object[]{file.getPath()});
            return;
        }
        boolean changed = false;
        try {
            UpgradeObjectHandler executor = new UpgradeObjectHandler((UpgradeObjectsOptions)this.options, this.context, this.skipUpgradeItems, summary);
            for (PrismObject object : objects) {
                UpgradeObjectResult result = executor.execute(object);
                if (result != UpgradeObjectResult.UPDATED) continue;
                changed = true;
            }
        }
        catch (Exception ex) {
            this.log.error("Couldn't update file '{}'", ex, new Object[]{file.getPath()});
        }
        if (!changed) {
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            PrismSerializer serializer = prismContext.xmlSerializer();
            String xml = objects.size() > 1 ? (String)serializer.serializeObjects(objects) : (String)serializer.serialize((Item)objects.get(0));
            writer.write(xml);
        }
        catch (Exception ex) {
            this.log.error("Couldn't serialize objects to file '{}'", ex, new Object[]{file.getPath()});
        }
    }

    public String getOperationName() {
        return "upgrade objects";
    }

    private Map<UUID, Set<SkipUpgradeItem>> loadVerificationFile() throws IOException {
        File verification = ((UpgradeObjectsOptions)this.options).getVerification();
        if (verification == null) {
            if (this.context.isUserMode()) {
                this.log.warn("Upgrade objects started without verification report, all necessary non-manual changes will be accepted.", new Object[0]);
            }
            return Collections.emptyMap();
        }
        if (!verification.exists() || !verification.isFile()) {
            throw new InputParameterException("Verification file '" + verification.getAbsolutePath() + "' does not exist or is not a file", Integer.valueOf(101));
        }
        this.log.info("Loading verification file", new Object[0]);
        HashMap<UUID, HashSet<SkipUpgradeItem>> map = new HashMap<UUID, HashSet<SkipUpgradeItem>>();
        CSVFormat format = VerificationReporter.CSV_FORMAT;
        try (CSVParser parser = format.parse((Reader)new FileReader(verification, this.context.getCharset()));){
            for (CSVRecord record : parser) {
                if (record.getRecordNumber() == 1L || this.isRecordEmpty(record) || !VerificationReporter.skipUpgradeForRecord((CSVRecord)record)) continue;
                UUID uuid = VerificationReporter.getUuidFromRecord((CSVRecord)record);
                String path = VerificationReporter.getItemPathFromRecord((CSVRecord)record);
                String identifier = VerificationReporter.getIdentifierFromRecord((CSVRecord)record);
                if (uuid == null) continue;
                HashSet<SkipUpgradeItem> identifiers = (HashSet<SkipUpgradeItem>)map.get(uuid);
                if (identifiers == null) {
                    identifiers = new HashSet<SkipUpgradeItem>();
                    map.put(uuid, identifiers);
                }
                identifiers.add(new SkipUpgradeItem(path, identifier));
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private boolean isRecordEmpty(CSVRecord record) {
        for (int i = 0; i < record.size(); ++i) {
            String value = record.get(i);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            return false;
        }
        return true;
    }

    protected Callable<ActionResult<UpgradeObjectsItemsSummary>> createConsumer(BlockingQueue<ObjectType> queue, OperationStatus operation) {
        return () -> {
            UpgradeObjectsConsumerWorker worker = new UpgradeObjectsConsumerWorker(this.skipUpgradeItems, this.context, (UpgradeObjectsOptions)this.options, queue, operation);
            worker.run();
            UpgradeObjectsItemsSummary summary = worker.getItemsSummary();
            return new ActionResult((Object)summary);
        };
    }

    protected void handleResultOnFinish(ActionResult<UpgradeObjectsItemsSummary> consumerResult, OperationStatus operation, String finishMessage) {
        super.handleResultOnFinish(consumerResult, operation, finishMessage);
        this.log.info("", new Object[0]);
        this.log.info("Upgrade objects finished.", new Object[0]);
        this.logSummary((UpgradeObjectsItemsSummary)consumerResult.result(), UpgradeObjectsItemsSummary.ItemStatus.PROCESSED);
        this.logSummary((UpgradeObjectsItemsSummary)consumerResult.result(), UpgradeObjectsItemsSummary.ItemStatus.SKIPPED);
        OperationResult result = operation.getResult();
        if (result.isAcceptable() && this.context.isUserMode() && !this.partial) {
            this.log.info("", new Object[0]);
            this.log.info("If you want to continue to continue with upgrade, please run: ninja.sh upgrade-distribution.", new Object[0]);
        }
    }

    private void logSummary(UpgradeObjectsItemsSummary summary, UpgradeObjectsItemsSummary.ItemStatus status) {
        int critical = summary.get(UpgradePriority.CRITICAL, status);
        int necessary = summary.get(UpgradePriority.NECESSARY, status);
        int optional = summary.get(UpgradePriority.OPTIONAL, status);
        int unknown = summary.get(null, status);
        this.log.info("\t {}, {}, {} and {} unknown verification items {}, total {}", new Object[]{ConsoleFormat.formatMessageWithErrorParameters((String)"{} critical", (Object[])new Object[]{critical}), ConsoleFormat.formatMessageWithWarningParameters((String)"{} necessary", (Object[])new Object[]{necessary}), ConsoleFormat.formatMessageWithInfoParameters((String)"{} optional", (Object[])new Object[]{optional}), unknown, status.label, critical + necessary + optional});
    }
}

