/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.trace;

import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.action.trace.EditTraceOptions;
import com.evolveum.midpoint.ninja.action.trace.TraceStatistics;
import com.evolveum.midpoint.ninja.impl.NinjaApplicationContextLevel;
import com.evolveum.midpoint.schema.traces.TraceParser;
import com.evolveum.midpoint.schema.traces.TraceWriter;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_3.TracingOutputType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class EditTraceAction
extends RepositoryAction<EditTraceOptions, Void> {
    private static final String DEFAULT_OUTPUT = "output.zip";
    private int killed;

    public String getOperationName() {
        return "edit trace";
    }

    @NotNull
    public NinjaApplicationContextLevel getApplicationContextLevel(List<Object> allOptions) {
        return NinjaApplicationContextLevel.NO_REPOSITORY;
    }

    public Void execute() throws Exception {
        TracingOutputType trace = this.parseInput();
        if (((EditTraceOptions)this.options).isPrintStat() || ((EditTraceOptions)this.options).isPrintStatExtra()) {
            this.printStatistics(trace);
        }
        if (CollectionUtils.isNotEmpty((Collection)((EditTraceOptions)this.options).getKeep()) || CollectionUtils.isNotEmpty((Collection)((EditTraceOptions)this.options).getKill())) {
            this.applyKeep(trace);
            this.applyKill(trace);
            this.writeTrace(trace);
        }
        return null;
    }

    private TracingOutputType parseInput() throws IOException, SchemaException {
        String inputFile = ((EditTraceOptions)this.options).getInput();
        this.log.info("Starting parsing input file: {}", new Object[]{inputFile});
        long start = System.currentTimeMillis();
        TraceParser parser = new TraceParser(this.context.getPrismContext());
        TracingOutputType trace = parser.parse(new File(inputFile), true);
        this.log.info("Parsing finished; in {} seconds", new Object[]{(System.currentTimeMillis() - start) / 1000L});
        return trace;
    }

    private void printStatistics(TracingOutputType trace) {
        TraceStatistics statistics = ((EditTraceOptions)this.options).isPrintStatExtra() ? TraceStatistics.extra((TracingOutputType)trace) : TraceStatistics.simple((TracingOutputType)trace);
        this.log.info("Trace statistics:\n{}", new Object[]{statistics.dump(TraceStatistics.SortBy.SIZE)});
    }

    private void applyKeep(TracingOutputType trace) {
        List patterns = this.getPatterns(((EditTraceOptions)this.options).getKeep());
        if (!patterns.isEmpty()) {
            ArrayList matchingChildren = new ArrayList();
            this.applyKeep(trace.getResult(), matchingChildren, patterns);
            this.log.info("Keeping {} matching nodes", new Object[]{matchingChildren.size()});
            trace.getResult().getPartialResults().clear();
            trace.getResult().getPartialResults().addAll(matchingChildren);
        }
    }

    private void applyKeep(OperationResultType result, List<OperationResultType> matchingChildren, List<Pattern> patterns) {
        for (OperationResultType child : result.getPartialResults()) {
            if (this.matches(child, patterns)) {
                matchingChildren.add(child);
                continue;
            }
            this.applyKeep(child, matchingChildren, patterns);
        }
    }

    private void applyKill(TracingOutputType trace) {
        List patterns = this.getPatterns(((EditTraceOptions)this.options).getKill());
        if (!patterns.isEmpty()) {
            this.applyKill(trace.getResult(), patterns);
            this.log.info("Killed {} nodes", new Object[]{this.killed});
        }
    }

    private void applyKill(OperationResultType result, List<Pattern> patterns) {
        Iterator iterator = result.getPartialResults().iterator();
        while (iterator.hasNext()) {
            OperationResultType child = (OperationResultType)iterator.next();
            if (this.matches(child, patterns)) {
                iterator.remove();
                ++this.killed;
                continue;
            }
            this.applyKill(child, patterns);
        }
    }

    private boolean matches(OperationResultType result, List<Pattern> patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(result.getOperation()).matches()) continue;
            return true;
        }
        return false;
    }

    private List<Pattern> getPatterns(List<String> templates) {
        ArrayList<Pattern> compiledPatterns = new ArrayList<Pattern>();
        for (String template : templates) {
            String regex = this.toRegex(template);
            compiledPatterns.add(Pattern.compile(regex));
        }
        return compiledPatterns;
    }

    private String toRegex(String template) {
        return template.replace(".", "\\.").replace("*", ".*");
    }

    private void writeTrace(TracingOutputType trace) throws SchemaException, IOException {
        String output = (String)ObjectUtils.defaultIfNull((Object)((EditTraceOptions)this.options).getOutput(), (Object)DEFAULT_OUTPUT);
        this.log.info("Starting writing trace to {}", new Object[]{output});
        new TraceWriter(this.context.getPrismContext()).writeTrace(trace, new File(output), true);
        this.log.info("Trace written.", new Object[0]);
    }
}

