/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.stats;

import com.evolveum.midpoint.ninja.action.stats.CategoriesDistribution;
import com.evolveum.midpoint.ninja.action.stats.PropertyStats;
import com.evolveum.midpoint.prism.PrismProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
class PropertyStatsCounter {
    private static final int FIXED_DISTRIBUTION_THRESHOLD = 20;
    private static final int MAP_SIZE_LIMIT = 1000;
    private final String propertyPath;
    private final Map<String, Integer> valuesCount;
    private int multiValuedPropertiesCount;
    private int propertiesCount;
    private int missingPropertiesCount;

    PropertyStatsCounter(String propertyPath) {
        this.propertyPath = propertyPath;
        this.valuesCount = new HashMap();
        this.multiValuedPropertiesCount = 0;
        this.propertiesCount = 0;
        this.missingPropertiesCount = 0;
    }

    void count(PrismProperty<?> property) {
        ++this.propertiesCount;
        if (property.size() > 1) {
            List<Object> nonNullValues = property.getRealValues().stream().filter(Objects::isNull).toList();
            if (nonNullValues.isEmpty()) {
                this.countSingleValue(null);
            } else {
                nonNullValues.forEach(arg_0 -> this.countSingleValue(arg_0));
            }
            ++this.multiValuedPropertiesCount;
        } else {
            Object realValue = property.getRealValue();
            this.countSingleValue(realValue);
        }
    }

    PropertyStats calculate() {
        int categoriesCount = this.valuesCount.size();
        float missingPropertiesRatio = (float)this.missingPropertiesCount / (float)this.propertiesCount;
        int totalValuesCount = this.valuesCount.values().stream().reduce(0, Integer::sum);
        CategoriesDistribution categoriesDistribution = null;
        Float cardinality = null;
        if (this.valuesCount.size() <= 1000) {
            if (PropertyStatsCounter.isDistributionMeaningful((float)missingPropertiesRatio, (int)categoriesCount)) {
                categoriesDistribution = this.calculateCategoriesDistribution(totalValuesCount);
            } else {
                cardinality = Float.valueOf(PropertyStatsCounter.calculateCardinality((int)totalValuesCount, (int)categoriesCount));
            }
        }
        float multiValuedPropertiesRatio = (float)this.multiValuedPropertiesCount / (float)this.propertiesCount;
        return new PropertyStats(this.propertyPath, multiValuedPropertiesRatio, missingPropertiesRatio, cardinality, categoriesDistribution);
    }

    private void countSingleValue(@Nullable Object realValue) {
        String value;
        if (realValue == null) {
            ++this.missingPropertiesCount;
            return;
        }
        if (realValue instanceof byte[]) {
            byte[] byteArray = (byte[])realValue;
            value = String.valueOf(Arrays.hashCode(byteArray));
        } else {
            value = realValue.toString();
        }
        if (this.valuesCount.size() <= 1000) {
            this.valuesCount.merge(value, 1, Integer::sum);
        }
    }

    private static boolean isDistributionMeaningful(float missingPropertiesRatio, int uniqueValuesCount) {
        return missingPropertiesRatio < 1.0f && uniqueValuesCount < 20;
    }

    private CategoriesDistribution calculateCategoriesDistribution(int totalValuesCount) {
        List<Float> distribution = this.valuesCount.values().stream().map(count -> Float.valueOf((float)count.intValue() / (float)totalValuesCount)).toList();
        return new CategoriesDistribution(distribution);
    }

    private static float calculateCardinality(int totalValuesCount, int categoriesCount) {
        if (totalValuesCount == 0) {
            return 0.0f;
        }
        return (float)categoriesCount / (float)totalValuesCount;
    }
}

