/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.stats;

import com.evolveum.midpoint.ninja.action.BasicExportOptions;
import com.evolveum.midpoint.ninja.action.ExportOptions;
import com.evolveum.midpoint.ninja.action.stats.StatsCounter;
import com.evolveum.midpoint.ninja.action.worker.AbstractWriterConsumerWorker;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemFactory;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismSerializer;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.SerializationOptions;
import com.evolveum.midpoint.prism.path.ItemName;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_3.ObjectType;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.BlockingQueue;
import javax.xml.namespace.QName;

public class ExportFocusStatisticsWorker
extends AbstractWriterConsumerWorker<ExportOptions, ObjectType> {
    private static final ItemName C_FOCUS_STATS = new ItemName("http://midpoint.evolveum.com/xml/ns/public/common/common-3", "focusStats");
    private final StatsCounter statsCounter;

    public ExportFocusStatisticsWorker(NinjaContext context, ExportOptions options, BlockingQueue<ObjectType> queue, OperationStatus operation, StatsCounter statsCounter) {
        super(context, (BasicExportOptions)options, queue, operation);
        this.statsCounter = statsCounter;
    }

    protected String getProlog() {
        return "";
    }

    protected void write(Writer writer, ObjectType object) throws SchemaException, IOException {
        this.statsCounter.count(object);
    }

    protected String getEpilog() {
        try {
            PrismSerializer serializer = this.context.getPrismContext().xmlSerializer().options(SerializationOptions.createSerializeForExport());
            ItemFactory itemFactory = this.context.getPrismContext().itemFactory();
            PrismContainer focusStats = itemFactory.createContainer((QName)C_FOCUS_STATS);
            focusStats.add((PrismValue)this.statsCounter.calculate().asPrismContainerValue(itemFactory));
            return (String)serializer.serialize((Item)focusStats);
        }
        catch (SchemaException e) {
            throw new RuntimeException(e);
        }
    }
}

