/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.mining;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.evolveum.midpoint.common.RoleMiningExportUtils;
import com.evolveum.midpoint.ninja.action.BasicExportOptions;
import com.evolveum.midpoint.ninja.action.mining.BaseMiningOptions;
import com.evolveum.midpoint.ninja.util.ItemPathConverter;
import com.evolveum.midpoint.prism.path.ItemPath;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Parameters(resourceBundle="messages", commandDescriptionKey="exportMining")
public class ExportMiningOptions
extends BaseMiningOptions
implements BasicExportOptions {
    private static final String DELIMITER = ",";
    public static final String P_OUTPUT = "-o";
    public static final String P_OUTPUT_LONG = "--output";
    public static final String P_OVERWRITE = "-O";
    public static final String P_OVERWRITE_LONG = "--overwrite";
    public static final String P_PREFIX_APPLICATION = "-arp";
    public static final String P_PREFIX_APPLICATION_LONG = "--application-role-prefix";
    public static final String P_PREFIX_BUSINESS = "-brp";
    public static final String P_PREFIX_BUSINESS_LONG = "--business-role-prefix";
    public static final String P_SUFFIX_APPLICATION = "-ars";
    public static final String P_SUFFIX_APPLICATION_LONG = "--application-role-suffix";
    public static final String P_SUFFIX_BUSINESS = "-brs";
    public static final String P_SUFFIX_BUSINESS_LONG = "--business-role-suffix";
    public static final String P_ORG = "-do";
    public static final String P_ORG_LONG = "--disable-org";
    public static final String P_ATTRIBUTE = "-da";
    public static final String P_ATTRIBUTE_LONG = "--disable-attribute";
    public static final String P_EXCLUDE_ATTRIBUTES_USER_LONG = "--exclude-user-attribute";
    public static final String P_EXCLUDE_ATTRIBUTES_ROLE_LONG = "--exclude-role-attribute";
    public static final String P_EXCLUDE_ATTRIBUTES_ORG_LONG = "--exclude-org-attribute";
    public static final String P_ANONYMIZE_ATTRIBUTE_NAMES = "--anonymize-attribute-names";
    public static final String P_ANONYMIZE_ORDINAL_ATTRIBUTE_VALUES = "--anonymize-ordinal-attribute-values";
    public static final String P_NAME_OPTIONS = "-nm";
    public static final String P_NAME_OPTIONS_LONG = "--name-mode";
    public static final String P_ARCHETYPE_OID_APPLICATION_LONG = "--application-role-archetype-oid";
    public static final String P_ARCHETYPE_OID_BUSINESS_LONG = "--business-role-archetype-oid";
    public static final String P_SECURITY_LEVEL = "-s";
    public static final String P_SECURITY_LEVEL_LONG = "--security";
    @Parameter(names={"-s", "--security"}, descriptionKey="export.security.level")
    private RoleMiningExportUtils.SecurityMode securityMode = RoleMiningExportUtils.SecurityMode.ADVANCED;
    @Parameter(names={"-ars", "--application-role-suffix"}, descriptionKey="export.application.role.suffix")
    private String applicationRoleSuffix;
    @Parameter(names={"-brs", "--business-role-suffix"}, descriptionKey="export.business.role.suffix")
    private String businessRoleSuffix;
    @Parameter(names={"-o", "--output"}, descriptionKey="export.output")
    private File output;
    @Parameter(names={"-O", "--overwrite"}, descriptionKey="export.overwrite")
    private boolean overwrite;
    @Parameter(names={"-brp", "--business-role-prefix"}, descriptionKey="export.business.role.prefix")
    private String businessRolePrefix;
    @Parameter(names={"-arp", "--application-role-prefix"}, descriptionKey="export.application.role.prefix")
    private String applicationRolePrefix;
    @Parameter(names={"-do", "--disable-org"}, descriptionKey="export.prevent.org")
    private boolean disableOrg = false;
    @Parameter(names={"-da", "--disable-attribute"}, descriptionKey="export.prevent.attribute")
    private boolean disableAttribute = false;
    @Parameter(names={"-nm", "--name-mode"}, descriptionKey="export.name.options")
    private RoleMiningExportUtils.NameMode nameMode = RoleMiningExportUtils.NameMode.SEQUENTIAL;
    @Parameter(names={"--application-role-archetype-oid"}, descriptionKey="export.application.role.archetype.oid")
    private String applicationRoleArchetypeOid = "00000000-0000-0000-0000-000000000328";
    @Parameter(names={"--business-role-archetype-oid"}, descriptionKey="export.business.role.archetype.oid")
    private String businessRoleArchetypeOid = "00000000-0000-0000-0000-000000000321";
    @Parameter(names={"--exclude-user-attribute"}, descriptionKey="export.exclude.attributes.user", validateWith={ItemPathConverter.class}, converter=ItemPathConverter.class)
    private List<ItemPath> excludedAttributesUser = new ArrayList();
    @Parameter(names={"--exclude-role-attribute"}, descriptionKey="export.exclude.attributes.role", validateWith={ItemPathConverter.class}, converter=ItemPathConverter.class)
    private List<ItemPath> excludedAttributesRole = new ArrayList();
    @Parameter(names={"--exclude-org-attribute"}, descriptionKey="export.exclude.attributes.org", validateWith={ItemPathConverter.class}, converter=ItemPathConverter.class)
    private List<ItemPath> excludedAttributesOrg = new ArrayList();
    @Parameter(names={"--anonymize-attribute-names"}, descriptionKey="export.anonymizeAttributeNames")
    private Boolean anonymizeAttributeNames = false;
    @Parameter(names={"--anonymize-ordinal-attribute-values"}, descriptionKey="export.anonymizeOrdinalAttributeValues")
    private Boolean anonymizeOrdinalAttributeValues = false;

    public RoleMiningExportUtils.SecurityMode getSecurityLevel() {
        return this.securityMode;
    }

    public boolean isIncludeOrg() {
        return !this.disableOrg;
    }

    public boolean isIncludeAttributes() {
        return !this.disableAttribute;
    }

    public String getApplicationRoleArchetypeOid() {
        return this.applicationRoleArchetypeOid;
    }

    public String getBusinessRoleArchetypeOid() {
        return this.businessRoleArchetypeOid;
    }

    public RoleMiningExportUtils.NameMode getNameMode() {
        return this.nameMode;
    }

    public File getOutput() {
        return this.output;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public List<String> getApplicationRolePrefix() {
        if (this.applicationRolePrefix == null || this.applicationRolePrefix.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] separatePrefixes = this.applicationRolePrefix.split(DELIMITER);
        return new ArrayList<String>(Arrays.asList(separatePrefixes));
    }

    public List<String> getBusinessRolePrefix() {
        if (this.businessRolePrefix == null || this.businessRolePrefix.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] separatePrefixes = this.businessRolePrefix.split(DELIMITER);
        return new ArrayList<String>(Arrays.asList(separatePrefixes));
    }

    public List<String> getApplicationRoleSuffix() {
        if (this.applicationRoleSuffix == null || this.applicationRoleSuffix.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] separateSuffixes = this.applicationRoleSuffix.split(DELIMITER);
        return new ArrayList<String>(Arrays.asList(separateSuffixes));
    }

    public List<String> getBusinessRoleSuffix() {
        if (this.businessRoleSuffix == null || this.businessRoleSuffix.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] separateSuffixes = this.businessRoleSuffix.split(DELIMITER);
        return new ArrayList<String>(Arrays.asList(separateSuffixes));
    }

    private List<String> itemPathsToStrings(List<ItemPath> itemPaths) {
        return itemPaths.stream().map(Object::toString).toList();
    }

    public List<String> getExcludedAttributesUser() {
        return this.itemPathsToStrings(this.excludedAttributesUser);
    }

    public List<String> getExcludedAttributesRole() {
        return this.itemPathsToStrings(this.excludedAttributesRole);
    }

    public List<String> getExcludedAttributesOrg() {
        return this.itemPathsToStrings(this.excludedAttributesOrg);
    }

    public Boolean isAnonymizeAttributeNames() {
        return this.anonymizeAttributeNames;
    }

    public Boolean isAnonymizeOrdinalAttributeValues() {
        return this.anonymizeOrdinalAttributeValues;
    }
}

