/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action.audit;

import com.evolveum.midpoint.ninja.action.BasicExportOptions;
import com.evolveum.midpoint.ninja.action.audit.AuditRecordValidator;
import com.evolveum.midpoint.ninja.action.audit.VerifyAuditConsumerWorker;
import com.evolveum.midpoint.ninja.action.audit.VerifyAuditOptions;
import com.evolveum.midpoint.ninja.action.worker.AbstractWriterConsumerWorker;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.util.OperationStatus;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.schema.validator.ObjectValidator;
import com.evolveum.midpoint.schema.validator.ValidationItem;
import com.evolveum.midpoint.schema.validator.ValidationResult;
import com.evolveum.midpoint.util.LocalizableMessage;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.audit_3.AuditEventRecordType;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;

public class VerifyAuditConsumerWorker
extends AbstractWriterConsumerWorker<VerifyAuditOptions, AuditEventRecordType> {
    private static final CSVFormat CSV_FORMAT = VerifyAuditConsumerWorker.createCsvFormat();
    public static final List<String> REPORT_HEADER = List.of("Repo Id", "Timestamp", "Status", "Item path", "Message");
    private long recordsWithIssue = 0L;
    private long unknownCount = 0L;
    private long errorCount = 0L;
    private long warningCount = 0L;
    AuditRecordValidator validator;

    public VerifyAuditConsumerWorker(NinjaContext context, VerifyAuditOptions options, BlockingQueue<AuditEventRecordType> queue, OperationStatus operation) {
        super(context, (BasicExportOptions)options, queue, operation);
    }

    protected void init() {
        ObjectValidator objValidator = new ObjectValidator(PrismContext.get());
        objValidator.setWarnIncorrectOids(true);
        this.validator = new AuditRecordValidator(objValidator);
    }

    protected void write(Writer writer, AuditEventRecordType object) throws SchemaException, IOException {
        ValidationResult result = this.validator.validate(object);
        if (result.isEmpty()) {
            return;
        }
        this.increaseStats(result);
        if (this.isCsv()) {
            this.writeCsvResult(writer, result, object);
        } else {
            this.writePlainResult(writer, result, object);
        }
    }

    private void increaseStats(ValidationResult result) {
        ++this.recordsWithIssue;
        for (ValidationItem item : result.getItems()) {
            OperationResultStatus status = item.getStatus() != null ? item.getStatus() : OperationResultStatus.UNKNOWN;
            this.increaseCounter(status);
        }
    }

    private void increaseCounter(OperationResultStatus status) {
        switch (1.$SwitchMap$com$evolveum$midpoint$schema$result$OperationResultStatus[status.ordinal()]) {
            case 1: {
                ++this.unknownCount;
                break;
            }
            case 2: {
                ++this.warningCount;
                break;
            }
            case 3: 
            case 4: {
                ++this.errorCount;
            }
        }
    }

    private void writeCsvResult(Writer writer, ValidationResult result, AuditEventRecordType object) throws IOException {
        CSVPrinter printer = CSV_FORMAT.print((Appendable)writer);
        for (ValidationItem item : result.getItems()) {
            printer.printRecord((Iterable)this.createCsvRecord(item, object));
        }
    }

    private List<Object> createCsvRecord(ValidationItem item, AuditEventRecordType record) {
        return List.of(record.getRepoId(), record.getTimestamp(), item.getStatus(), item.getItemPath(), this.getMessage(item.getMessage()));
    }

    private void writePlainResult(Writer writer, ValidationResult result, AuditEventRecordType audit) throws IOException {
        for (ValidationItem item : result.getItems()) {
            this.plainWrite(writer, new Object[]{item.getStatus(), audit.getTimestamp(), audit.getRepoId(), item.getItemPath(), this.getMessage(item.getMessage())});
        }
    }

    private void plainWrite(Writer writer, Object ... args) throws IOException {
        StringBuilder line = new StringBuilder();
        if (args != null && args.length > 0) {
            boolean first = true;
            for (Object obj : args) {
                if (!first) {
                    line.append(' ');
                }
                line.append(obj);
                first = false;
            }
        }
        line.append('\n');
        writer.write(line.toString());
    }

    private String getMessage(LocalizableMessage message) {
        if (message == null) {
            return null;
        }
        return message.getFallbackMessage();
    }

    private boolean isCsv() {
        return ((VerifyAuditOptions)this.options).getReportStyle() == VerifyAuditOptions.ReportStyle.CSV;
    }

    public String getProlog() {
        if (this.isCsv()) {
            try {
                StringWriter writer = new StringWriter();
                CSVPrinter printer = CSV_FORMAT.print((Appendable)writer);
                printer.printRecord((Iterable)REPORT_HEADER);
                return writer.toString();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Couldn't write CSV header", ex);
            }
        }
        return null;
    }

    protected String getEpilog() {
        return null;
    }

    private static CSVFormat createCsvFormat() {
        return CSVFormat.Builder.create().setDelimiter(';').setEscape('\\').setIgnoreHeaderCase(false).setQuote('\"').setRecordSeparator('\n').setQuoteMode(QuoteMode.ALL).build();
    }

    public long getRecordsWithIssueCount() {
        return this.recordsWithIssue;
    }

    public long getRecordsWithIssue() {
        return this.recordsWithIssue;
    }

    public long getUnknownCount() {
        return this.unknownCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getWarningCount() {
        return this.warningCount;
    }
}

