/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.schema.validator.UpgradePriority;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class VerifyResult {
    private File verificationFile;
    private Map<UpgradePriority, Long> priorities = new HashMap();
    private Long unknown = 0L;

    public boolean hasCriticalItems() {
        return this.hasPriorityItem(UpgradePriority.CRITICAL);
    }

    public void incrementCriticalCount() {
        this.incrementPriorityItemCount(UpgradePriority.CRITICAL);
    }

    public boolean hasNecessaryItems() {
        return this.hasPriorityItem(UpgradePriority.NECESSARY);
    }

    public void incrementNecessaryCount() {
        this.incrementPriorityItemCount(UpgradePriority.NECESSARY);
    }

    public boolean hasOptionalItems() {
        return this.hasPriorityItem(UpgradePriority.OPTIONAL);
    }

    public void incrementOptionalCount() {
        this.incrementPriorityItemCount(UpgradePriority.OPTIONAL);
    }

    public synchronized void incrementUnknownCount() {
        Long l = this.unknown;
        this.unknown = this.unknown + 1L;
    }

    public synchronized boolean hasPriorityItem(UpgradePriority priority) {
        return this.getItemPriorityCount(priority) > 0L;
    }

    public synchronized long getItemPriorityCount(UpgradePriority priority) {
        Long count = (Long)this.priorities.get(priority);
        return count != null ? count : 0L;
    }

    public synchronized void incrementPriorityItemCount(UpgradePriority priority) {
        long count = this.getItemPriorityCount(priority);
        this.priorities.put(priority, ++count);
    }

    public long getCriticalCount() {
        return this.getItemPriorityCount(UpgradePriority.CRITICAL);
    }

    public long getNecessaryCount() {
        return this.getItemPriorityCount(UpgradePriority.NECESSARY);
    }

    public long getOptionalCount() {
        return this.getItemPriorityCount(UpgradePriority.OPTIONAL);
    }

    public long getUnknownCount() {
        return this.unknown;
    }

    public File getVerificationFile() {
        return this.verificationFile;
    }

    public void setVerificationFile(File verificationFile) {
        this.verificationFile = verificationFile;
    }
}

