/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.ninja.action.Action;
import com.evolveum.midpoint.ninja.action.ConnectionOptions;
import com.evolveum.midpoint.ninja.action.RunSqlOptions;
import com.evolveum.midpoint.ninja.impl.NinjaApplicationContextLevel;
import com.evolveum.midpoint.ninja.util.ConsoleFormat;
import com.evolveum.midpoint.ninja.util.InputParameterException;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.repo.api.RepositoryServiceFactoryException;
import com.evolveum.midpoint.repo.sqale.SqaleRepositoryConfiguration;
import com.evolveum.midpoint.repo.sqale.audit.SqaleAuditServiceFactory;
import com.evolveum.midpoint.repo.sqlbase.DataSourceFactory;
import com.evolveum.midpoint.repo.sqlbase.JdbcRepositoryConfiguration;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationContext;

public class RunSqlAction
extends Action<RunSqlOptions, Void> {
    public String getOperationName() {
        return "run sql scripts";
    }

    @NotNull
    public NinjaApplicationContextLevel getApplicationContextLevel(List<Object> allOptions) {
        if (this.preferCustomJdbcConnection(allOptions)) {
            return NinjaApplicationContextLevel.NONE;
        }
        return NinjaApplicationContextLevel.STARTUP_CONFIGURATION;
    }

    private boolean preferCustomJdbcConnection(List<Object> allOptions) {
        RunSqlOptions opts = (RunSqlOptions)NinjaUtils.getOptions(allOptions, RunSqlOptions.class);
        if (opts != null && StringUtils.isNotEmpty((CharSequence)opts.getJdbcUrl()) && StringUtils.isNotEmpty((CharSequence)opts.getJdbcUsername())) {
            return true;
        }
        ConnectionOptions connectionOpts = (ConnectionOptions)NinjaUtils.getOptions(allOptions, ConnectionOptions.class);
        return connectionOpts == null || StringUtils.isEmpty((CharSequence)connectionOpts.getMidpointHome());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void execute() throws Exception {
        DataSource auditDataSource;
        DataSource repositoryDataSource;
        block15: {
            MidpointConfiguration midpointConfiguration;
            RunSqlOptions.Mode mode;
            block14: {
                Void void_;
                mode = ((RunSqlOptions)this.options).getMode();
                if (mode == null) {
                    mode = this.preferCustomJdbcConnection(this.context.getAllOptions()) ? RunSqlOptions.Mode.RAW : RunSqlOptions.Mode.REPOSITORY;
                }
                this.setScriptsDefaults(mode, (RunSqlOptions)this.options);
                if (mode == RunSqlOptions.Mode.RAW || this.preferCustomJdbcConnection(this.context.getAllOptions())) {
                    this.log.info("Running scripts in raw mode using custom JDBC url/username/password options.", new Object[0]);
                    if (((RunSqlOptions)this.options).getScripts().isEmpty()) {
                        this.log.warn("No scripts to run.", new Object[0]);
                        return null;
                    }
                    try (HikariDataSource dataSource = this.setupCustomDataSource();){
                        this.executeScripts((DataSource)dataSource, ((RunSqlOptions)this.options).getScripts());
                    }
                    return null;
                }
                this.log.info(ConsoleFormat.formatMessageWithInfoParameters((String)"Running scripts against midpoint {}.", (Object[])new Object[]{mode.name().toLowerCase()}), new Object[0]);
                ApplicationContext applicationContext = this.context.getApplicationContext();
                midpointConfiguration = (MidpointConfiguration)applicationContext.getBean(MidpointConfiguration.class);
                repositoryDataSource = null;
                auditDataSource = null;
                try {
                    Configuration configuration = midpointConfiguration.getConfiguration("midpoint.repository");
                    repositoryDataSource = this.createDataSource(configuration, "ninja-repository");
                    if (mode != RunSqlOptions.Mode.REPOSITORY) break block14;
                    this.executeScripts(repositoryDataSource, ((RunSqlOptions)this.options).getScripts());
                    void_ = null;
                }
                catch (Throwable throwable) {
                    this.closeQuietly(repositoryDataSource);
                    this.closeQuietly(auditDataSource);
                    throw throwable;
                }
                this.closeQuietly(repositoryDataSource);
                this.closeQuietly(auditDataSource);
                return void_;
            }
            if (mode != RunSqlOptions.Mode.AUDIT) break block15;
            auditDataSource = this.createAuditDataSource(repositoryDataSource, midpointConfiguration);
            if (auditDataSource != null) {
                this.executeScripts(auditDataSource, ((RunSqlOptions)this.options).getScripts());
                break block15;
            }
            this.log.error("Audit configuration not found in " + midpointConfiguration.getMidpointHome() + "/config.xml", new Object[0]);
        }
        this.closeQuietly(repositoryDataSource);
        this.closeQuietly(auditDataSource);
        return null;
    }

    private void setScriptsDefaults(RunSqlOptions.Mode mode, RunSqlOptions options) {
        if (!options.getScripts().isEmpty()) {
            return;
        }
        if (options.getCreate()) {
            options.setScripts(mode.createScripts);
        } else if (options.getUpgrade()) {
            options.setScripts(mode.updateScripts);
        }
    }

    private HikariDataSource setupCustomDataSource() {
        if (StringUtils.isEmpty((CharSequence)((RunSqlOptions)this.options).getJdbcUrl())) {
            throw new InputParameterException("JDBC url parameter not defined");
        }
        if (StringUtils.isEmpty((CharSequence)((RunSqlOptions)this.options).getJdbcUsername())) {
            throw new InputParameterException("JDBC username parameter not defined");
        }
        if (StringUtils.isEmpty((CharSequence)((RunSqlOptions)this.options).getPassword())) {
            throw new InputParameterException("JDBC password parameter not defined");
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(((RunSqlOptions)this.options).getJdbcUrl());
        config.setUsername(((RunSqlOptions)this.options).getJdbcUsername());
        config.setPassword(((RunSqlOptions)this.options).getPassword());
        config.setDriverClassName("org.postgresql.Driver");
        config.setAutoCommit(true);
        config.setMinimumIdle(1);
        config.setMaximumPoolSize(5);
        config.setPoolName("ninja-custom-jdbc");
        return new HikariDataSource(config);
    }

    private DataSource createDataSource(Configuration configuration, String name) throws RepositoryServiceFactoryException {
        this.log.info("Creating connection for " + name, new Object[0]);
        SqaleRepositoryConfiguration repositoryConfiguration = new SqaleRepositoryConfiguration(configuration);
        repositoryConfiguration.init();
        DataSourceFactory dataSourceFactory = new DataSourceFactory((JdbcRepositoryConfiguration)repositoryConfiguration);
        return dataSourceFactory.createDataSource(name);
    }

    private DataSource createAuditDataSource(DataSource repositoryDataSource, MidpointConfiguration midpointConfiguration) throws RepositoryServiceFactoryException {
        Configuration config = midpointConfiguration.getConfiguration("midpoint.audit");
        List auditServices = ((BaseHierarchicalConfiguration)config).configurationsAt("auditService");
        Configuration auditServiceConfig = null;
        for (Configuration serviceConfig : auditServices) {
            String className = serviceConfig.getString("auditServiceFactoryClass");
            if (!SqaleAuditServiceFactory.class.getName().equals(className)) continue;
            auditServiceConfig = serviceConfig;
            break;
        }
        if (auditServiceConfig == null) {
            return null;
        }
        if (auditServiceConfig.getString("jdbcUrl") == null && auditServiceConfig.getString("dataSource") == null) {
            return repositoryDataSource;
        }
        return this.createDataSource(auditServiceConfig, "ninja-audit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScripts(@NotNull DataSource dataSource, @NotNull List<File> scripts) throws IOException, SQLException {
        try (Connection connection = dataSource.getConnection();){
            boolean autocommit = connection.getAutoCommit();
            connection.setAutoCommit(true);
            try {
                for (File script : scripts) {
                    this.log.info("Executing script {}", new Object[]{script.getPath()});
                    Statement stmt = connection.createStatement();
                    String sql = FileUtils.readFileToString((File)script, (Charset)StandardCharsets.UTF_8);
                    boolean hasResult = stmt.execute(sql);
                    if (((RunSqlOptions)this.options).getResult()) {
                        int index = 0;
                        this.printStatementResults(stmt, hasResult, index);
                        do {
                            hasResult = stmt.getMoreResults();
                            this.printStatementResults(stmt, hasResult, ++index);
                        } while (hasResult || stmt.getUpdateCount() != -1);
                    }
                    stmt.close();
                }
                this.log.info(ConsoleFormat.formatSuccessMessage((String)"Scripts executed successfully."), new Object[0]);
            }
            finally {
                connection.setAutoCommit(autocommit);
            }
        }
    }

    private void printStatementResults(Statement stmt, boolean hasResult, int index) throws SQLException {
        String resultHeader = ConsoleFormat.formatMessageWithInfoParameters((String)"Result #{}", (Object[])new Object[]{index}) + ": ";
        if (!hasResult) {
            int updateCount = stmt.getUpdateCount();
            if (updateCount != -1) {
                this.context.out.println(resultHeader + updateCount + " updated rows ");
            }
            return;
        }
        this.context.out.println(resultHeader);
        try (ResultSet set = stmt.getResultSet();){
            this.printResultSet(set);
        }
    }

    private void printResultSet(ResultSet set) throws SQLException {
        int i;
        ResultSetMetaData metaData = set.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList<String> row = new ArrayList<String>();
        for (i = 1; i <= columnCount; ++i) {
            row.add(metaData.getColumnLabel(i));
        }
        this.context.out.println(StringUtils.join(row, (String)"|"));
        row.clear();
        while (set.next()) {
            for (i = 1; i <= columnCount; ++i) {
                Object obj = set.getObject(i);
                row.add(obj != null ? obj.toString() : "");
            }
            this.context.out.println(StringUtils.join(row, (String)"|"));
            row.clear();
        }
    }

    private void closeQuietly(DataSource dataSource) {
        if (dataSource instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)((Object)dataSource)));
        }
    }
}

