/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.ninja.action.InfoOptions;
import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.LabeledString;
import com.evolveum.midpoint.schema.RepositoryDiag;
import com.evolveum.midpoint.schema.result.OperationResult;

public class InfoRepositoryAction
extends RepositoryAction<InfoOptions, Void> {
    public String getOperationName() {
        return "get repository information";
    }

    public Void execute() {
        MidpointConfiguration config = this.context.getMidpointConfiguration();
        this.context.out.println("MidPoint home: " + config.getMidpointHome());
        this.context.out.println("Java home: " + System.getProperty("java.home"));
        RepositoryService repository = this.context.getRepository();
        OperationResult repoTestResult = new OperationResult("repo.test");
        repository.repositorySelfTest(repoTestResult);
        repoTestResult.close();
        this.context.out.println("Repository test: " + repoTestResult.getStatus());
        try {
            RepositoryDiag repositoryDiag = repository.getRepositoryDiag();
            this.context.out.println("Repository diag:\n Type: " + repositoryDiag.getImplementationShortName() + "\n Description: " + repositoryDiag.getImplementationDescription() + "\n JDBC URL: " + repositoryDiag.getRepositoryUrl() + "\n Driver type: " + repositoryDiag.getDriverShortName() + "\n Driver version: " + repositoryDiag.getDriverVersion() + "\n Additional details:");
            for (LabeledString detail : repositoryDiag.getAdditionalDetails()) {
                this.context.out.println(" - " + detail.getLabel() + ": " + detail.getData());
            }
        }
        catch (Exception e) {
            this.context.err.println("Unexpected problem during repo diag: " + e);
        }
        return null;
    }
}

