/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.ninja.action;

import com.evolveum.midpoint.ninja.action.CountOptions;
import com.evolveum.midpoint.ninja.action.RepositoryAction;
import com.evolveum.midpoint.ninja.impl.LogTarget;
import com.evolveum.midpoint.ninja.impl.NinjaContext;
import com.evolveum.midpoint.ninja.impl.NinjaException;
import com.evolveum.midpoint.ninja.util.FileReference;
import com.evolveum.midpoint.ninja.util.NinjaUtils;
import com.evolveum.midpoint.prism.query.ObjectQuery;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CountRepositoryAction
extends RepositoryAction<CountOptions, Void> {
    private static final String DOT_CLASS = CountRepositoryAction.class.getName() + ".";
    private static final String OPERATION_COUNT = DOT_CLASS + "count";

    public String getOperationName() {
        return "count objects";
    }

    public LogTarget getLogTarget() {
        return LogTarget.SYSTEM_ERR;
    }

    public Void execute() throws Exception {
        RepositoryService repository = this.context.getRepository();
        FileReference fileReference = ((CountOptions)this.options).getFilter();
        if (fileReference != null && ((CountOptions)this.options).getFilter() == null) {
            throw new NinjaException("Type must be defined");
        }
        List types = NinjaUtils.getTypes((Set)((CountOptions)this.options).getType(), List.of(ObjectTypes.values()));
        int total = 0;
        OperationResult result = new OperationResult(OPERATION_COUNT);
        for (ObjectTypes type : types) {
            ObjectQuery query = NinjaUtils.createObjectQuery((FileReference)((CountOptions)this.options).getFilter(), (NinjaContext)this.context, (Class)type.getClassDefinition());
            int count = repository.countObjects(type.getClassDefinition(), query, new ArrayList(), result);
            if (count == 0 && ((CountOptions)this.options).getType() == null) continue;
            this.log.info("{}:\t{}", new Object[]{type.name(), count});
            total += count;
        }
        this.log.info("===\nTotal:\t{}", new Object[]{total});
        return null;
    }
}

