/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.yui.calendar;

import java.lang.reflect.Method;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.yui.YuiLib;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.DateConverter;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.template.PackageTextTemplate;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePicker
extends Behavior {
    private static Method GETINSTANCEMETHOD = null;
    public static String FORMAT_DATE;
    public static String FORMAT_PAGEDATE;
    private static final ResourceReference YUI;
    private static final ResourceReference WICKET_DATE;
    private static final long serialVersionUID = 1L;
    private Component component;
    private boolean showOnFieldClick = false;
    private boolean autoHide = false;

    public void bind(Component component) {
        this.component = component;
        this.checkComponentProvidesDateFormat(component);
        component.setOutputMarkupId(true);
    }

    public void afterRender(Component component) {
        super.afterRender(component);
        Response response = component.getResponse();
        response.write((CharSequence)"\n<span class=\"yui-skin-sam\">&nbsp;<span style=\"");
        if (this.renderOnLoad()) {
            response.write((CharSequence)"display:block;");
        } else {
            response.write((CharSequence)"display:none;");
            response.write((CharSequence)"position:absolute;");
        }
        response.write((CharSequence)"z-index: 99999;\" id=\"");
        response.write((CharSequence)this.getEscapedComponentMarkupId());
        response.write((CharSequence)"Dp\"></span><img style=\"");
        response.write((CharSequence)this.getIconStyle());
        response.write((CharSequence)"\" id=\"");
        response.write((CharSequence)this.getIconId());
        response.write((CharSequence)"\" src=\"");
        CharSequence iconUrl = this.getIconUrl();
        response.write(Strings.escapeMarkup((CharSequence)(iconUrl != null ? ((Object)iconUrl).toString() : "")));
        response.write((CharSequence)"\" alt=\"");
        CharSequence alt = this.getIconAltText();
        response.write(Strings.escapeMarkup((CharSequence)(alt != null ? ((Object)alt).toString() : "")));
        response.write((CharSequence)"\" title=\"");
        CharSequence title = this.getIconTitle();
        response.write(Strings.escapeMarkup((CharSequence)(title != null ? ((Object)title).toString() : "")));
        response.write((CharSequence)"\"/>");
        if (this.renderOnLoad()) {
            response.write((CharSequence)"<br style=\"clear:left;\"/>");
        }
        response.write((CharSequence)"</span>");
    }

    protected boolean includeYUILibraries() {
        return true;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        if (this.includeYUILibraries()) {
            YuiLib.load(response);
        }
        this.renderHeadInit(response);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        String widgetId = this.getEscapedComponentMarkupId();
        variables.put("componentId", this.getComponentMarkupId());
        variables.put("widgetId", widgetId);
        variables.put("datePattern", this.getDatePattern());
        variables.put("fireChangeEvent", this.notifyComponentOnDateSelected());
        variables.put("alignWithIcon", this.alignWithIcon());
        variables.put("hideOnSelect", this.hideOnSelect());
        variables.put("showOnFieldClick", this.showOnFieldClick());
        variables.put("autoHide", this.autoHide());
        String script = this.getAdditionalJavaScript();
        if (script != null) {
            variables.put("additionalJavascript", Strings.replaceAll((CharSequence)script, (CharSequence)"${calendar}", (CharSequence)("YAHOO.wicket." + widgetId + "DpJs")));
        }
        LinkedHashMap<String, Object> p = new LinkedHashMap<String, Object>();
        this.configure(p, response, variables);
        if (!p.containsKey("navigator") && this.enableMonthYearSelection()) {
            p.put("navigator", Boolean.TRUE);
        }
        if (this.enableMonthYearSelection() && p.containsKey("pages") && Objects.longValue(p.get("pages")) > 1L) {
            throw new IllegalStateException("You cannot use a CalendarGroup with month/year selection!");
        }
        StringBuilder calendarInit = new StringBuilder();
        this.appendMapping(p, calendarInit);
        variables.put("calendarInit", calendarInit.toString());
        PackageTextTemplate datePickerJs = new PackageTextTemplate(DatePicker.class, "DatePicker.js");
        datePickerJs.interpolate(variables);
        response.renderOnDomReadyJavaScript(datePickerJs.asString());
        if (AjaxRequestTarget.get() != null) {
            String escapedComponentMarkupId = this.getEscapedComponentMarkupId();
            String javascript = "var e = Wicket.$('" + escapedComponentMarkupId + "Dp" + "'); if (e != null && typeof(e.parentNode) != 'undefined' && " + "typeof(e.parentNode.parentNode != 'undefined')) {" + "e.parentNode.parentNode.removeChild(e.parentNode);" + "YAHOO.wicket." + escapedComponentMarkupId + "DpJs.destroy(); delete YAHOO.wicket." + escapedComponentMarkupId + "DpJs;}";
            AjaxRequestTarget.get().prependJavaScript((CharSequence)javascript);
        }
    }

    protected void renderHeadInit(IHeaderResponse response) {
        String key = "DatePickerInit.js";
        if (response.wasRendered((Object)key)) {
            return;
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("basePath", Strings.stripJSessionId((String)((Object)RequestCycle.get().urlFor(YUI, null)).toString()) + "/");
        variables.put("wicketDatePath", RequestCycle.get().urlFor(WICKET_DATE, null));
        if (Application.get().usesDevelopmentConfig()) {
            variables.put("filter", "filter: \"RAW\",");
            variables.put("allowRollup", false);
        } else {
            variables.put("filter", "");
            variables.put("allowRollup", true);
        }
        PackageTextTemplate template = new PackageTextTemplate(DatePicker.class, key);
        response.renderOnDomReadyJavaScript(template.asString(variables));
        response.markRendered((Object)key);
    }

    private final void checkComponentProvidesDateFormat(Component component) {
        if (this.getDatePattern() == null) {
            throw new UnableToDetermineFormatException();
        }
    }

    private void setWidgetProperty(Map<String, Object> widgetProperties, String key, String[] array) {
        if (array != null && array.length > 0) {
            widgetProperties.put(key, array);
        }
    }

    protected boolean alignWithIcon() {
        return true;
    }

    protected void configure(Map<String, Object> widgetProperties, IHeaderResponse response, Map<String, Object> initVariables) {
        widgetProperties.put("close", true);
        this.localize(widgetProperties, response, initVariables);
        Object modelObject = this.component.getDefaultModelObject();
        if (modelObject instanceof Date) {
            Date date = (Date)modelObject;
            widgetProperties.put("selected", new SimpleDateFormat(FORMAT_DATE).format(date));
            widgetProperties.put("pagedate", new SimpleDateFormat(FORMAT_PAGEDATE).format(date));
        }
    }

    protected final String[] filterEmpty(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            if (Strings.isEmpty((CharSequence)string)) continue;
            list.add(string);
        }
        return list.toArray(new String[list.size()]);
    }

    protected final String getComponentMarkupId() {
        return this.component.getMarkupId();
    }

    protected String getDatePattern() {
        String format = null;
        if (this.component instanceof AbstractTextComponent.ITextFormatProvider) {
            format = ((AbstractTextComponent.ITextFormatProvider)this.component).getTextFormat();
        }
        if (format == null) {
            IConverter converter = this.component.getConverter(DateTime.class);
            if (!(converter instanceof DateConverter)) {
                converter = this.component.getConverter(Date.class);
            }
            format = ((SimpleDateFormat)((DateConverter)converter).getDateFormat(this.component.getLocale())).toPattern();
        }
        return format;
    }

    protected final String getEscapedComponentMarkupId() {
        return this.component.getMarkupId().replaceAll("\\W", "");
    }

    protected final String getIconId() {
        return this.getEscapedComponentMarkupId() + "Icon";
    }

    protected String getIconStyle() {
        return "cursor: pointer; border: none;";
    }

    protected CharSequence getIconTitle() {
        return "";
    }

    protected CharSequence getIconAltText() {
        return "";
    }

    protected CharSequence getIconUrl() {
        return RequestCycle.get().urlFor((IRequestHandler)new ResourceReferenceRequestHandler((ResourceReference)new PackageResourceReference(DatePicker.class, "icon1.gif")));
    }

    protected Locale getLocale() {
        return this.component.getLocale();
    }

    protected void localize(Map<String, Object> widgetProperties, IHeaderResponse response, Map<String, Object> initVariables) {
        Locale locale = this.getLocale();
        String key = "wicketCalendarI18n[\"" + locale.toString() + "\"]";
        initVariables.put("i18n", key);
        if (response.wasRendered((Object)key)) {
            return;
        }
        DateFormatSymbols dfSymbols = null;
        if (GETINSTANCEMETHOD != null) {
            try {
                dfSymbols = (DateFormatSymbols)GETINSTANCEMETHOD.invoke(null, locale);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (dfSymbols == null) {
            dfSymbols = new DateFormatSymbols(locale);
        }
        LinkedHashMap<String, Object> i18nVariables = new LinkedHashMap<String, Object>();
        this.setWidgetProperty(i18nVariables, "MONTHS_SHORT", this.filterEmpty(dfSymbols.getShortMonths()));
        this.setWidgetProperty(i18nVariables, "MONTHS_LONG", this.filterEmpty(dfSymbols.getMonths()));
        this.setWidgetProperty(i18nVariables, "WEEKDAYS_MEDIUM", this.filterEmpty(dfSymbols.getShortWeekdays()));
        this.setWidgetProperty(i18nVariables, "WEEKDAYS_LONG", this.filterEmpty(dfSymbols.getWeekdays()));
        i18nVariables.put("START_WEEKDAY", Calendar.getInstance(locale).getFirstDayOfWeek() - 1);
        if (Locale.SIMPLIFIED_CHINESE.equals(locale) || Locale.TRADITIONAL_CHINESE.equals(locale)) {
            this.setWidgetProperty(i18nVariables, "WEEKDAYS_1CHAR", this.filterEmpty(this.substring(dfSymbols.getShortWeekdays(), 2, 1)));
            i18nVariables.put("WEEKDAYS_SHORT", this.filterEmpty(this.substring(dfSymbols.getShortWeekdays(), 2, 1)));
        } else {
            this.setWidgetProperty(i18nVariables, "WEEKDAYS_1CHAR", this.filterEmpty(this.substring(dfSymbols.getShortWeekdays(), 0, 1)));
            this.setWidgetProperty(i18nVariables, "WEEKDAYS_SHORT", this.filterEmpty(this.substring(dfSymbols.getShortWeekdays(), 0, 2)));
        }
        StringBuilder i18n = new StringBuilder(key);
        i18n.append('=');
        this.appendMapping(i18nVariables, i18n);
        i18n.append(';');
        response.renderOnDomReadyJavaScript(i18n.toString());
        response.wasRendered((Object)key);
    }

    protected boolean notifyComponentOnDateSelected() {
        return true;
    }

    protected final String[] substring(String[] array, int len) {
        return this.substring(array, 0, len);
    }

    protected final String[] substring(String[] array, int start, int len) {
        if (array != null) {
            String[] copy = new String[array.length];
            for (int i = 0; i < array.length; ++i) {
                String el = array[i];
                if (el == null) continue;
                copy[i] = el.length() > start + len ? el.substring(start, start + len) : el;
            }
            return copy;
        }
        return null;
    }

    protected boolean enableMonthYearSelection() {
        return false;
    }

    protected boolean hideOnSelect() {
        return true;
    }

    protected boolean showOnFieldClick() {
        return this.showOnFieldClick;
    }

    public DatePicker setShowOnFieldClick(boolean show) {
        this.showOnFieldClick = show;
        return this;
    }

    protected boolean autoHide() {
        return this.autoHide;
    }

    public DatePicker setAutoHide(boolean autoHide) {
        this.autoHide = autoHide;
        return this;
    }

    protected boolean renderOnLoad() {
        return false;
    }

    protected String getAdditionalJavaScript() {
        return "";
    }

    public boolean isEnabled(Component component) {
        return component.isEnabledInHierarchy();
    }

    private void appendMapping(Map<String, Object> map, StringBuilder json) {
        json.append("{");
        Iterator<Map.Entry<String, Object>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Object> entry = i.next();
            json.append(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof CharSequence) {
                json.append(":\"");
                json.append(Strings.toEscapedUnicode((String)value.toString()));
                json.append("\"");
            } else if (value instanceof CharSequence[]) {
                json.append(":[");
                CharSequence[] valueArray = (CharSequence[])value;
                for (int j = 0; j < valueArray.length; ++j) {
                    CharSequence tmpValue = valueArray[j];
                    if (j > 0) {
                        json.append(",");
                    }
                    if (tmpValue == null) continue;
                    json.append("\"");
                    json.append(Strings.toEscapedUnicode((String)((Object)tmpValue).toString()));
                    json.append("\"");
                }
                json.append("]");
            } else if (value instanceof Map) {
                json.append(":");
                Map nmap = (Map)value;
                this.appendMapping(nmap, json);
            } else {
                json.append(":");
                json.append(Strings.toEscapedUnicode((String)String.valueOf(value)));
            }
            if (!i.hasNext()) continue;
            json.append(",");
        }
        json.append("}");
    }

    static {
        try {
            GETINSTANCEMETHOD = DateFormatSymbols.class.getMethod("getInstance", Locale.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FORMAT_DATE = "MM/dd/yyyy";
        FORMAT_PAGEDATE = "MM/yyyy";
        YUI = new JavaScriptResourceReference(YuiLib.class, "");
        WICKET_DATE = new JavaScriptResourceReference(DatePicker.class, "wicket-date.js");
    }

    private static final class UnableToDetermineFormatException
    extends WicketRuntimeException {
        private static final long serialVersionUID = 1L;

        public UnableToDetermineFormatException() {
            super("This behavior can only be added to components that either implement " + AbstractTextComponent.ITextFormatProvider.class.getName() + " AND produce a non-null format, or that use" + " converters that this DatePicker can use to determine" + " the pattern being used. Alternatively, you can extend " + " the DatePicker and override getDatePattern to provide your own.");
        }
    }
}

