/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.datetime;

import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.ClientInfo;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.Strings;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateConverter
implements IConverter<Date> {
    private static final long serialVersionUID = 1L;
    private final boolean applyTimeZoneDifference;
    private Component component = null;

    public DateConverter(boolean applyTimeZoneDifference) {
        this.applyTimeZoneDifference = applyTimeZoneDifference;
    }

    public Date convertToObject(String value, Locale locale) {
        if (Strings.isEmpty((CharSequence)value)) {
            return null;
        }
        DateTimeFormatter format = this.getFormat(locale);
        if (format == null) {
            throw new IllegalStateException("format must be not null");
        }
        if (this.applyTimeZoneDifference) {
            TimeZone zone = this.getClientTimeZone();
            DateTime dateTime = null;
            format = format.withZone(this.getTimeZone());
            try {
                dateTime = format.parseDateTime(value);
            }
            catch (RuntimeException e) {
                throw new ConversionException((Throwable)e);
            }
            if (zone != null) {
                dateTime = dateTime.withZoneRetainFields(DateTimeZone.forTimeZone((TimeZone)zone));
            }
            return dateTime.toDate();
        }
        try {
            DateTime date = format.parseDateTime(value);
            return date.toDate();
        }
        catch (RuntimeException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public String convertToString(Date value, Locale locale) {
        TimeZone zone;
        DateTime dt = new DateTime(value.getTime(), this.getTimeZone());
        DateTimeFormatter format = this.getFormat(locale);
        if (this.applyTimeZoneDifference && (zone = this.getClientTimeZone()) != null) {
            format = format.withZone(DateTimeZone.forTimeZone((TimeZone)zone));
        }
        return format.print((ReadableInstant)dt);
    }

    public final boolean getApplyTimeZoneDifference() {
        return this.applyTimeZoneDifference;
    }

    public final Component getComponent() {
        return this.component;
    }

    public abstract String getDatePattern(Locale var1);

    public final void setComponent(Component component) {
        this.component = component;
    }

    protected TimeZone getClientTimeZone() {
        ClientInfo info = Session.get().getClientInfo();
        if (info instanceof WebClientInfo) {
            return ((WebClientInfo)info).getProperties().getTimeZone();
        }
        return null;
    }

    protected abstract DateTimeFormatter getFormat(Locale var1);

    protected Locale getLocale() {
        Component c = this.getComponent();
        return c != null ? c.getLocale() : Session.get().getLocale();
    }

    protected DateTimeZone getTimeZone() {
        return DateTimeZone.getDefault();
    }
}

