/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class ByteArrayType
implements VariableType {
    private static final long serialVersionUID = 1L;

    public String getTypeName() {
        return "bytes";
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        if (valueFields.getByteArrayValueId() == null) {
            return null;
        }
        return valueFields.getByteArrayValue().getBytes();
    }

    public void setValue(Object value, ValueFields valueFields) {
        ByteArrayEntity byteArray = valueFields.getByteArrayValue();
        byte[] bytes = (byte[])value;
        if (byteArray == null) {
            byteArray = new ByteArrayEntity(bytes);
            Context.getCommandContext().getDbSqlSession().insert(byteArray);
            valueFields.setByteArrayValue(byteArray);
        } else {
            byteArray.setBytes(bytes);
        }
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return byte[].class.isAssignableFrom(value.getClass());
    }
}

