/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util.xml;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.util.io.InputStreamSource;
import org.activiti.engine.impl.util.io.ResourceStreamSource;
import org.activiti.engine.impl.util.io.StreamSource;
import org.activiti.engine.impl.util.io.StringStreamSource;
import org.activiti.engine.impl.util.io.UrlStreamSource;
import org.activiti.engine.impl.util.xml.Element;
import org.activiti.engine.impl.util.xml.ParseHandler;
import org.activiti.engine.impl.util.xml.Parser;
import org.activiti.engine.impl.util.xml.Problem;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parse
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(Parse.class.getName());
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String NEW_LINE = System.getProperty("line.separator");
    protected Parser parser;
    protected String name;
    protected StreamSource streamSource;
    protected Element rootElement = null;
    protected List<Problem> errors = new ArrayList<Problem>();
    protected List<Problem> warnings = new ArrayList<Problem>();
    protected String schemaResource;

    public Parse(Parser parser) {
        this.parser = parser;
    }

    public Parse name(String name) {
        this.name = name;
        return this;
    }

    public Parse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource(new InputStreamSource(inputStream));
        return this;
    }

    public Parse sourceResource(String resource) {
        return this.sourceResource(resource, null);
    }

    public Parse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource(new UrlStreamSource(url));
        return this;
    }

    public Parse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new ActivitiException("malformed url: " + url, e);
        }
    }

    public Parse sourceResource(String resource, ClassLoader classLoader) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource, classLoader));
        return this;
    }

    public Parse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource(new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new ActivitiException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public Parse execute() {
        try {
            InputStream inputStream = this.streamSource.getInputStream();
            if (this.schemaResource == null) {
                this.parser.getSaxParserFactory().setNamespaceAware(false);
                this.parser.getSaxParserFactory().setValidating(false);
            }
            SAXParser saxParser = this.parser.getSaxParser();
            if (this.schemaResource != null) {
                saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                saxParser.setProperty(JAXP_SCHEMA_SOURCE, this.schemaResource);
            }
            saxParser.parse(inputStream, (DefaultHandler)new ParseHandler(this));
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't parse '" + this.name + "': " + e.getMessage(), e);
        }
        return this;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public List<Problem> getProblems() {
        return this.errors;
    }

    public void addError(SAXParseException e) {
        this.errors.add(new Problem(e, this.name));
    }

    public void addError(String errorMessage, Element element) {
        this.errors.add(new Problem(errorMessage, this.name, element));
    }

    public boolean hasErrors() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public void addWarning(SAXParseException e) {
        this.warnings.add(new Problem(e, this.name));
    }

    public void addWarning(String errorMessage, Element element) {
        this.warnings.add(new Problem(errorMessage, this.name, element));
    }

    public boolean hasWarnings() {
        return this.warnings != null && !this.warnings.isEmpty();
    }

    public void logWarnings() {
        for (Problem warning : this.warnings) {
            LOGGER.warning(warning.toString());
        }
    }

    public void throwActivitiExceptionForErrors() {
        StringBuilder strb = new StringBuilder();
        for (Problem error : this.errors) {
            strb.append(error.toString());
            strb.append(NEW_LINE);
        }
        throw new ActivitiException(strb.toString());
    }

    public void setSchemaResource(String schemaResource) {
        SAXParserFactory saxParserFactory = this.parser.getSaxParserFactory();
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setValidating(true);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
        }
        this.schemaResource = schemaResource;
    }
}

