/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.repository;

import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.DeploymentBuilder;

public class DeploymentBuilderImpl
implements DeploymentBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient RepositoryServiceImpl repositoryService;
    protected DeploymentEntity deployment = new DeploymentEntity();
    protected boolean isDuplicateFilterEnabled = false;

    public DeploymentBuilderImpl(RepositoryServiceImpl repositoryService) {
        this.repositoryService = repositoryService;
    }

    public DeploymentBuilder addInputStream(String resourceName, InputStream inputStream) {
        if (inputStream == null) {
            throw new ActivitiException("inputStream for resource '" + resourceName + "' is null");
        }
        byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
        ResourceEntity resource = new ResourceEntity();
        resource.setName(resourceName);
        resource.setBytes(bytes);
        this.deployment.addResource(resource);
        return this;
    }

    public DeploymentBuilder addClasspathResource(String resource) {
        InputStream inputStream = ReflectUtil.getResourceAsStream(resource);
        if (inputStream == null) {
            throw new ActivitiException("resource '" + resource + "' not found");
        }
        return this.addInputStream(resource, inputStream);
    }

    public DeploymentBuilder addString(String resourceName, String text) {
        if (text == null) {
            throw new ActivitiException("text is null");
        }
        ResourceEntity resource = new ResourceEntity();
        resource.setName(resourceName);
        resource.setBytes(text.getBytes());
        this.deployment.addResource(resource);
        return this;
    }

    public DeploymentBuilder addZipInputStream(ZipInputStream zipInputStream) {
        try {
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    String entryName = entry.getName();
                    byte[] bytes = IoUtil.readInputStream(zipInputStream, entryName);
                    ResourceEntity resource = new ResourceEntity();
                    resource.setName(entryName);
                    resource.setBytes(bytes);
                    this.deployment.addResource(resource);
                }
                entry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            throw new ActivitiException("problem reading zip input stream", e);
        }
        return this;
    }

    public DeploymentBuilder name(String name) {
        this.deployment.setName(name);
        return this;
    }

    public DeploymentBuilder enableDuplicateFiltering() {
        this.isDuplicateFilterEnabled = true;
        return this;
    }

    public Deployment deploy() {
        return this.repositoryService.deploy(this);
    }

    public DeploymentEntity getDeployment() {
        return this.deployment;
    }

    public boolean isDuplicateFilterEnabled() {
        return this.isDuplicateFilterEnabled;
    }
}

