/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.runtime.ExecutionImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDefinitionImpl
extends ScopeImpl
implements PvmProcessDefinition {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String description;
    protected ActivityImpl initial;
    protected Map<ActivityImpl, List<ActivityImpl>> initialActivityStacks = new HashMap<ActivityImpl, List<ActivityImpl>>();

    public ProcessDefinitionImpl(String id) {
        super(id, null);
        this.processDefinition = this;
    }

    @Override
    public PvmProcessInstance createProcessInstance() {
        return this.createProcessInstanceForInitial(this.initial);
    }

    public PvmProcessInstance createProcessInstanceForInitial(ActivityImpl initial) {
        if (initial == null) {
            throw new ActivitiException("Cannot start process instance, initial is null");
        }
        InterpretableExecution processInstance = this.newProcessInstance(initial);
        processInstance.setProcessDefinition(this);
        processInstance.setProcessInstance(processInstance);
        processInstance.initialize();
        InterpretableExecution scopeInstance = processInstance;
        List<ActivityImpl> initialActivityStack = this.getInitialActivityStack(initial);
        for (ActivityImpl initialActivity : initialActivityStack) {
            if (!initialActivity.isScope()) continue;
            scopeInstance = (InterpretableExecution)scopeInstance.createExecution();
            scopeInstance.setActivity(initialActivity);
            if (!initialActivity.isScope()) continue;
            scopeInstance.initialize();
        }
        scopeInstance.setActivity(initial);
        return processInstance;
    }

    public List<ActivityImpl> getInitialActivityStack() {
        return this.getInitialActivityStack(this.initial);
    }

    public synchronized List<ActivityImpl> getInitialActivityStack(ActivityImpl startActivity) {
        List<ActivityImpl> initialActivityStack = this.initialActivityStacks.get(startActivity);
        if (initialActivityStack == null) {
            initialActivityStack = new ArrayList<ActivityImpl>();
            for (ActivityImpl activity = startActivity; activity != null; activity = activity.getParentActivity()) {
                initialActivityStack.add(0, activity);
            }
            this.initialActivityStacks.put(startActivity, initialActivityStack);
        }
        return initialActivityStack;
    }

    protected InterpretableExecution newProcessInstance(ActivityImpl startActivity) {
        return new ExecutionImpl(startActivity);
    }

    @Override
    public String getDiagramResourceName() {
        return null;
    }

    @Override
    public String getDeploymentId() {
        return null;
    }

    @Override
    public ActivityImpl getInitial() {
        return this.initial;
    }

    public void setInitial(ActivityImpl initial) {
        this.initial = initial;
    }

    public String toString() {
        return "ProcessDefinition(" + this.id + ")";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return (String)this.getProperty("documentation");
    }
}

