/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmException;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityImpl
extends ScopeImpl
implements PvmActivity {
    private static final long serialVersionUID = 1L;
    protected List<TransitionImpl> outgoingTransitions = new ArrayList<TransitionImpl>();
    protected Map<String, TransitionImpl> namedOutgoingTransitions = new HashMap<String, TransitionImpl>();
    protected List<TransitionImpl> incomingTransitions = new ArrayList<TransitionImpl>();
    protected ActivityBehavior activityBehavior;
    protected ScopeImpl parent;
    protected boolean isScope;
    protected boolean isAsync;
    protected boolean isExclusive;
    protected int x = -1;
    protected int y = -1;
    protected int width = -1;
    protected int height = -1;

    public ActivityImpl(String id, ProcessDefinitionImpl processDefinition) {
        super(id, processDefinition);
    }

    public TransitionImpl createOutgoingTransition() {
        return this.createOutgoingTransition(null);
    }

    public TransitionImpl createOutgoingTransition(String transitionId) {
        TransitionImpl transition = new TransitionImpl(transitionId, this.processDefinition);
        transition.setSource(this);
        this.outgoingTransitions.add(transition);
        if (transitionId != null) {
            if (this.namedOutgoingTransitions.containsKey(transitionId)) {
                throw new PvmException("activity '" + this.id + " has duplicate transition '" + transitionId + "'");
            }
            this.namedOutgoingTransitions.put(transitionId, transition);
        }
        return transition;
    }

    @Override
    public TransitionImpl findOutgoingTransition(String transitionId) {
        return this.namedOutgoingTransitions.get(transitionId);
    }

    public String toString() {
        return "Activity(" + this.id + ")";
    }

    public ActivityImpl getParentActivity() {
        if (this.parent instanceof ActivityImpl) {
            return (ActivityImpl)this.parent;
        }
        return null;
    }

    protected void setOutgoingTransitions(List<TransitionImpl> outgoingTransitions) {
        this.outgoingTransitions = outgoingTransitions;
    }

    protected void setParent(ScopeImpl parent) {
        this.parent = parent;
    }

    protected void setIncomingTransitions(List<TransitionImpl> incomingTransitions) {
        this.incomingTransitions = incomingTransitions;
    }

    @Override
    public List<PvmTransition> getOutgoingTransitions() {
        return this.outgoingTransitions;
    }

    public ActivityBehavior getActivityBehavior() {
        return this.activityBehavior;
    }

    public void setActivityBehavior(ActivityBehavior activityBehavior) {
        this.activityBehavior = activityBehavior;
    }

    @Override
    public ScopeImpl getParent() {
        return this.parent;
    }

    @Override
    public List<PvmTransition> getIncomingTransitions() {
        return this.incomingTransitions;
    }

    public boolean isScope() {
        return this.isScope;
    }

    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    @Override
    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }
}

