/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.TablePageQueryImpl;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.management.TableMetaData;
import org.activiti.engine.management.TablePage;
import org.apache.ibatis.session.RowBounds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDataManager
extends AbstractManager {
    private static Logger log = Logger.getLogger(TableDataManager.class.getName());

    public Map<String, Long> getTableCount() {
        HashMap<String, Long> tableCount = new HashMap<String, Long>();
        try {
            for (String tableName : this.getTablesPresentInDatabase()) {
                tableCount.put(tableName, this.getTableCount(tableName));
            }
            log.fine("Number of rows per activiti table: " + tableCount);
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't get table counts", e);
        }
        return tableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTablesPresentInDatabase() {
        ArrayList<String> tableNames = new ArrayList<String>();
        Connection connection = null;
        try {
            connection = this.getDbSqlSession().getSqlSession().getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet tables = null;
            try {
                log.fine("retrieving activiti tables from jdbc metadata");
                String tableNameFilter = "ACT_%";
                if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                    tableNameFilter = "act_%";
                }
                this.getDbSqlSession();
                tables = databaseMetaData.getTables(null, null, tableNameFilter, DbSqlSession.JDBC_METADATA_TABLE_TYPES);
                while (tables.next()) {
                    String tableName = tables.getString("TABLE_NAME");
                    tableName = tableName.toUpperCase();
                    tableNames.add(tableName);
                    log.fine("  retrieved activiti table name " + tableName);
                }
            }
            finally {
                tables.close();
            }
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't get activiti table names using metadata: " + e.getMessage(), e);
        }
        return tableNames;
    }

    protected long getTableCount(String tableName) {
        log.fine("selecting table count for " + tableName);
        Long count = (Long)this.getDbSqlSession().selectOne("selectTableCount", Collections.singletonMap("tableName", tableName));
        return count;
    }

    public TablePage getTablePage(TablePageQueryImpl tablePageQuery, int firstResult, int maxResults) {
        TablePage tablePage = new TablePage();
        List tableData = this.getDbSqlSession().getSqlSession().selectList("selectTableData", (Object)tablePageQuery, new RowBounds(firstResult, maxResults));
        tablePage.setTableName(tablePageQuery.getTableName());
        tablePage.setTotal(this.getTableCount(tablePageQuery.getTableName()));
        tablePage.setRows(tableData);
        tablePage.setFirstResult(firstResult);
        return tablePage;
    }

    public TableMetaData getTableMetaData(String tableName) {
        TableMetaData result = new TableMetaData();
        try {
            result.setTableName(tableName);
            DatabaseMetaData metaData = this.getDbSqlSession().getSqlSession().getConnection().getMetaData();
            if ("postgres".equals(this.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType())) {
                tableName = tableName.toLowerCase();
            }
            ResultSet resultSet = metaData.getColumns(null, null, tableName, null);
            while (resultSet.next()) {
                String name = resultSet.getString("COLUMN_NAME").toUpperCase();
                String type = resultSet.getString("TYPE_NAME").toUpperCase();
                result.addColumnMetaData(name, type);
            }
        }
        catch (SQLException e) {
            throw new ActivitiException("Could not retrieve database metadata: " + e.getMessage());
        }
        if (result.getColumnNames().size() == 0) {
            result = null;
        }
        return result;
    }
}

