/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractHistoricManager;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricTaskInstanceManager
extends AbstractHistoricManager {
    public void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        if (this.historyLevel >= 2) {
            List taskInstanceIds = this.getDbSqlSession().selectList("selectHistoricTaskInstanceIdsByProcessInstanceId", processInstanceId);
            for (String taskInstanceId : taskInstanceIds) {
                this.deleteHistoricTaskInstanceById(taskInstanceId);
            }
        }
    }

    public long findHistoricTaskInstanceCountByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.historyLevel > 0) {
            return (Long)this.getDbSqlSession().selectOne("selectHistoricTaskInstanceCountByQueryCriteria", historicTaskInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery, Page page) {
        if (this.historyLevel > 0) {
            return this.getDbSqlSession().selectList("selectHistoricTaskInstancesByQueryCriteria", historicTaskInstanceQuery, page);
        }
        return Collections.EMPTY_LIST;
    }

    public HistoricTaskInstanceEntity findHistoricTaskInstanceById(String taskId) {
        if (taskId == null) {
            throw new ActivitiException("Invalid historic task id : null");
        }
        if (this.historyLevel > 0) {
            return (HistoricTaskInstanceEntity)this.getDbSqlSession().selectOne("selectHistoricTaskInstance", taskId);
        }
        return null;
    }

    public void deleteHistoricTaskInstanceById(String taskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel > 0 && (historicTaskInstance = this.findHistoricTaskInstanceById(taskId)) != null) {
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getHistoricDetailManager().deleteHistoricDetailsByTaskId(taskId);
            commandContext.getCommentManager().deleteCommentsByTaskId(taskId);
            commandContext.getAttachmentManager().deleteAttachmentsByTaskId(taskId);
            this.getDbSqlSession().delete(HistoricTaskInstanceEntity.class, taskId);
        }
    }

    public void markTaskInstanceEnded(String taskId, String deleteReason) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel >= 2 && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.markEnded(deleteReason);
        }
    }

    public void setTaskAssignee(String taskId, String assignee) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel >= 2 && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setAssignee(assignee);
        }
    }

    public void setTaskOwner(String taskId, String owner) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel >= 2 && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, taskId)) != null) {
            historicTaskInstance.setOwner(owner);
        }
    }

    public void setTaskName(String id, String taskName) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel >= 2 && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, id)) != null) {
            historicTaskInstance.setName(taskName);
        }
    }

    public void setTaskDescription(String id, String description) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel >= 2 && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, id)) != null) {
            historicTaskInstance.setDescription(description);
        }
    }

    public void setTaskDueDate(String id, Date dueDate) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel >= 2 && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, id)) != null) {
            historicTaskInstance.setDueDate(dueDate);
        }
    }

    public void setTaskPriority(String id, int priority) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel >= 2 && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, id)) != null) {
            historicTaskInstance.setPriority(priority);
        }
    }

    public void setTaskParentTaskId(String id, String parentTaskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.historyLevel >= 2 && (historicTaskInstance = this.getDbSqlSession().selectById(HistoricTaskInstanceEntity.class, id)) != null) {
            historicTaskInstance.setParentTaskId(parentTaskId);
        }
    }
}

