/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class CompensateEventSubscriptionEntity
extends EventSubscriptionEntity {
    private CompensateEventSubscriptionEntity() {
    }

    private CompensateEventSubscriptionEntity(ExecutionEntity executionEntity) {
        super(executionEntity);
        this.eventType = "compensate";
    }

    public static CompensateEventSubscriptionEntity createAndInsert(ExecutionEntity executionEntity) {
        CompensateEventSubscriptionEntity eventSubscription = new CompensateEventSubscriptionEntity(executionEntity);
        eventSubscription.insert();
        return eventSubscription;
    }

    protected void processEventSync(Object payload) {
        this.delete();
        super.processEventSync(payload);
    }

    public void insert() {
        this.addToExecution();
        super.insert();
    }

    public void delete() {
        this.removeFromExecution();
        super.delete();
    }

    protected void addToExecution() {
        ExecutionEntity execution = this.getExecution();
        if (execution != null) {
            execution.addCompensateEventSubscription(this);
        }
    }

    protected void removeFromExecution() {
        ExecutionEntity execution = this.getExecution();
        if (execution != null) {
            execution.removeCompensateEventSubscription(this);
        }
    }

    public CompensateEventSubscriptionEntity moveUnder(ExecutionEntity newExecution) {
        this.delete();
        CompensateEventSubscriptionEntity newSubscription = CompensateEventSubscriptionEntity.createAndInsert(newExecution);
        newSubscription.setActivity(this.getActivity());
        newSubscription.setConfiguration(this.configuration);
        newSubscription.setCreated(this.created);
        return newSubscription;
    }
}

