/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.mail;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.mail.MailScanSchedulerThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailScanner {
    private static Logger log = Logger.getLogger(MailScanner.class.getName());
    protected Thread thread = null;
    protected boolean isActive = false;
    protected CommandExecutor commandExecutor;
    protected boolean isAutoActivate = false;
    protected MailScanSchedulerThread mailScanSchedulerThread;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected ThreadPoolExecutor threadPoolExecutor;
    protected int queueSize = 1;
    protected int corePoolSize = 3;
    private int maxPoolSize = 10;

    public synchronized void start() {
        if (this.isActive) {
            log.info("Ignoring duplicate MailScanner start invocation");
            return;
        }
        this.isActive = true;
        if (this.mailScanSchedulerThread == null) {
            this.mailScanSchedulerThread = new MailScanSchedulerThread(this);
        }
        if (this.threadPoolQueue == null) {
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(this.queueSize);
        }
        if (this.threadPoolExecutor == null) {
            this.threadPoolExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, 0L, TimeUnit.MILLISECONDS, this.threadPoolQueue);
            this.threadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        }
        log.fine("MailScanner is starting the " + MailScanSchedulerThread.class.getName());
        this.mailScanSchedulerThread.start();
    }

    public void shutdown() {
        if (!this.isActive) {
            log.info("Ignoring request to shut down non-active MailScanner");
            return;
        }
        log.info("Shutting down the MailScanner");
        this.mailScanSchedulerThread.shutdown();
        this.threadPoolExecutor.shutdown();
        try {
            this.threadPoolExecutor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new ActivitiException("Timeout during shutdown of mail scanner. The current running scans could not end withing 60 seconds after shutdown operation.", e);
        }
        this.isActive = false;
        this.threadPoolExecutor = null;
        this.mailScanSchedulerThread = null;
    }

    public void addUser(String userId, String userPassword) {
        if (this.isActive && this.mailScanSchedulerThread != null) {
            this.mailScanSchedulerThread.addUser(userId, userPassword);
        }
    }

    public void removeUser(String userId) {
        if (this.mailScanSchedulerThread != null) {
            this.mailScanSchedulerThread.removeUser(userId);
        }
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolExecutor = threadPoolExecutor;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    public MailScanSchedulerThread getMailScanSchedulerThread() {
        return this.mailScanSchedulerThread;
    }

    public void setMailScanSchedulerThread(MailScanSchedulerThread mailScanScheduler) {
        this.mailScanSchedulerThread = mailScanScheduler;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }
}

