/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.json;

import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.json.JsonObjectConverter;
import org.activiti.engine.impl.util.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonListConverter<T> {
    JsonObjectConverter<T> jsonObjectConverter;

    public JsonListConverter(JsonObjectConverter<T> jsonObjectConverter) {
        this.jsonObjectConverter = jsonObjectConverter;
    }

    public void toJson(List<T> list, Writer writer) {
        this.toJsonArray(list).write(writer);
    }

    public String toJson(List<T> list) {
        return this.toJsonArray(list).toString();
    }

    public String toJson(List<T> list, int indentFactor) {
        return this.toJsonArray(list).toString(indentFactor);
    }

    private JSONArray toJsonArray(List<T> objects) {
        JSONArray jsonArray = new JSONArray();
        for (T object : objects) {
            jsonArray.put(this.jsonObjectConverter.toJsonObject(object));
        }
        return jsonArray;
    }

    public List<T> toObject(Reader reader) {
        throw new ActivitiException("not yet implemented");
    }

    public JsonObjectConverter<T> getJsonObjectConverter() {
        return this.jsonObjectConverter;
    }

    public void setJsonObjectConverter(JsonObjectConverter<T> jsonObjectConverter) {
        this.jsonObjectConverter = jsonObjectConverter;
    }
}

