/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.AcquiredJobs;
import org.activiti.engine.impl.jobexecutor.GetUnlockedTimersByDuedateCmd;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.util.ClockUtil;

public class AcquireJobsRunnable
implements Runnable {
    private static Logger log = Logger.getLogger(AcquireJobsRunnable.class.getName());
    protected final JobExecutor jobExecutor;
    protected volatile boolean isInterrupted = false;
    protected volatile boolean isJobAdded = false;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public AcquireJobsRunnable(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        log.info(this.jobExecutor.getName() + " starting to acquire jobs");
        CommandExecutor commandExecutor = this.jobExecutor.getCommandExecutor();
        long millisToWait = 0L;
        float waitIncreaseFactor = 2.0f;
        long maxWait = 60000L;
        while (!this.isInterrupted) {
            block17: {
                int maxJobsPerAcquisition = this.jobExecutor.getMaxJobsPerAcquisition();
                try {
                    AcquiredJobs acquiredJobs = commandExecutor.execute(this.jobExecutor.getAcquireJobsCmd());
                    for (List<String> jobIds : acquiredJobs.getJobIdBatches()) {
                        this.jobExecutor.executeJobs(jobIds);
                    }
                    millisToWait = this.jobExecutor.getWaitTimeInMillis();
                    int jobsAcquired = acquiredJobs.getJobIdBatches().size();
                    if (jobsAcquired < maxJobsPerAcquisition) {
                        long millisTillNextTimer;
                        this.isJobAdded = false;
                        Date duedate = new Date(ClockUtil.getCurrentTime().getTime() + millisToWait);
                        List<TimerEntity> nextTimers = commandExecutor.execute(new GetUnlockedTimersByDuedateCmd(duedate, new Page(0, 1)));
                        if (!nextTimers.isEmpty() && (millisTillNextTimer = nextTimers.get(0).getDuedate().getTime() - ClockUtil.getCurrentTime().getTime()) < millisToWait) {
                            millisToWait = millisTillNextTimer;
                        }
                    } else {
                        millisToWait = 0L;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "exception during job acquisition: " + e.getMessage(), e);
                    millisToWait = (long)((float)millisToWait * waitIncreaseFactor);
                    if (millisToWait > maxWait) {
                        millisToWait = maxWait;
                    }
                    if (millisToWait != 0L) break block17;
                    millisToWait = this.jobExecutor.getWaitTimeInMillis();
                }
            }
            if (millisToWait <= 0L || this.isJobAdded) continue;
            try {
                log.fine("job acquisition thread sleeping for " + millisToWait + " millis");
                Object e = this.MONITOR;
                synchronized (e) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(millisToWait);
                    }
                }
                log.fine("job acquisition thread woke up");
            }
            catch (InterruptedException e) {
                log.fine("job acquisition wait interrupted");
            }
            finally {
                this.isWaiting.set(false);
            }
        }
        log.info(this.jobExecutor.getName() + " stopped job acquisition");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasAdded() {
        this.isJobAdded = true;
        if (this.isWaiting.compareAndSet(true, false)) {
            Object object = this.MONITOR;
            synchronized (object) {
                this.MONITOR.notifyAll();
            }
        }
    }
}

