/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.form;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.form.AbstractFormType;

public class BooleanFormType
extends AbstractFormType {
    public String getName() {
        return "boolean";
    }

    public String getMimeType() {
        return "plain/text";
    }

    public Object convertFormValueToModelValue(String propertyValue) {
        if (propertyValue == null || "".equals(propertyValue)) {
            return null;
        }
        return Boolean.valueOf(propertyValue);
    }

    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue == null) {
            return null;
        }
        if (Boolean.class.isAssignableFrom(modelValue.getClass()) || Boolean.TYPE.isAssignableFrom(modelValue.getClass())) {
            return modelValue.toString();
        }
        throw new ActivitiException("Model value is not of type boolean, but of type " + modelValue.getClass().getName());
    }
}

