/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetTaskVariablesCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Map<String, ? extends Object> variables;
    protected boolean isLocal;

    public SetTaskVariablesCmd(String taskId, Map<String, ? extends Object> variables, boolean isLocal) {
        this.taskId = taskId;
        this.variables = variables;
        this.isLocal = isLocal;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ActivitiException("taskId is null");
        }
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ActivitiException("task " + this.taskId + " doesn't exist");
        }
        if (this.isLocal) {
            task.setVariablesLocal(this.variables);
        } else {
            task.setVariables(this.variables);
        }
        return null;
    }
}

