/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetDeploymentResourceCmd
implements Command<InputStream>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String resourceName;

    public GetDeploymentResourceCmd(String deploymentId, String resourceName) {
        this.deploymentId = deploymentId;
        this.resourceName = resourceName;
    }

    @Override
    public InputStream execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new ActivitiException("deploymentId is null");
        }
        if (this.resourceName == null) {
            throw new ActivitiException("resourceName is null");
        }
        ResourceEntity resource = commandContext.getResourceManager().findResourceByDeploymentIdAndResourceName(this.deploymentId, this.resourceName);
        if (resource == null) {
            throw new ActivitiException("no resource found with name '" + this.resourceName + "' in deployment '" + this.deploymentId + "'");
        }
        return new ByteArrayInputStream(resource.getBytes());
    }
}

