/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.AcquiredJobs;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.util.ClockUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquireJobsCmd
implements Command<AcquiredJobs> {
    private static final long serialVersionUID = 1L;
    private final JobExecutor jobExecutor;

    public AcquireJobsCmd(JobExecutor jobExecutor) {
        this.jobExecutor = jobExecutor;
    }

    @Override
    public AcquiredJobs execute(CommandContext commandContext) {
        String lockOwner = this.jobExecutor.getLockOwner();
        int lockTimeInMillis = this.jobExecutor.getLockTimeInMillis();
        int maxJobsPerAcquisition = this.jobExecutor.getMaxJobsPerAcquisition();
        int jobsInThisAcquisition = 0;
        AcquiredJobs acquiredJobs = new AcquiredJobs();
        List<JobEntity> jobs = commandContext.getJobManager().findNextJobsToExecute(new Page(0, maxJobsPerAcquisition));
        for (JobEntity job : jobs) {
            ArrayList<String> jobIds = new ArrayList<String>();
            if (job != null && !acquiredJobs.contains(job.getId())) {
                if (job.isExclusive() && job.getProcessInstanceId() != null) {
                    List<JobEntity> exclusiveJobs = commandContext.getJobManager().findExclusiveJobsToExecute(job.getProcessInstanceId());
                    for (JobEntity exclusiveJob : exclusiveJobs) {
                        if (exclusiveJob == null) continue;
                        this.lockJob(exclusiveJob, lockOwner, lockTimeInMillis);
                        jobIds.add(exclusiveJob.getId());
                    }
                } else {
                    this.lockJob(job, lockOwner, lockTimeInMillis);
                    jobIds.add(job.getId());
                }
            }
            acquiredJobs.addJobIdBatch(jobIds);
            if ((jobsInThisAcquisition += jobIds.size()) < maxJobsPerAcquisition) continue;
            break;
        }
        return acquiredJobs;
    }

    protected void lockJob(JobEntity job, String lockOwner, int lockTimeInMillis) {
        job.setLockOwner(lockOwner);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(ClockUtil.getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

