/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSetProcessDefinitionStateCmd
implements Command<Void> {
    protected final String processDefinitionId;
    private final String processDefinitionKey;

    public AbstractSetProcessDefinitionStateCmd(String processDefinitionId, String processDefinitionKey) {
        this.processDefinitionId = processDefinitionId;
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.processDefinitionId == null && this.processDefinitionKey == null) {
            throw new ActivitiException("Process definition id / key cannot be null");
        }
        ProcessDefinitionEntity processDefinitionEntity = null;
        ProcessDefinitionManager processDefinitionManager = commandContext.getProcessDefinitionManager();
        if (this.processDefinitionId == null) {
            processDefinitionEntity = processDefinitionManager.findLatestProcessDefinitionByKey(this.processDefinitionKey);
            if (processDefinitionEntity == null) {
                throw new ActivitiException("Cannot find process definition for key '" + this.processDefinitionKey + "'");
            }
        } else {
            processDefinitionEntity = processDefinitionManager.findLatestProcessDefinitionById(this.processDefinitionId);
            if (processDefinitionEntity == null) {
                throw new ActivitiException("Cannot find process definition for id '" + this.processDefinitionId + "'");
            }
        }
        this.setState(processDefinitionEntity);
        return null;
    }

    protected abstract void setState(ProcessDefinitionEntity var1);
}

