/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.calendar;

import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.util.ClockUtil;

public class DurationHelper {
    Date start;
    Date end;
    Duration period;
    boolean isRepeat;
    int times;
    DatatypeFactory datatypeFactory;

    public DurationHelper(String expressionS) throws Exception {
        List<String> expression = Arrays.asList(expressionS.split("/"));
        this.datatypeFactory = DatatypeFactory.newInstance();
        if (expression.size() > 3 || expression.isEmpty()) {
            throw new ActivitiException("Cannot parse duration");
        }
        if (expression.get(0).startsWith("R")) {
            this.isRepeat = true;
            this.times = expression.get(0).length() == 1 ? Integer.MAX_VALUE : Integer.parseInt(expression.get(0).substring(1));
            expression = expression.subList(1, expression.size());
        }
        if (this.isDuration(expression.get(0))) {
            this.period = this.parsePeriod(expression.get(0));
            this.end = expression.size() == 1 ? null : this.parseDate(expression.get(1));
        } else {
            this.start = this.parseDate(expression.get(0));
            if (this.isDuration(expression.get(1))) {
                this.period = this.parsePeriod(expression.get(1));
            } else {
                this.end = this.parseDate(expression.get(1));
                this.period = this.datatypeFactory.newDuration(this.end.getTime() - this.start.getTime());
            }
        }
        if (this.start == null && this.end == null) {
            this.start = ClockUtil.getCurrentTime();
        }
    }

    public Date getDateAfter() {
        if (this.isRepeat) {
            return this.getDateAfterRepeat(ClockUtil.getCurrentTime());
        }
        if (this.end != null) {
            return this.end;
        }
        return this.add(this.start, this.period);
    }

    private Date getDateAfterRepeat(Date date) {
        if (this.start != null) {
            Date cur = this.start;
            for (int i = 0; i < this.times && !cur.after(date); ++i) {
                cur = this.add(cur, this.period);
            }
            return cur.before(date) ? null : cur;
        }
        Date cur = this.add(this.end, this.period.negate());
        Date next = this.end;
        for (int i = 0; i < this.times && cur.after(date); ++i) {
            next = cur;
            cur = this.add(cur, this.period.negate());
        }
        return next.before(date) ? null : next;
    }

    private Date add(Date date, Duration duration) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        duration.addTo(calendar);
        return calendar.getTime();
    }

    private Date parseDate(String date) throws Exception {
        return this.datatypeFactory.newXMLGregorianCalendar(date).toGregorianCalendar().getTime();
    }

    private Duration parsePeriod(String period) throws Exception {
        return this.datatypeFactory.newDuration(period);
    }

    private boolean isDuration(String time) {
        return time.startsWith("P");
    }
}

