/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser;

import java.io.InputStream;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.BusinessRuleTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.CancelBoundaryEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.CancelEndEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ErrorEndEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.EventBasedGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ExclusiveGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.InclusiveGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.IntermediateCatchEventActivitiBehaviour;
import org.activiti.engine.impl.bpmn.behavior.IntermediateThrowCompensationEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.IntermediateThrowNoneEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.IntermediateThrowSignalEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MailActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ManualTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.NoneEndEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.NoneStartEventActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.ReceiveTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ScriptTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.ServiceTaskDelegateExpressionActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ServiceTaskExpressionActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ShellActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.TransactionActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.data.Assignment;
import org.activiti.engine.impl.bpmn.data.ClassStructureDefinition;
import org.activiti.engine.impl.bpmn.data.Data;
import org.activiti.engine.impl.bpmn.data.DataRef;
import org.activiti.engine.impl.bpmn.data.IOSpecification;
import org.activiti.engine.impl.bpmn.data.ItemDefinition;
import org.activiti.engine.impl.bpmn.data.ItemKind;
import org.activiti.engine.impl.bpmn.data.SimpleDataInputAssociation;
import org.activiti.engine.impl.bpmn.data.StructureDefinition;
import org.activiti.engine.impl.bpmn.data.TransformationDataOutputAssociation;
import org.activiti.engine.impl.bpmn.helper.ClassDelegate;
import org.activiti.engine.impl.bpmn.listener.DelegateExpressionExecutionListener;
import org.activiti.engine.impl.bpmn.listener.DelegateExpressionTaskListener;
import org.activiti.engine.impl.bpmn.listener.ExpressionExecutionListener;
import org.activiti.engine.impl.bpmn.listener.ExpressionTaskListener;
import org.activiti.engine.impl.bpmn.parser.BpmnParseListener;
import org.activiti.engine.impl.bpmn.parser.BpmnParser;
import org.activiti.engine.impl.bpmn.parser.CompensateEventDefinition;
import org.activiti.engine.impl.bpmn.parser.Error;
import org.activiti.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.bpmn.parser.MessageEventDefinition;
import org.activiti.engine.impl.bpmn.parser.SignalDefinition;
import org.activiti.engine.impl.bpmn.parser.SignalEventDefinition;
import org.activiti.engine.impl.bpmn.parser.XMLImporter;
import org.activiti.engine.impl.bpmn.webservice.BpmnInterface;
import org.activiti.engine.impl.bpmn.webservice.BpmnInterfaceImplementation;
import org.activiti.engine.impl.bpmn.webservice.MessageDefinition;
import org.activiti.engine.impl.bpmn.webservice.MessageImplicitDataInputAssociation;
import org.activiti.engine.impl.bpmn.webservice.MessageImplicitDataOutputAssociation;
import org.activiti.engine.impl.bpmn.webservice.Operation;
import org.activiti.engine.impl.bpmn.webservice.OperationImplementation;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.el.FixedValue;
import org.activiti.engine.impl.el.UelExpressionCondition;
import org.activiti.engine.impl.form.DefaultStartFormHandler;
import org.activiti.engine.impl.form.DefaultTaskFormHandler;
import org.activiti.engine.impl.form.StartFormHandler;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationType;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.util.xml.Element;
import org.activiti.engine.impl.util.xml.Parse;
import org.activiti.engine.impl.variable.VariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnParse
extends Parse {
    protected static final Logger LOGGER = Logger.getLogger(BpmnParse.class.getName());
    public static final String PROPERTYNAME_DOCUMENTATION = "documentation";
    public static final String PROPERTYNAME_INITIAL = "initial";
    public static final String PROPERTYNAME_INITIATOR_VARIABLE_NAME = "initiatorVariableName";
    public static final String PROPERTYNAME_CONDITION = "condition";
    public static final String PROPERTYNAME_CONDITION_TEXT = "conditionText";
    public static final String PROPERTYNAME_VARIABLE_DECLARATIONS = "variableDeclarations";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";
    public static final String PROPERTYNAME_ISEXPANDED = "isExpanded";
    public static final String PROPERTYNAME_START_TIMER = "timerStart";
    public static final String PROPERTYNAME_SIGNAL_DEFINITION_NAME = "signalDefinition";
    public static final String PROPERTYNAME_COMPENSATION_HANDLER_ID = "compensationHandler";
    public static final String PROPERTYNAME_IS_FOR_COMPENSATION = "isForCompensation";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_MESSAGE_EVENT_DEFINITIONS = "messageEventDefinitions";
    protected DeploymentEntity deployment;
    protected List<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
    protected Map<String, Error> errors = new HashMap<String, Error>();
    protected Map<String, TransitionImpl> sequenceFlows;
    protected List<String> elementIds = new ArrayList<String>();
    protected Map<String, MessageDefinition> messages = new HashMap<String, MessageDefinition>();
    protected Map<String, StructureDefinition> structures = new HashMap<String, StructureDefinition>();
    protected Map<String, BpmnInterfaceImplementation> interfaceImplementations = new HashMap<String, BpmnInterfaceImplementation>();
    protected Map<String, OperationImplementation> operationImplementations = new HashMap<String, OperationImplementation>();
    protected Map<String, ItemDefinition> itemDefinitions = new HashMap<String, ItemDefinition>();
    protected Map<String, BpmnInterface> bpmnInterfaces = new HashMap<String, BpmnInterface>();
    protected Map<String, Operation> operations = new HashMap<String, Operation>();
    protected Map<String, SignalDefinition> signals = new HashMap<String, SignalDefinition>();
    protected ExpressionManager expressionManager;
    protected List<BpmnParseListener> parseListeners;
    protected Map<String, XMLImporter> importers = new HashMap<String, XMLImporter>();
    protected Map<String, String> prefixs = new HashMap<String, String>();
    protected String targetNamespace;
    protected static final String HUMAN_PERFORMER = "humanPerformer";
    protected static final String POTENTIAL_OWNER = "potentialOwner";
    protected static final String RESOURCE_ASSIGNMENT_EXPR = "resourceAssignmentExpression";
    protected static final String FORMAL_EXPRESSION = "formalExpression";
    protected static final String USER_PREFIX = "user(";
    protected static final String GROUP_PREFIX = "group(";
    protected static final String ASSIGNEE_EXTENSION = "assignee";
    protected static final String CANDIDATE_USERS_EXTENSION = "candidateUsers";
    protected static final String CANDIDATE_GROUPS_EXTENSION = "candidateGroups";
    protected static final String DUE_DATE_EXTENSION = "dueDate";
    protected static final String PRIORITY_EXTENSION = "priority";

    BpmnParse(BpmnParser parser) {
        super(parser);
        this.expressionManager = parser.getExpressionManager();
        this.parseListeners = parser.getParseListeners();
        this.setSchemaResource(ReflectUtil.getResource("org/activiti/impl/bpmn/parser/BPMN20.xsd").toString());
        this.initializeXSDItemDefinitions();
    }

    protected void initializeXSDItemDefinitions() {
        this.itemDefinitions.put("http://www.w3.org/2001/XMLSchema:string", new ItemDefinition("http://www.w3.org/2001/XMLSchema:string", new ClassStructureDefinition(String.class)));
    }

    public BpmnParse deployment(DeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BpmnParse execute() {
        super.execute();
        try {
            this.parseRootElement();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Uknown exception", e);
        }
        finally {
            if (this.hasWarnings()) {
                this.logWarnings();
            }
            if (this.hasErrors()) {
                this.throwActivitiExceptionForErrors();
            }
        }
        return this;
    }

    protected void parseRootElement() {
        this.collectElementIds();
        this.parseDefinitionsAttributes();
        this.parseImports();
        this.parseItemDefinitions();
        this.parseMessages();
        this.parseInterfaces();
        this.parseErrors();
        this.parseSignals();
        this.parseProcessDefinitions();
        this.parseDiagramInterchangeElements();
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseRootElement(this.rootElement, this.getProcessDefinitions());
        }
    }

    protected void collectElementIds() {
        this.rootElement.collectIds(this.elementIds);
    }

    protected void parseDefinitionsAttributes() {
        String typeLanguage = this.rootElement.attribute("typeLanguage");
        String expressionLanguage = this.rootElement.attribute("expressionLanguage");
        this.targetNamespace = this.rootElement.attribute("targetNamespace");
        if (typeLanguage != null && typeLanguage.contains("XMLSchema")) {
            LOGGER.info("XMLSchema currently not supported as typeLanguage");
        }
        if (expressionLanguage != null && expressionLanguage.contains("XPath")) {
            LOGGER.info("XPath currently not supported as expressionLanguage");
        }
        for (String attribute : this.rootElement.attributes()) {
            if (!attribute.startsWith("xmlns:")) continue;
            String prefixValue = this.rootElement.attribute(attribute);
            String prefixName = attribute.substring(6);
            this.prefixs.put(prefixName, prefixValue);
        }
    }

    protected String resolveName(String name) {
        if (name == null) {
            return null;
        }
        int indexOfP = name.indexOf(58);
        if (indexOfP != -1) {
            String prefix = name.substring(0, indexOfP);
            String resolvedPrefix = this.prefixs.get(prefix);
            return resolvedPrefix + ":" + name.substring(indexOfP + 1);
        }
        return name;
    }

    protected void parseImports() {
        List<Element> imports = this.rootElement.elements("import");
        for (Element theImport : imports) {
            String importType = theImport.attribute("importType");
            XMLImporter importer = this.getImporter(importType, theImport);
            if (importer == null) {
                this.addError("Could not import item of type " + importType, theImport);
                continue;
            }
            importer.importFrom(theImport, this);
        }
    }

    protected XMLImporter getImporter(String importType, Element theImport) {
        if (this.importers.containsKey(importType)) {
            return this.importers.get(importType);
        }
        if (importType.equals("http://schemas.xmlsoap.org/wsdl/")) {
            try {
                Class<?> wsdlImporterClass = Class.forName("org.activiti.engine.impl.webservice.CxfWSDLImporter", true, Thread.currentThread().getContextClassLoader());
                XMLImporter newInstance = (XMLImporter)wsdlImporterClass.newInstance();
                this.importers.put(importType, newInstance);
                return newInstance;
            }
            catch (Exception e) {
                this.addError("Could not find importer for type " + importType, theImport);
            }
        }
        return null;
    }

    public void parseItemDefinitions() {
        for (Element itemDefinitionElement : this.rootElement.elements("itemDefinition")) {
            String id = itemDefinitionElement.attribute("id");
            String structureRef = this.resolveName(itemDefinitionElement.attribute("structureRef"));
            String itemKind = itemDefinitionElement.attribute("itemKind");
            StructureDefinition structure = null;
            try {
                Class<?> classStructure = ReflectUtil.loadClass(structureRef);
                structure = new ClassStructureDefinition(classStructure);
            }
            catch (ActivitiException e) {
                structure = this.structures.get(structureRef);
            }
            ItemDefinition itemDefinition = new ItemDefinition(this.targetNamespace + ":" + id, structure);
            if (itemKind != null) {
                itemDefinition.setItemKind(ItemKind.valueOf(itemKind));
            }
            this.itemDefinitions.put(itemDefinition.getId(), itemDefinition);
        }
    }

    public void parseMessages() {
        for (Element messageElement : this.rootElement.elements("message")) {
            String id = messageElement.attribute("id");
            String itemRef = this.resolveName(messageElement.attribute("itemRef"));
            String name = messageElement.attribute("name");
            MessageDefinition messageDefinition = new MessageDefinition(this.targetNamespace + ":" + id, name);
            if (itemRef != null) {
                if (!this.itemDefinitions.containsKey(itemRef)) {
                    this.addError(itemRef + " does not exist", messageElement);
                } else {
                    ItemDefinition itemDefinition = this.itemDefinitions.get(itemRef);
                    messageDefinition.setItemDefinition(itemDefinition);
                }
            }
            this.messages.put(messageDefinition.getId(), messageDefinition);
        }
    }

    protected void parseSignals() {
        for (Element signalElement : this.rootElement.elements("signal")) {
            String id = signalElement.attribute("id");
            String signalName = this.resolveName(signalElement.attribute("name"));
            for (SignalDefinition signalDefinition : this.signals.values()) {
                if (!signalDefinition.getName().equals(signalName)) continue;
                this.addError("duplicate signal name '" + signalName + "'.", signalElement);
            }
            if (id == null) {
                this.addError("signal must have an id", signalElement);
                continue;
            }
            if (signalName == null) {
                this.addError("signal with id '" + id + "' has no name", signalElement);
                continue;
            }
            SignalDefinition signal = new SignalDefinition();
            signal.setId(this.targetNamespace + ":" + id);
            signal.setName(signalName);
            this.signals.put(id, signal);
        }
    }

    public void parseInterfaces() {
        for (Element interfaceElement : this.rootElement.elements("interface")) {
            String id = interfaceElement.attribute("id");
            String name = interfaceElement.attribute("name");
            String implementationRef = this.resolveName(interfaceElement.attribute("implementationRef"));
            BpmnInterface bpmnInterface = new BpmnInterface(this.targetNamespace + ":" + id, name);
            bpmnInterface.setImplementation(this.interfaceImplementations.get(implementationRef));
            for (Element operationElement : interfaceElement.elements("operation")) {
                Operation operation = this.parseOperation(operationElement, bpmnInterface);
                bpmnInterface.addOperation(operation);
            }
            this.bpmnInterfaces.put(bpmnInterface.getId(), bpmnInterface);
        }
    }

    public Operation parseOperation(Element operationElement, BpmnInterface bpmnInterface) {
        String outMessageRef;
        Element inMessageRefElement = operationElement.element("inMessageRef");
        String inMessageRef = this.resolveName(inMessageRefElement.getText());
        if (!this.messages.containsKey(inMessageRef)) {
            this.addError(inMessageRef + " does not exist", inMessageRefElement);
            return null;
        }
        MessageDefinition inMessage = this.messages.get(inMessageRef);
        String id = operationElement.attribute("id");
        String name = operationElement.attribute("name");
        String implementationRef = this.resolveName(operationElement.attribute("implementationRef"));
        Operation operation = new Operation(this.targetNamespace + ":" + id, name, bpmnInterface, inMessage);
        operation.setImplementation(this.operationImplementations.get(implementationRef));
        Element outMessageRefElement = operationElement.element("outMessageRef");
        if (outMessageRefElement != null && this.messages.containsKey(outMessageRef = this.resolveName(outMessageRefElement.getText()))) {
            MessageDefinition outMessage = this.messages.get(outMessageRef);
            operation.setOutMessage(outMessage);
        }
        this.operations.put(operation.getId(), operation);
        return operation;
    }

    public void parseErrors() {
        for (Element errorElement : this.rootElement.elements("error")) {
            Error error = new Error();
            String id = errorElement.attribute("id");
            if (id == null) {
                this.addError("'id' is mandatory on error definition", errorElement);
            }
            error.setId(id);
            String errorCode = errorElement.attribute("errorCode");
            if (errorCode == null) {
                this.addError("'errorCode' is mandatory on error definition", errorElement);
            }
            error.setErrorCode(errorCode);
            this.errors.put(id, error);
        }
    }

    public void parseProcessDefinitions() {
        for (Element processElement : this.rootElement.elements("process")) {
            boolean isExecutable;
            boolean processProcess = true;
            String isExecutableStr = processElement.attribute("isExecutable");
            if (isExecutableStr != null && !(isExecutable = Boolean.parseBoolean(isExecutableStr))) {
                processProcess = false;
            }
            if (!processProcess) continue;
            this.processDefinitions.add(this.parseProcess(processElement));
        }
    }

    public ProcessDefinitionEntity parseProcess(Element processElement) {
        this.sequenceFlows = new HashMap<String, TransitionImpl>();
        ProcessDefinitionEntity processDefinition = new ProcessDefinitionEntity();
        processDefinition.setKey(processElement.attribute("id"));
        processDefinition.setName(processElement.attribute("name"));
        processDefinition.setCategory(this.rootElement.attribute("targetNamespace"));
        processDefinition.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(processElement));
        processDefinition.setTaskDefinitions(new HashMap<String, TaskDefinition>());
        processDefinition.setDeploymentId(this.deployment.getId());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Parsing process " + processDefinition.getKey());
        }
        this.parseScope(processElement, processDefinition);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseProcess(processElement, processDefinition);
        }
        return processDefinition;
    }

    public void parseScope(Element scopeElement, ScopeImpl parentScope) {
        HashMap<String, Element> postponedElements = new HashMap<String, Element>();
        this.parseStartEvents(scopeElement, parentScope);
        this.parseActivities(scopeElement, parentScope, postponedElements);
        this.parsePostponedElements(scopeElement, parentScope, postponedElements);
        this.parseEndEvents(scopeElement, parentScope);
        this.parseBoundaryEvents(scopeElement, parentScope);
        this.parseSequenceFlow(scopeElement, parentScope);
        this.parseExecutionListenersOnScope(scopeElement, parentScope);
        this.parseAssociations(scopeElement, parentScope);
        postponedElements.clear();
        IOSpecification ioSpecification = this.parseIOSpecification(scopeElement.element("ioSpecification"));
        parentScope.setIoSpecification(ioSpecification);
    }

    protected void parsePostponedElements(Element scopeElement, ScopeImpl parentScope, HashMap<String, Element> postponedElements) {
        for (Element postponedElement : postponedElements.values()) {
            if (parentScope.findActivity(postponedElement.attribute("id")) != null || !postponedElement.getTagName().equals("intermediateCatchEvent")) continue;
            this.parseIntermediateCatchEvent(postponedElement, parentScope, false);
        }
    }

    protected void parseAssociations(Element scopeElement, ScopeImpl parentScope) {
        for (Element associationElement : scopeElement.elements("association")) {
            String targetRef;
            String sourceRef = associationElement.attribute("sourceRef");
            if (sourceRef == null) {
                this.addError("association element missing attribute 'sourceRef'", associationElement);
            }
            if ((targetRef = associationElement.attribute("targetRef")) == null) {
                this.addError("association element missing attribute 'targetRef'", associationElement);
            }
            ActivityImpl sourceActivity = parentScope.findActivity(sourceRef);
            ActivityImpl targetActivity = parentScope.findActivity(targetRef);
            if (sourceActivity == null && !this.elementIds.contains(sourceRef)) {
                this.addError("Invalid reference sourceRef '" + sourceRef + "' of association element ", associationElement);
                continue;
            }
            if (targetRef == null && !this.elementIds.contains(targetRef)) {
                this.addError("Invalid reference targetRef '" + targetRef + "' of association element ", associationElement);
                continue;
            }
            if (!sourceActivity.getProperty("type").equals("compensationBoundaryCatch")) continue;
            Object isForCompensation = targetActivity.getProperty(PROPERTYNAME_IS_FOR_COMPENSATION);
            if (isForCompensation == null || !((Boolean)isForCompensation).booleanValue()) {
                this.addError("compensation boundary catch must be connected to element with isForCompensation=true", associationElement);
                continue;
            }
            ActivityImpl compensatedActivity = sourceActivity.getParentActivity();
            compensatedActivity.setProperty(PROPERTYNAME_COMPENSATION_HANDLER_ID, targetActivity.getId());
        }
    }

    protected IOSpecification parseIOSpecification(Element ioSpecificationElement) {
        DataRef dataRef;
        ItemDefinition itemDefinition;
        String itemSubjectRef;
        String id;
        if (ioSpecificationElement == null) {
            return null;
        }
        IOSpecification ioSpecification = new IOSpecification();
        for (Element dataInputElement : ioSpecificationElement.elements("dataInput")) {
            id = dataInputElement.attribute("id");
            itemSubjectRef = this.resolveName(dataInputElement.attribute("itemSubjectRef"));
            itemDefinition = this.itemDefinitions.get(itemSubjectRef);
            Data dataInput = new Data(this.targetNamespace + ":" + id, id, itemDefinition);
            ioSpecification.addInput(dataInput);
        }
        for (Element dataOutputElement : ioSpecificationElement.elements("dataOutput")) {
            id = dataOutputElement.attribute("id");
            itemSubjectRef = this.resolveName(dataOutputElement.attribute("itemSubjectRef"));
            itemDefinition = this.itemDefinitions.get(itemSubjectRef);
            Data dataOutput = new Data(this.targetNamespace + ":" + id, id, itemDefinition);
            ioSpecification.addOutput(dataOutput);
        }
        for (Element inputSetElement : ioSpecificationElement.elements("inputSet")) {
            for (Element dataInputRef : inputSetElement.elements("dataInputRefs")) {
                dataRef = new DataRef(dataInputRef.getText());
                ioSpecification.addInputRef(dataRef);
            }
        }
        for (Element outputSetElement : ioSpecificationElement.elements("outputSet")) {
            for (Element dataInputRef : outputSetElement.elements("dataOutputRefs")) {
                dataRef = new DataRef(dataInputRef.getText());
                ioSpecification.addOutputRef(dataRef);
            }
        }
        return ioSpecification;
    }

    protected AbstractDataAssociation parseDataInputAssociation(Element dataAssociationElement) {
        String sourceRef = dataAssociationElement.element("sourceRef").getText();
        String targetRef = dataAssociationElement.element("targetRef").getText();
        List<Element> assignments = dataAssociationElement.elements("assignment");
        if (assignments.isEmpty()) {
            return new MessageImplicitDataInputAssociation(sourceRef, targetRef);
        }
        SimpleDataInputAssociation dataAssociation = new SimpleDataInputAssociation(sourceRef, targetRef);
        for (Element assigmentElement : dataAssociationElement.elements("assignment")) {
            Expression from = this.expressionManager.createExpression(assigmentElement.element("from").getText());
            Expression to = this.expressionManager.createExpression(assigmentElement.element("to").getText());
            Assignment assignment = new Assignment(from, to);
            dataAssociation.addAssignment(assignment);
        }
        return dataAssociation;
    }

    public void parseStartEvents(Element parentElement, ScopeImpl scope) {
        List<Element> startEventElements = parentElement.elements("startEvent");
        ArrayList<ActivityImpl> startEventActivities = new ArrayList<ActivityImpl>();
        for (Element startEventElement : startEventElements) {
            ActivityImpl startEventActivity = this.createActivityOnScope(startEventElement, scope);
            if (scope instanceof ProcessDefinitionEntity) {
                this.parseProcessDefinitionStartEvent(startEventActivity, startEventElement, parentElement, scope);
                startEventActivities.add(startEventActivity);
            } else {
                this.parseScopeStartEvent(startEventActivity, startEventElement, parentElement, scope);
            }
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseStartEvent(startEventElement, scope, startEventActivity);
            }
        }
        if (scope instanceof ProcessDefinitionEntity) {
            this.selectInitial(startEventActivities, (ProcessDefinitionEntity)scope, parentElement);
            this.parseStartFormHandlers(startEventElements, (ProcessDefinitionEntity)scope);
        }
    }

    protected void selectInitial(List<ActivityImpl> startEventActivities, ProcessDefinitionEntity processDefinition, Element parentElement) {
        ActivityImpl initial = null;
        for (ActivityImpl activityImpl : startEventActivities) {
            if (activityImpl.getProperty("type").equals("messageStartEvent")) continue;
            if (initial == null) {
                initial = activityImpl;
                continue;
            }
            this.addError("multiple none start events or timer start events not supported on process definition", parentElement);
        }
        if (initial == null && startEventActivities.size() == 1) {
            initial = startEventActivities.get(0);
        }
        processDefinition.setInitial(initial);
    }

    protected void parseProcessDefinitionStartEvent(ActivityImpl startEventActivity, Element startEventElement, Element parentElement, ScopeImpl scope) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)scope;
        String initiatorVariableName = startEventElement.attributeNS("http://activiti.org/bpmn", "initiator");
        if (initiatorVariableName != null) {
            processDefinition.setProperty(PROPERTYNAME_INITIATOR_VARIABLE_NAME, initiatorVariableName);
        }
        startEventActivity.setActivityBehavior(new NoneStartEventActivityBehavior());
        Element timerEventDefinition = startEventElement.element("timerEventDefinition");
        Element messageEventDefinition = startEventElement.element("messageEventDefinition");
        if (timerEventDefinition != null) {
            this.parseTimerStartEventDefinition(timerEventDefinition, startEventActivity, processDefinition);
        } else if (messageEventDefinition != null) {
            this.parseMessageStartEventDefinition(messageEventDefinition, startEventActivity, processDefinition);
        }
    }

    protected void parseStartFormHandlers(List<Element> startEventElements, ProcessDefinitionEntity processDefinition) {
        if (processDefinition.getInitial() != null) {
            for (Element startEventElement : startEventElements) {
                if (!startEventElement.attribute("id").equals(processDefinition.getInitial().getId())) continue;
                String startFormHandlerClassName = startEventElement.attributeNS("http://activiti.org/bpmn", "formHandlerClass");
                StartFormHandler startFormHandler = startFormHandlerClassName != null ? (StartFormHandler)ReflectUtil.instantiate(startFormHandlerClassName) : new DefaultStartFormHandler();
                startFormHandler.parseConfiguration(startEventElement, this.deployment, processDefinition, this);
                processDefinition.setStartFormHandler(startFormHandler);
            }
        }
    }

    protected void parseScopeStartEvent(ActivityImpl startEventActivity, Element startEventElement, Element parentElement, ScopeImpl scope) {
        if (scope.getProperty(PROPERTYNAME_INITIAL) == null) {
            scope.setProperty(PROPERTYNAME_INITIAL, startEventActivity);
            Object triggeredByEvent = scope.getProperty("triggeredByEvent");
            boolean isTriggeredByEvent = triggeredByEvent != null && (Boolean)triggeredByEvent == true;
            Element errorEventDefinition = startEventElement.element("errorEventDefinition");
            if (errorEventDefinition != null) {
                if (isTriggeredByEvent) {
                    this.parseErrorStartEventDefinition(errorEventDefinition, startEventActivity, scope);
                } else {
                    this.addError("errorEventDefinition only allowed on start event if subprocess is an event subprocess", errorEventDefinition);
                }
            } else if (!isTriggeredByEvent) {
                startEventActivity.setActivityBehavior(new NoneStartEventActivityBehavior());
            } else {
                this.addError("none start event not allowed for event subprocess", startEventElement);
            }
        } else {
            this.addError("multiple start events not supported for subprocess", startEventElement);
        }
    }

    protected void parseErrorStartEventDefinition(Element errorEventDefinition, ActivityImpl startEventActivity, ScopeImpl scope) {
        startEventActivity.setProperty("type", "errorStartEvent");
        String errorRef = errorEventDefinition.attribute("errorRef");
        Error error = null;
        ErrorEventDefinition definition = new ErrorEventDefinition(startEventActivity.getId());
        if (errorRef != null) {
            error = this.errors.get(errorRef);
            String errorCode = error == null ? errorRef : error.getErrorCode();
            definition.setErrorCode(errorCode);
        }
        ScopeImpl catchingScope = ((ActivityImpl)scope).getParent();
        definition.setPrecedence(10);
        this.addErrorEventDefinition(definition, catchingScope);
        startEventActivity.setActivityBehavior(new EventSubProcessStartEventActivityBehavior());
    }

    protected void parseMessageStartEventDefinition(Element messageEventDefinition, ActivityImpl startEventActivity, ProcessDefinitionEntity processDefinition) {
        MessageDefinition messageDefinition;
        String messageRef = messageEventDefinition.attribute("messageRef");
        if (messageRef == null) {
            this.addError("attriute 'messageRef' is required", messageEventDefinition);
        }
        if ((messageDefinition = this.messages.get(this.resolveName(messageRef))) == null) {
            this.addError("Invalid 'messageRef': no message with id '" + messageRef + "' found.", messageEventDefinition);
        }
        startEventActivity.setProperty("type", "messageStartEvent");
        MessageEventDefinition subscription = new MessageEventDefinition(messageDefinition.getId(), messageDefinition.getName(), startEventActivity.getId());
        subscription.setStartEvent(true);
        this.addMessageEventDefinition(subscription, processDefinition);
    }

    protected void addMessageEventDefinition(MessageEventDefinition subscription, ScopeImpl scope) {
        ArrayList<MessageEventDefinition> messageEventDefinitions = (ArrayList<MessageEventDefinition>)scope.getProperty(PROPERTYNAME_MESSAGE_EVENT_DEFINITIONS);
        if (messageEventDefinitions == null) {
            messageEventDefinitions = new ArrayList<MessageEventDefinition>();
            scope.setProperty(PROPERTYNAME_MESSAGE_EVENT_DEFINITIONS, messageEventDefinitions);
        }
        messageEventDefinitions.add(subscription);
    }

    public void parseActivities(Element parentElement, ScopeImpl scopeElement, HashMap<String, Element> postponedElements) {
        for (Element activityElement : parentElement.elements()) {
            this.parseActivity(activityElement, parentElement, scopeElement, postponedElements);
        }
    }

    protected void parseActivity(Element activityElement, Element parentElement, ScopeImpl scopeElement, HashMap<String, Element> postponedElements) {
        ActivityImpl activity = null;
        if (activityElement.getTagName().equals("exclusiveGateway")) {
            activity = this.parseExclusiveGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("inclusiveGateway")) {
            activity = this.parseInclusiveGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("parallelGateway")) {
            activity = this.parseParallelGateway(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("scriptTask")) {
            activity = this.parseScriptTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("serviceTask")) {
            activity = this.parseServiceTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("businessRuleTask")) {
            activity = this.parseBusinessRuleTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("task")) {
            activity = this.parseTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("manualTask")) {
            activity = this.parseManualTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("userTask")) {
            activity = this.parseUserTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("sendTask")) {
            activity = this.parseSendTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("receiveTask")) {
            activity = this.parseReceiveTask(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("subProcess")) {
            activity = this.parseSubProcess(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("callActivity")) {
            activity = this.parseCallActivity(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("intermediateCatchEvent")) {
            postponedElements.put(activityElement.attribute("id"), activityElement);
        } else if (activityElement.getTagName().equals("intermediateThrowEvent")) {
            activity = this.parseIntermediateThrowEvent(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("eventBasedGateway")) {
            activity = this.parseEventBasedGateway(activityElement, parentElement, scopeElement);
        } else if (activityElement.getTagName().equals("transaction")) {
            activity = this.parseTransaction(activityElement, scopeElement);
        } else if (activityElement.getTagName().equals("adHocSubProcess") || activityElement.getTagName().equals("complexGateway")) {
            this.addWarning("Ignoring unsupported activity type", activityElement);
        }
        if (activity != null) {
            this.parseMultiInstanceLoopCharacteristics(activityElement, activity);
        }
    }

    public ActivityImpl parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scopeElement, boolean isAfterEventBasedGateway) {
        ActivityImpl nestedActivity = this.createActivityOnScope(intermediateEventElement, scopeElement);
        nestedActivity.setActivityBehavior(new IntermediateCatchEventActivitiBehaviour());
        Element timerEventDefinition = intermediateEventElement.element("timerEventDefinition");
        Element signalEventDefinition = intermediateEventElement.element("signalEventDefinition");
        if (timerEventDefinition != null) {
            this.parseIntemediateTimerEventDefinition(timerEventDefinition, nestedActivity, isAfterEventBasedGateway);
        } else if (signalEventDefinition != null) {
            this.parseIntemediateSignalEventDefinition(signalEventDefinition, nestedActivity, isAfterEventBasedGateway);
        } else {
            this.addError("Unsupported intermediate catch event type", intermediateEventElement);
        }
        return nestedActivity;
    }

    public ActivityImpl parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scopeElement) {
        boolean otherUnsupportedThrowingIntermediateEvent;
        ActivityImpl nestedActivityImpl = this.createActivityOnScope(intermediateEventElement, scopeElement);
        FlowNodeActivityBehavior activityBehavior = null;
        Element signalEventDefinitionElement = intermediateEventElement.element("signalEventDefinition");
        Element compensateEventDefinitionElement = intermediateEventElement.element("compensateEventDefinition");
        boolean bl = otherUnsupportedThrowingIntermediateEvent = intermediateEventElement.element("escalationEventDefinition") != null || intermediateEventElement.element("messageEventDefinition") != null || intermediateEventElement.element("linkEventDefinition") != null;
        if (signalEventDefinitionElement != null) {
            SignalEventDefinition signalDefinition = this.parseSignalEventDefinition(signalEventDefinitionElement);
            activityBehavior = new IntermediateThrowSignalEventActivityBehavior(signalDefinition);
        } else if (compensateEventDefinitionElement != null) {
            CompensateEventDefinition compensateEventDefinition = this.parseCompensateEventDefinition(compensateEventDefinitionElement, scopeElement);
            activityBehavior = new IntermediateThrowCompensationEventActivityBehavior(compensateEventDefinition);
        } else if (otherUnsupportedThrowingIntermediateEvent) {
            this.addError("Unsupported intermediate throw event type", intermediateEventElement);
        } else {
            activityBehavior = new IntermediateThrowNoneEventActivityBehavior();
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateThrowEvent(intermediateEventElement, scopeElement, nestedActivityImpl);
        }
        nestedActivityImpl.setActivityBehavior(activityBehavior);
        this.parseExecutionListenersOnScope(intermediateEventElement, nestedActivityImpl);
        return nestedActivityImpl;
    }

    protected CompensateEventDefinition parseCompensateEventDefinition(Element compensateEventDefinitionElement, ScopeImpl scopeElement) {
        String activityRef = compensateEventDefinitionElement.attribute("activityRef");
        boolean waitForCompletion = "true".equals(compensateEventDefinitionElement.attribute("waitForCompletion", "true"));
        if (activityRef != null && scopeElement.findActivity(activityRef) == null) {
            this.addError("Invalid attribute value for 'activityRef': no activity with id '" + activityRef + "' in current scope", compensateEventDefinitionElement);
        }
        CompensateEventDefinition compensateEventDefinition = new CompensateEventDefinition();
        compensateEventDefinition.setActivityRef(activityRef);
        compensateEventDefinition.setWaitForCompletion(waitForCompletion);
        return compensateEventDefinition;
    }

    protected void parseCatchCompensateEventDefinition(Element compensateEventDefinition, ActivityImpl activity) {
        activity.setProperty("type", "compensationBoundaryCatch");
        ScopeImpl parent = activity.getParent();
        for (ActivityImpl child : parent.getActivities()) {
            if (!child.getProperty("type").equals("compensationBoundaryCatch") || child == activity) continue;
            this.addError("multiple boundary events with compensateEventDefinition not supported on same activity", compensateEventDefinition);
        }
    }

    protected ActivityBehavior parseBoundaryCancelEventDefinition(Element cancelEventDefinition, ActivityImpl activity) {
        activity.setProperty("type", "cancelBoundaryCatch");
        ActivityImpl parent = (ActivityImpl)activity.getParent();
        if (!parent.getProperty("type").equals("transaction")) {
            this.addError("boundary event with cancelEventDefinition only supported on transaction subprocesses", cancelEventDefinition);
        }
        for (ActivityImpl child : parent.getActivities()) {
            if (!child.getProperty("type").equals("cancelBoundaryCatch") || child == activity) continue;
            this.addError("multiple boundary events with cancelEventDefinition not supported on same transaction subprocess", cancelEventDefinition);
        }
        return new CancelBoundaryEventActivityBehavior();
    }

    public void parseMultiInstanceLoopCharacteristics(Element activityElement, ActivityImpl activity) {
        if (!(activity.getActivityBehavior() instanceof AbstractBpmnActivityBehavior)) {
            return;
        }
        Element miLoopCharacteristics = activityElement.element("multiInstanceLoopCharacteristics");
        if (miLoopCharacteristics != null) {
            Element inputDataItem;
            String elementVariable;
            String loopDataInputRefText;
            Element loopDataInputRef;
            String collection;
            Element completionCondition;
            MultiInstanceActivityBehavior miActivityBehavior = null;
            boolean isSequential = this.parseBooleanAttribute(miLoopCharacteristics.attribute("isSequential"), false);
            miActivityBehavior = isSequential ? new SequentialMultiInstanceBehavior(activity, (AbstractBpmnActivityBehavior)activity.getActivityBehavior()) : new ParallelMultiInstanceBehavior(activity, (AbstractBpmnActivityBehavior)activity.getActivityBehavior());
            activity.setScope(true);
            activity.setProperty("multiInstance", isSequential ? "sequential" : "parallel");
            activity.setActivityBehavior(miActivityBehavior);
            Element loopCardinality = miLoopCharacteristics.element("loopCardinality");
            if (loopCardinality != null) {
                String loopCardinalityText = loopCardinality.getText();
                if (loopCardinalityText == null || "".equals(loopCardinalityText)) {
                    this.addError("loopCardinality must be defined for a multiInstanceLoopCharacteristics definition ", miLoopCharacteristics);
                }
                miActivityBehavior.setLoopCardinalityExpression(this.expressionManager.createExpression(loopCardinalityText));
            }
            if ((completionCondition = miLoopCharacteristics.element("completionCondition")) != null) {
                String completionConditionText = completionCondition.getText();
                miActivityBehavior.setCompletionConditionExpression(this.expressionManager.createExpression(completionConditionText));
            }
            if ((collection = miLoopCharacteristics.attributeNS("http://activiti.org/bpmn", "collection")) != null) {
                if (collection.contains("{")) {
                    miActivityBehavior.setCollectionExpression(this.expressionManager.createExpression(collection));
                } else {
                    miActivityBehavior.setCollectionVariable(collection);
                }
            }
            if ((loopDataInputRef = miLoopCharacteristics.element("loopDataInputRef")) != null && (loopDataInputRefText = loopDataInputRef.getText()) != null) {
                if (loopDataInputRefText.contains("{")) {
                    miActivityBehavior.setCollectionExpression(this.expressionManager.createExpression(loopDataInputRefText));
                } else {
                    miActivityBehavior.setCollectionVariable(loopDataInputRefText);
                }
            }
            if ((elementVariable = miLoopCharacteristics.attributeNS("http://activiti.org/bpmn", "elementVariable")) != null) {
                miActivityBehavior.setCollectionElementVariable(elementVariable);
            }
            if ((inputDataItem = miLoopCharacteristics.element("inputDataItem")) != null) {
                String inputDataItemName = inputDataItem.attribute("name");
                miActivityBehavior.setCollectionElementVariable(inputDataItemName);
            }
            if (miActivityBehavior.getLoopCardinalityExpression() == null && miActivityBehavior.getCollectionExpression() == null && miActivityBehavior.getCollectionVariable() == null) {
                this.addError("Either loopCardinality or loopDataInputRef/activiti:collection must been set", miLoopCharacteristics);
            }
            if (miActivityBehavior.getCollectionExpression() == null && miActivityBehavior.getCollectionVariable() == null && miActivityBehavior.getCollectionElementVariable() != null) {
                this.addError("LoopDataInputRef/activiti:collection must be set when using inputDataItem or activiti:elementVariable", miLoopCharacteristics);
            }
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseMultiInstanceLoopCharacteristics(activityElement, miLoopCharacteristics, activity);
            }
        }
    }

    public ActivityImpl createActivityOnScope(Element activityElement, ScopeImpl scopeElement) {
        String id = activityElement.attribute("id");
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Parsing activity " + id);
        }
        ActivityImpl activity = scopeElement.createActivity(id);
        activity.setProperty("name", activityElement.attribute("name"));
        activity.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(activityElement));
        activity.setProperty("default", activityElement.attribute("default"));
        activity.setProperty("type", activityElement.getTagName());
        activity.setProperty("line", activityElement.getLine());
        String isForCompensation = activityElement.attribute(PROPERTYNAME_IS_FOR_COMPENSATION);
        if (isForCompensation != null && (isForCompensation.equals("true") || isForCompensation.equals("TRUE"))) {
            activity.setProperty(PROPERTYNAME_IS_FOR_COMPENSATION, true);
        }
        return activity;
    }

    public String parseDocumentation(Element element) {
        Element docElement = element.element(PROPERTYNAME_DOCUMENTATION);
        if (docElement != null) {
            return docElement.getText().trim();
        }
        return null;
    }

    public ActivityImpl parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(exclusiveGwElement, scope);
        activity.setActivityBehavior(new ExclusiveGatewayActivityBehavior());
        this.parseExecutionListenersOnScope(exclusiveGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseExclusiveGateway(exclusiveGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(inclusiveGwElement, scope);
        activity.setActivityBehavior(new InclusiveGatewayActivityBehavior());
        this.parseExecutionListenersOnScope(inclusiveGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseInclusiveGateway(inclusiveGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseEventBasedGateway(Element eventBasedGwElement, Element parentElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(eventBasedGwElement, scope);
        activity.setActivityBehavior(new EventBasedGatewayActivityBehavior());
        activity.setScope(true);
        this.parseExecutionListenersOnScope(eventBasedGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseEventBasedGateway(eventBasedGwElement, scope, activity);
        }
        List<Element> sequenceFlows = parentElement.elements("sequenceFlow");
        HashMap<String, Element> siblingsMap = new HashMap<String, Element>();
        List<Element> siblings = parentElement.elements();
        for (Element sibling : siblings) {
            siblingsMap.put(sibling.attribute("id"), sibling);
        }
        for (Element sequenceFlow : sequenceFlows) {
            Element sibling;
            String sourceRef = sequenceFlow.attribute("sourceRef");
            String targetRef = sequenceFlow.attribute("targetRef");
            if (!activity.getId().equals(sourceRef) || (sibling = (Element)siblingsMap.get(targetRef)) == null) continue;
            if (sibling.getTagName().equals("intermediateCatchEvent")) {
                this.parseIntermediateCatchEvent(sibling, activity, true);
                continue;
            }
            this.addError("Event based gateway can only be connected to elements of type intermediateCatchEvent", sibling);
        }
        return activity;
    }

    public ActivityImpl parseParallelGateway(Element parallelGwElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(parallelGwElement, scope);
        activity.setActivityBehavior(new ParallelGatewayActivityBehavior());
        this.parseExecutionListenersOnScope(parallelGwElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseParallelGateway(parallelGwElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseScriptTask(Element scriptTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(scriptTaskElement, scope);
        String script = null;
        String language = null;
        String resultVariableName = null;
        Element scriptElement = scriptTaskElement.element("script");
        if (scriptElement != null) {
            script = scriptElement.getText();
            if (language == null) {
                language = scriptTaskElement.attribute("scriptFormat");
            }
            if (language == null) {
                language = "juel";
            }
            if ((resultVariableName = scriptTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariable")) == null) {
                resultVariableName = scriptTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariableName");
            }
        }
        activity.setAsync(this.isAsync(scriptTaskElement));
        activity.setExclusive(this.isExclusive(scriptTaskElement));
        activity.setActivityBehavior(new ScriptTaskActivityBehavior(script, language, resultVariableName));
        this.parseExecutionListenersOnScope(scriptTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseScriptTask(scriptTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseServiceTask(Element serviceTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(serviceTaskElement, scope);
        String type = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "type");
        String className = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "class");
        String expression = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "expression");
        String delegateExpression = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "delegateExpression");
        String resultVariableName = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariable");
        if (resultVariableName == null) {
            resultVariableName = serviceTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariableName");
        }
        String implementation = serviceTaskElement.attribute("implementation");
        String operationRef = this.resolveName(serviceTaskElement.attribute("operationRef"));
        activity.setAsync(this.isAsync(serviceTaskElement));
        activity.setExclusive(this.isExclusive(serviceTaskElement));
        if (type != null) {
            if (type.equalsIgnoreCase("mail")) {
                this.parseEmailServiceTask(activity, serviceTaskElement, this.parseFieldDeclarations(serviceTaskElement));
            } else if (type.equalsIgnoreCase("mule")) {
                this.parseMuleServiceTask(activity, serviceTaskElement, this.parseFieldDeclarations(serviceTaskElement));
            } else if (type.equalsIgnoreCase("shell")) {
                this.parseShellServiceTask(activity, serviceTaskElement, this.parseFieldDeclarations(serviceTaskElement));
            } else {
                this.addError("Invalid usage of type attribute: '" + type + "'", serviceTaskElement);
            }
        } else if (className != null && className.trim().length() > 0) {
            if (resultVariableName != null) {
                this.addError("'resultVariableName' not supported for service tasks using 'class'", serviceTaskElement);
            }
            activity.setActivityBehavior(new ClassDelegate(className, this.parseFieldDeclarations(serviceTaskElement)));
        } else if (delegateExpression != null) {
            if (resultVariableName != null) {
                this.addError("'resultVariableName' not supported for service tasks using 'delegateExpression'", serviceTaskElement);
            }
            activity.setActivityBehavior(new ServiceTaskDelegateExpressionActivityBehavior(this.expressionManager.createExpression(delegateExpression)));
        } else if (expression != null && expression.trim().length() > 0) {
            activity.setActivityBehavior(new ServiceTaskExpressionActivityBehavior(this.expressionManager.createExpression(expression), resultVariableName));
        } else if (implementation != null && operationRef != null && implementation.equalsIgnoreCase("##WebService")) {
            if (!this.operations.containsKey(operationRef)) {
                this.addError(operationRef + " does not exist", serviceTaskElement);
            } else {
                AbstractDataAssociation dataAssociation;
                Operation operation = this.operations.get(operationRef);
                WebServiceActivityBehavior webServiceActivityBehavior = new WebServiceActivityBehavior(operation);
                Element ioSpecificationElement = serviceTaskElement.element("ioSpecification");
                if (ioSpecificationElement != null) {
                    IOSpecification ioSpecification = this.parseIOSpecification(ioSpecificationElement);
                    webServiceActivityBehavior.setIoSpecification(ioSpecification);
                }
                for (Element dataAssociationElement : serviceTaskElement.elements("dataInputAssociation")) {
                    dataAssociation = this.parseDataInputAssociation(dataAssociationElement);
                    webServiceActivityBehavior.addDataInputAssociation(dataAssociation);
                }
                for (Element dataAssociationElement : serviceTaskElement.elements("dataOutputAssociation")) {
                    dataAssociation = this.parseDataOutputAssociation(dataAssociationElement);
                    webServiceActivityBehavior.addDataOutputAssociation(dataAssociation);
                }
                activity.setActivityBehavior(webServiceActivityBehavior);
            }
        } else {
            this.addError("One of the attributes 'class', 'delegateExpression', 'type', 'operation', or 'expression' is mandatory on serviceTask.", serviceTaskElement);
        }
        this.parseExecutionListenersOnScope(serviceTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseServiceTask(serviceTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(businessRuleTaskElement, scope);
        BusinessRuleTaskActivityBehavior ruleActivity = new BusinessRuleTaskActivityBehavior();
        String ruleVariableInputString = businessRuleTaskElement.attributeNS("http://activiti.org/bpmn", "ruleVariablesInput");
        String rulesString = businessRuleTaskElement.attributeNS("http://activiti.org/bpmn", "rules");
        String excludeString = businessRuleTaskElement.attributeNS("http://activiti.org/bpmn", "exclude");
        String resultVariableNameString = businessRuleTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariable");
        activity.setAsync(this.isAsync(businessRuleTaskElement));
        activity.setExclusive(this.isExclusive(businessRuleTaskElement));
        if (resultVariableNameString == null) {
            resultVariableNameString = businessRuleTaskElement.attributeNS("http://activiti.org/bpmn", "resultVariableName");
        }
        if (ruleVariableInputString != null) {
            String[] ruleVariableInputObjects;
            for (String ruleVariableInputObject : ruleVariableInputObjects = ruleVariableInputString.split(",")) {
                ruleActivity.addRuleVariableInputIdExpression(this.expressionManager.createExpression(ruleVariableInputObject.trim()));
            }
        }
        if (rulesString != null) {
            String[] rules;
            for (String rule : rules = rulesString.split(",")) {
                ruleActivity.addRuleIdExpression(this.expressionManager.createExpression(rule.trim()));
            }
            if (excludeString != null) {
                if (!"true".equalsIgnoreCase(excludeString = excludeString.trim()) && !"false".equalsIgnoreCase(excludeString)) {
                    this.addError("'exclude' only supports true or false for business rule tasks", businessRuleTaskElement);
                } else {
                    ruleActivity.setExclude(Boolean.valueOf(excludeString.toLowerCase()));
                }
            }
        } else if (excludeString != null) {
            this.addError("'exclude' not supported for business rule tasks not defining 'rules'", businessRuleTaskElement);
        }
        if (resultVariableNameString != null) {
            if (!((resultVariableNameString = resultVariableNameString.trim()).length() > 0)) {
                this.addError("'resultVariable' must contain a text value for business rule tasks", businessRuleTaskElement);
            } else {
                ruleActivity.setResultVariable(resultVariableNameString);
            }
        } else {
            ruleActivity.setResultVariable("org.activiti.engine.rules.OUTPUT");
        }
        activity.setActivityBehavior(ruleActivity);
        this.parseExecutionListenersOnScope(businessRuleTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBusinessRuleTask(businessRuleTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseSendTask(Element sendTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(sendTaskElement, scope);
        activity.setAsync(this.isAsync(sendTaskElement));
        activity.setExclusive(this.isExclusive(sendTaskElement));
        String type = sendTaskElement.attributeNS("http://activiti.org/bpmn", "type");
        String implementation = sendTaskElement.attribute("implementation");
        String operationRef = this.resolveName(sendTaskElement.attribute("operationRef"));
        if (type != null) {
            if (type.equalsIgnoreCase("mail")) {
                this.parseEmailServiceTask(activity, sendTaskElement, this.parseFieldDeclarations(sendTaskElement));
            } else if (type.equalsIgnoreCase("mule")) {
                this.parseMuleServiceTask(activity, sendTaskElement, this.parseFieldDeclarations(sendTaskElement));
            } else {
                this.addError("Invalid usage of type attribute: '" + type + "'", sendTaskElement);
            }
        } else if (implementation != null && operationRef != null && implementation.equalsIgnoreCase("##WebService")) {
            if (!this.operations.containsKey(operationRef)) {
                this.addError(operationRef + " does not exist", sendTaskElement);
            } else {
                AbstractDataAssociation dataAssociation;
                Operation operation = this.operations.get(operationRef);
                WebServiceActivityBehavior webServiceActivityBehavior = new WebServiceActivityBehavior(operation);
                Element ioSpecificationElement = sendTaskElement.element("ioSpecification");
                if (ioSpecificationElement != null) {
                    IOSpecification ioSpecification = this.parseIOSpecification(ioSpecificationElement);
                    webServiceActivityBehavior.setIoSpecification(ioSpecification);
                }
                for (Element dataAssociationElement : sendTaskElement.elements("dataInputAssociation")) {
                    dataAssociation = this.parseDataInputAssociation(dataAssociationElement);
                    webServiceActivityBehavior.addDataInputAssociation(dataAssociation);
                }
                for (Element dataAssociationElement : sendTaskElement.elements("dataOutputAssociation")) {
                    dataAssociation = this.parseDataOutputAssociation(dataAssociationElement);
                    webServiceActivityBehavior.addDataOutputAssociation(dataAssociation);
                }
                activity.setActivityBehavior(webServiceActivityBehavior);
            }
        } else {
            this.addError("One of the attributes 'type' or 'operation' is mandatory on sendTask.", sendTaskElement);
        }
        this.parseExecutionListenersOnScope(sendTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseSendTask(sendTaskElement, scope, activity);
        }
        return activity;
    }

    protected AbstractDataAssociation parseDataOutputAssociation(Element dataAssociationElement) {
        String targetRef = dataAssociationElement.element("targetRef").getText();
        if (dataAssociationElement.element("sourceRef") != null) {
            String sourceRef = dataAssociationElement.element("sourceRef").getText();
            return new MessageImplicitDataOutputAssociation(targetRef, sourceRef);
        }
        Expression transformation = this.expressionManager.createExpression(dataAssociationElement.element("transformation").getText());
        TransformationDataOutputAssociation dataOutputAssociation = new TransformationDataOutputAssociation(null, targetRef, transformation);
        return dataOutputAssociation;
    }

    protected void parseMuleServiceTask(ActivityImpl activity, Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        try {
            Class<?> theClass = Class.forName("org.activiti.mule.MuleSendActivitiBehavior");
            activity.setActivityBehavior((ActivityBehavior)ClassDelegate.instantiateDelegate(theClass, fieldDeclarations));
        }
        catch (ClassNotFoundException e) {
            this.addError("Could not find org.activiti.mule.MuleSendActivitiBehavior", serviceTaskElement);
        }
    }

    protected void parseEmailServiceTask(ActivityImpl activity, Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        this.validateFieldDeclarationsForEmail(serviceTaskElement, fieldDeclarations);
        activity.setActivityBehavior((MailActivityBehavior)ClassDelegate.instantiateDelegate(MailActivityBehavior.class, fieldDeclarations));
    }

    protected void parseShellServiceTask(ActivityImpl activity, Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        this.validateFieldDeclarationsForShell(serviceTaskElement, fieldDeclarations);
        activity.setActivityBehavior((ActivityBehavior)ClassDelegate.instantiateDelegate(ShellActivityBehavior.class, fieldDeclarations));
    }

    protected void validateFieldDeclarationsForEmail(Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        boolean toDefined = false;
        boolean textOrHtmlDefined = false;
        for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
            if (fieldDeclaration.getName().equals("to")) {
                toDefined = true;
            }
            if (fieldDeclaration.getName().equals("html")) {
                textOrHtmlDefined = true;
            }
            if (!fieldDeclaration.getName().equals("text")) continue;
            textOrHtmlDefined = true;
        }
        if (!toDefined) {
            this.addError("No recipient is defined on the mail activity", serviceTaskElement);
        }
        if (!textOrHtmlDefined) {
            this.addError("Text or html field should be provided", serviceTaskElement);
        }
    }

    protected void validateFieldDeclarationsForShell(Element serviceTaskElement, List<FieldDeclaration> fieldDeclarations) {
        boolean shellCommandDefined = false;
        for (FieldDeclaration fieldDeclaration : fieldDeclarations) {
            String fieldName = fieldDeclaration.getName();
            FixedValue fieldFixedValue = (FixedValue)fieldDeclaration.getValue();
            String fieldValue = fieldFixedValue.getExpressionText();
            shellCommandDefined |= fieldName.equals("command");
            if (!fieldName.equals("wait") && !fieldName.equals("redirectError") && !fieldName.equals("cleanEnv") || fieldValue.toLowerCase().equals("true") || fieldValue.toLowerCase().equals("false")) continue;
            this.addError("undefined value for shell " + fieldName + " parameter :" + fieldValue.toString(), serviceTaskElement);
        }
        if (!shellCommandDefined) {
            this.addError("No shell command is defined on the shell activity", serviceTaskElement);
        }
    }

    public List<FieldDeclaration> parseFieldDeclarations(Element element) {
        List<Element> fieldDeclarationElements;
        ArrayList<FieldDeclaration> fieldDeclarations = new ArrayList<FieldDeclaration>();
        Element elementWithFieldInjections = element.element("extensionElements");
        if (elementWithFieldInjections == null) {
            elementWithFieldInjections = element;
        }
        if ((fieldDeclarationElements = elementWithFieldInjections.elementsNS("http://activiti.org/bpmn", "field")) != null && !fieldDeclarationElements.isEmpty()) {
            for (Element fieldDeclarationElement : fieldDeclarationElements) {
                FieldDeclaration fieldDeclaration = this.parseFieldDeclaration(element, fieldDeclarationElement);
                if (fieldDeclaration == null) continue;
                fieldDeclarations.add(fieldDeclaration);
            }
        }
        return fieldDeclarations;
    }

    protected FieldDeclaration parseFieldDeclaration(Element serviceTaskElement, Element fieldDeclarationElement) {
        String fieldName = fieldDeclarationElement.attribute("name");
        FieldDeclaration fieldDeclaration = this.parseStringFieldDeclaration(fieldDeclarationElement, serviceTaskElement, fieldName);
        if (fieldDeclaration == null) {
            fieldDeclaration = this.parseExpressionFieldDeclaration(fieldDeclarationElement, serviceTaskElement, fieldName);
        }
        if (fieldDeclaration == null) {
            this.addError("One of the following is mandatory on a field declaration: one of attributes stringValue|expression or one of child elements string|expression", serviceTaskElement);
        }
        return fieldDeclaration;
    }

    protected FieldDeclaration parseStringFieldDeclaration(Element fieldDeclarationElement, Element serviceTaskElement, String fieldName) {
        try {
            String fieldValue = this.getStringValueFromAttributeOrElement("stringValue", "string", fieldDeclarationElement);
            if (fieldValue != null) {
                return new FieldDeclaration(fieldName, Expression.class.getName(), new FixedValue(fieldValue));
            }
        }
        catch (ActivitiException ae) {
            if (ae.getMessage().contains("multiple elements with tag name")) {
                this.addError("Multiple string field declarations found", serviceTaskElement);
            }
            this.addError("Error when paring field declarations: " + ae.getMessage(), serviceTaskElement);
        }
        return null;
    }

    protected FieldDeclaration parseExpressionFieldDeclaration(Element fieldDeclarationElement, Element serviceTaskElement, String fieldName) {
        try {
            String expression = this.getStringValueFromAttributeOrElement("expression", "expression", fieldDeclarationElement);
            if (expression != null && expression.trim().length() > 0) {
                return new FieldDeclaration(fieldName, Expression.class.getName(), this.expressionManager.createExpression(expression));
            }
        }
        catch (ActivitiException ae) {
            if (ae.getMessage().contains("multiple elements with tag name")) {
                this.addError("Multiple expression field declarations found", serviceTaskElement);
            }
            this.addError("Error when paring field declarations: " + ae.getMessage(), serviceTaskElement);
        }
        return null;
    }

    protected String getStringValueFromAttributeOrElement(String attributeName, String elementName, Element element) {
        String value = null;
        String attributeValue = element.attribute(attributeName);
        Element childElement = element.elementNS("http://activiti.org/bpmn", elementName);
        String stringElementText = null;
        if (attributeValue != null && childElement != null) {
            this.addError("Can't use attribute '" + attributeName + "' and element '" + elementName + "' together, only use one", element);
        } else if (childElement != null) {
            stringElementText = childElement.getText();
            if (stringElementText == null || stringElementText.length() == 0) {
                this.addError("No valid value found in attribute '" + attributeName + "' nor element '" + elementName + "'", element);
            } else {
                value = stringElementText;
            }
        } else if (attributeValue != null && attributeValue.length() > 0) {
            value = attributeValue;
        }
        return value;
    }

    public ActivityImpl parseTask(Element taskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(taskElement, scope);
        activity.setActivityBehavior(new TaskActivityBehavior());
        activity.setAsync(this.isAsync(taskElement));
        activity.setExclusive(this.isExclusive(taskElement));
        this.parseExecutionListenersOnScope(taskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseTask(taskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseManualTask(Element manualTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(manualTaskElement, scope);
        activity.setActivityBehavior(new ManualTaskActivityBehavior());
        this.parseExecutionListenersOnScope(manualTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseManualTask(manualTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseReceiveTask(Element receiveTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(receiveTaskElement, scope);
        activity.setActivityBehavior(new ReceiveTaskActivityBehavior());
        activity.setAsync(this.isAsync(receiveTaskElement));
        activity.setExclusive(this.isExclusive(receiveTaskElement));
        this.parseExecutionListenersOnScope(receiveTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseReceiveTask(receiveTaskElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseUserTask(Element userTaskElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(userTaskElement, scope);
        activity.setAsync(this.isAsync(userTaskElement));
        activity.setExclusive(this.isExclusive(userTaskElement));
        TaskDefinition taskDefinition = this.parseTaskDefinition(userTaskElement, activity.getId(), (ProcessDefinitionEntity)scope.getProcessDefinition());
        UserTaskActivityBehavior userTaskActivity = new UserTaskActivityBehavior(this.expressionManager, taskDefinition);
        activity.setActivityBehavior(userTaskActivity);
        this.parseProperties(userTaskElement, activity);
        this.parseExecutionListenersOnScope(userTaskElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseUserTask(userTaskElement, scope, activity);
        }
        return activity;
    }

    public TaskDefinition parseTaskDefinition(Element taskElement, String taskDefinitionKey, ProcessDefinitionEntity processDefinition) {
        String descriptionStr;
        String taskFormHandlerClassName = taskElement.attributeNS("http://activiti.org/bpmn", "formHandlerClass");
        TaskFormHandler taskFormHandler = taskFormHandlerClassName != null ? (TaskFormHandler)ReflectUtil.instantiate(taskFormHandlerClassName) : new DefaultTaskFormHandler();
        taskFormHandler.parseConfiguration(taskElement, this.deployment, processDefinition, this);
        TaskDefinition taskDefinition = new TaskDefinition(taskFormHandler);
        taskDefinition.setKey(taskDefinitionKey);
        processDefinition.getTaskDefinitions().put(taskDefinitionKey, taskDefinition);
        String name = taskElement.attribute("name");
        if (name != null) {
            taskDefinition.setNameExpression(this.expressionManager.createExpression(name));
        }
        if ((descriptionStr = this.parseDocumentation(taskElement)) != null) {
            taskDefinition.setDescriptionExpression(this.expressionManager.createExpression(descriptionStr));
        }
        this.parseHumanPerformer(taskElement, taskDefinition);
        this.parsePotentialOwner(taskElement, taskDefinition);
        this.parseUserTaskCustomExtensions(taskElement, taskDefinition);
        return taskDefinition;
    }

    protected void parseHumanPerformer(Element taskElement, TaskDefinition taskDefinition) {
        Element humanPerformerElement;
        List<Element> humanPerformerElements = taskElement.elements(HUMAN_PERFORMER);
        if (humanPerformerElements.size() > 1) {
            this.addError("Invalid task definition: multiple humanPerformer sub elements defined for " + taskDefinition.getNameExpression(), taskElement);
        } else if (humanPerformerElements.size() == 1 && (humanPerformerElement = humanPerformerElements.get(0)) != null) {
            this.parseHumanPerformerResourceAssignment(humanPerformerElement, taskDefinition);
        }
    }

    protected void parsePotentialOwner(Element taskElement, TaskDefinition taskDefinition) {
        List<Element> potentialOwnerElements = taskElement.elements(POTENTIAL_OWNER);
        for (Element potentialOwnerElement : potentialOwnerElements) {
            this.parsePotentialOwnerResourceAssignment(potentialOwnerElement, taskDefinition);
        }
    }

    protected void parseHumanPerformerResourceAssignment(Element performerElement, TaskDefinition taskDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            taskDefinition.setAssigneeExpression(this.expressionManager.createExpression(feElement.getText()));
        }
    }

    protected void parsePotentialOwnerResourceAssignment(Element performerElement, TaskDefinition taskDefinition) {
        Element feElement;
        Element raeElement = performerElement.element(RESOURCE_ASSIGNMENT_EXPR);
        if (raeElement != null && (feElement = raeElement.element(FORMAL_EXPRESSION)) != null) {
            List<String> assignmentExpressions = this.parseCommaSeparatedList(feElement.getText());
            for (String assignmentExpression : assignmentExpressions) {
                if ((assignmentExpression = assignmentExpression.trim()).startsWith(USER_PREFIX)) {
                    String userAssignementId = this.getAssignmentId(assignmentExpression, USER_PREFIX);
                    taskDefinition.addCandidateUserIdExpression(this.expressionManager.createExpression(userAssignementId));
                    continue;
                }
                if (assignmentExpression.startsWith(GROUP_PREFIX)) {
                    String groupAssignementId = this.getAssignmentId(assignmentExpression, GROUP_PREFIX);
                    taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(groupAssignementId));
                    continue;
                }
                taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(assignmentExpression));
            }
        }
    }

    protected String getAssignmentId(String expression, String prefix) {
        return expression.substring(prefix.length(), expression.length() - 1).trim();
    }

    protected void parseUserTaskCustomExtensions(Element taskElement, TaskDefinition taskDefinition) {
        String priorityExpression;
        String candidateGroupsString;
        String candidateUsersString;
        String assignee = taskElement.attributeNS("http://activiti.org/bpmn", ASSIGNEE_EXTENSION);
        if (assignee != null) {
            if (taskDefinition.getAssigneeExpression() == null) {
                taskDefinition.setAssigneeExpression(this.expressionManager.createExpression(assignee));
            } else {
                this.addError("Invalid usage: duplicate assignee declaration for task " + taskDefinition.getNameExpression(), taskElement);
            }
        }
        if ((candidateUsersString = taskElement.attributeNS("http://activiti.org/bpmn", CANDIDATE_USERS_EXTENSION)) != null) {
            List<String> candidateUsers = this.parseCommaSeparatedList(candidateUsersString);
            for (String candidateUser : candidateUsers) {
                taskDefinition.addCandidateUserIdExpression(this.expressionManager.createExpression(candidateUser.trim()));
            }
        }
        if ((candidateGroupsString = taskElement.attributeNS("http://activiti.org/bpmn", CANDIDATE_GROUPS_EXTENSION)) != null) {
            List<String> candidateGroups = this.parseCommaSeparatedList(candidateGroupsString);
            for (String candidateGroup : candidateGroups) {
                taskDefinition.addCandidateGroupIdExpression(this.expressionManager.createExpression(candidateGroup.trim()));
            }
        }
        this.parseTaskListeners(taskElement, taskDefinition);
        String dueDateExpression = taskElement.attributeNS("http://activiti.org/bpmn", DUE_DATE_EXTENSION);
        if (dueDateExpression != null) {
            taskDefinition.setDueDateExpression(this.expressionManager.createExpression(dueDateExpression));
        }
        if ((priorityExpression = taskElement.attributeNS("http://activiti.org/bpmn", PRIORITY_EXTENSION)) != null) {
            taskDefinition.setPriorityExpression(this.expressionManager.createExpression(priorityExpression));
        }
    }

    protected List<String> parseCommaSeparatedList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null && !"".equals(s)) {
            StringCharacterIterator iterator = new StringCharacterIterator(s);
            char c = iterator.first();
            StringBuilder strb = new StringBuilder();
            boolean insideExpression = false;
            while (c != '\uffff') {
                if (c == '{' || c == '$') {
                    insideExpression = true;
                } else if (c == '}') {
                    insideExpression = false;
                } else if (c == ',' && !insideExpression) {
                    result.add(strb.toString().trim());
                    strb.delete(0, strb.length());
                }
                if (c != ',' || insideExpression) {
                    strb.append(c);
                }
                c = iterator.next();
            }
            if (strb.length() > 0) {
                result.add(strb.toString().trim());
            }
        }
        return result;
    }

    protected void parseTaskListeners(Element userTaskElement, TaskDefinition taskDefinition) {
        Element extentionsElement = userTaskElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> taskListenerElements = extentionsElement.elementsNS("http://activiti.org/bpmn", "taskListener");
            for (Element taskListenerElement : taskListenerElements) {
                String eventName = taskListenerElement.attribute("event");
                if (eventName != null) {
                    if ("create".equals(eventName) || "assignment".equals(eventName) || "complete".equals(eventName)) {
                        TaskListener taskListener = this.parseTaskListener(taskListenerElement);
                        taskDefinition.addTaskListener(eventName, taskListener);
                        continue;
                    }
                    this.addError("Invalid eventName for taskListener: choose 'create' |'assignment'", userTaskElement);
                    continue;
                }
                this.addError("Event is mandatory on taskListener", userTaskElement);
            }
        }
    }

    protected TaskListener parseTaskListener(Element taskListenerElement) {
        TaskListener taskListener = null;
        String className = taskListenerElement.attribute("class");
        String expression = taskListenerElement.attribute("expression");
        String delegateExpression = taskListenerElement.attribute("delegateExpression");
        if (className != null) {
            taskListener = new ClassDelegate(className, this.parseFieldDeclarations(taskListenerElement));
        } else if (expression != null) {
            taskListener = new ExpressionTaskListener(this.expressionManager.createExpression(expression));
        } else if (delegateExpression != null) {
            taskListener = new DelegateExpressionTaskListener(this.expressionManager.createExpression(delegateExpression));
        } else {
            this.addError("Element 'class' or 'expression' is mandatory on taskListener", taskListenerElement);
        }
        return taskListener;
    }

    public void parseEndEvents(Element parentElement, ScopeImpl scope) {
        for (Element endEventElement : parentElement.elements("endEvent")) {
            ActivityImpl activity = this.createActivityOnScope(endEventElement, scope);
            Element errorEventDefinition = endEventElement.element("errorEventDefinition");
            Element cancelEventDefinition = endEventElement.element("cancelEventDefinition");
            if (errorEventDefinition != null) {
                String errorRef = errorEventDefinition.attribute("errorRef");
                if (errorRef == null || "".equals(errorRef)) {
                    this.addError("'errorRef' attribute is mandatory on error end event", errorEventDefinition);
                } else {
                    Error error = this.errors.get(errorRef);
                    activity.setProperty("type", "errorEndEvent");
                    activity.setActivityBehavior(new ErrorEndEventActivityBehavior(error != null ? error.getErrorCode() : errorRef));
                }
            } else if (cancelEventDefinition != null) {
                if (scope.getProperty("type") == null || !scope.getProperty("type").equals("transaction")) {
                    this.addError("end event with cancelEventDefinition only supported inside transaction subprocess", cancelEventDefinition);
                } else {
                    activity.setProperty("type", "cancelEndEvent");
                    activity.setActivityBehavior(new CancelEndEventActivityBehavior());
                }
            } else {
                activity.setActivityBehavior(new NoneEndEventActivityBehavior());
            }
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseEndEvent(endEventElement, scope, activity);
            }
        }
    }

    public void parseBoundaryEvents(Element parentElement, ScopeImpl scopeElement) {
        for (Element boundaryEventElement : parentElement.elements("boundaryEvent")) {
            ActivityImpl parentActivity;
            String attachedToRef = boundaryEventElement.attribute("attachedToRef");
            if (attachedToRef == null || attachedToRef.equals("")) {
                this.addError("AttachedToRef is required when using a timerEventDefinition", boundaryEventElement);
            }
            String id = boundaryEventElement.attribute("id");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Parsing boundary event " + id);
            }
            if ((parentActivity = scopeElement.findActivity(attachedToRef)) == null) {
                this.addError("Invalid reference in boundary event. Make sure that the referenced activity is defined in the same scope as the boundary event", boundaryEventElement);
            }
            ActivityImpl nestedActivity = this.createActivityOnScope(boundaryEventElement, parentActivity);
            String cancelActivity = boundaryEventElement.attribute("cancelActivity", "true");
            boolean interrupting = cancelActivity.equals("true");
            ActivityBehavior behavior = new BoundaryEventActivityBehavior(interrupting);
            Element timerEventDefinition = boundaryEventElement.element("timerEventDefinition");
            Element errorEventDefinition = boundaryEventElement.element("errorEventDefinition");
            Element signalEventDefinition = boundaryEventElement.element("signalEventDefinition");
            Element cancelEventDefinition = boundaryEventElement.element("cancelEventDefinition");
            Element compensateEventDefinition = boundaryEventElement.element("compensateEventDefinition");
            if (timerEventDefinition != null) {
                this.parseBoundaryTimerEventDefinition(timerEventDefinition, interrupting, nestedActivity);
            } else if (errorEventDefinition != null) {
                interrupting = true;
                this.parseBoundaryErrorEventDefinition(errorEventDefinition, interrupting, parentActivity, nestedActivity);
            } else if (signalEventDefinition != null) {
                this.parseBoundarySignalEventDefinition(signalEventDefinition, interrupting, nestedActivity);
            } else if (cancelEventDefinition != null) {
                behavior = this.parseBoundaryCancelEventDefinition(cancelEventDefinition, nestedActivity);
            } else if (compensateEventDefinition != null) {
                this.parseCatchCompensateEventDefinition(compensateEventDefinition, nestedActivity);
            } else {
                this.addError("Unsupported boundary event type", boundaryEventElement);
            }
            nestedActivity.setActivityBehavior(behavior);
        }
    }

    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl timerActivity) {
        timerActivity.setProperty("type", "boundaryTimer");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-transition");
        this.addTimerDeclaration(timerActivity.getParent(), timerDeclaration);
        if (timerActivity.getParent() instanceof ActivityImpl) {
            ((ActivityImpl)timerActivity.getParent()).setScope(true);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryTimerEventDefinition(timerEventDefinition, interrupting, timerActivity);
        }
    }

    public void parseBoundarySignalEventDefinition(Element signalEventDefinition, boolean interrupting, ActivityImpl signalActivity) {
        signalActivity.setProperty("type", "boundarySignal");
        SignalEventDefinition signalDefinition = this.parseSignalEventDefinition(signalEventDefinition);
        if (signalActivity.getId() == null) {
            this.addError("boundary event has no id", signalEventDefinition);
        }
        signalDefinition.setActivityId(signalActivity.getId());
        this.addSignalDefinition(signalActivity.getParent(), signalDefinition);
        if (signalActivity.getParent() instanceof ActivityImpl) {
            ((ActivityImpl)signalActivity.getParent()).setScope(true);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundarySignalEventDefinition(signalEventDefinition, interrupting, signalActivity);
        }
    }

    private void parseTimerStartEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity, ProcessDefinitionEntity processDefinition) {
        timerActivity.setProperty("type", "startTimerEvent");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-start-event");
        timerDeclaration.setJobHandlerConfiguration(processDefinition.getKey());
        ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)processDefinition.getProperty(PROPERTYNAME_START_TIMER);
        if (timerDeclarations == null) {
            timerDeclarations = new ArrayList<TimerDeclarationImpl>();
            processDefinition.setProperty(PROPERTYNAME_START_TIMER, timerDeclarations);
        }
        timerDeclarations.add(timerDeclaration);
    }

    protected void parseIntemediateSignalEventDefinition(Element signalEventDefinition, ActivityImpl signalActivity, boolean isAfterEventBasedGateway) {
        signalActivity.setProperty("type", "intermediateSignalCatch");
        SignalEventDefinition signalDefinition = this.parseSignalEventDefinition(signalEventDefinition);
        signalDefinition.setActivityId(signalActivity.getId());
        if (isAfterEventBasedGateway) {
            this.addSignalDefinition(signalActivity.getParent(), signalDefinition);
        } else {
            this.addSignalDefinition(signalActivity, signalDefinition);
            signalActivity.setScope(true);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateSignalCatchEventDefinition(signalEventDefinition, signalActivity);
        }
    }

    protected void addSignalDefinition(ScopeImpl scopeImpl, SignalEventDefinition signalDefinition) {
        ArrayList<SignalEventDefinition> signalDefinitions = (ArrayList<SignalEventDefinition>)scopeImpl.getProperty(PROPERTYNAME_SIGNAL_DEFINITION_NAME);
        if (signalDefinitions == null) {
            signalDefinitions = new ArrayList<SignalEventDefinition>();
            scopeImpl.setProperty(PROPERTYNAME_SIGNAL_DEFINITION_NAME, signalDefinitions);
        }
        signalDefinitions.add(signalDefinition);
    }

    protected SignalEventDefinition parseSignalEventDefinition(Element signalEventDefinitionElement) {
        String signalRef = signalEventDefinitionElement.attribute("signalRef");
        if (signalRef == null) {
            this.addError("signalEventDefinition does not have required property 'signalRef'", signalEventDefinitionElement);
            return null;
        }
        SignalDefinition signalDefinition = this.signals.get(signalRef);
        if (signalDefinition == null) {
            this.addError("Could not find signal with id '" + signalRef + "'", signalEventDefinitionElement);
        }
        SignalEventDefinition signalEventDefinition = new SignalEventDefinition(signalDefinition);
        boolean asynch = "true".equals(signalEventDefinitionElement.attributeNS("http://activiti.org/bpmn", "async", "false"));
        signalEventDefinition.setAsync(asynch);
        return signalEventDefinition;
    }

    private void parseIntemediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl timerActivity, boolean isAfterEventBasedGateway) {
        timerActivity.setProperty("type", "intermediateTimer");
        TimerDeclarationImpl timerDeclaration = this.parseTimer(timerEventDefinition, timerActivity, "timer-intermediate-transition");
        if (isAfterEventBasedGateway) {
            this.addTimerDeclaration(timerActivity.getParent(), timerDeclaration);
        } else {
            this.addTimerDeclaration(timerActivity, timerDeclaration);
            timerActivity.setScope(true);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseIntermediateTimerEventDefinition(timerEventDefinition, timerActivity);
        }
    }

    private TimerDeclarationImpl parseTimer(Element timerEventDefinition, ScopeImpl timerActivity, String jobHandlerType) {
        TimerDeclarationType type = TimerDeclarationType.DATE;
        Expression expression = this.parseExpression(timerEventDefinition, "timeDate");
        if (expression == null) {
            type = TimerDeclarationType.CYCLE;
            expression = this.parseExpression(timerEventDefinition, "timeCycle");
        }
        if (expression == null) {
            type = TimerDeclarationType.DURATION;
            expression = this.parseExpression(timerEventDefinition, "timeDuration");
        }
        if (expression == null) {
            this.addError("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed).", timerEventDefinition);
        }
        TimerDeclarationImpl timerDeclaration = new TimerDeclarationImpl(expression, type, jobHandlerType);
        timerDeclaration.setJobHandlerConfiguration(timerActivity.getId());
        timerDeclaration.setExclusive("true".equals(timerEventDefinition.attributeNS("http://activiti.org/bpmn", "exclusive", String.valueOf(true))));
        return timerDeclaration;
    }

    private Expression parseExpression(Element parent, String name) {
        Element value = parent.element(name);
        if (value != null) {
            String expressionText = value.getText().trim();
            return this.expressionManager.createExpression(expressionText);
        }
        return null;
    }

    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
        nestedErrorEventActivity.setProperty("type", "boundaryError");
        ScopeImpl catchingScope = nestedErrorEventActivity.getParent();
        ((ActivityImpl)catchingScope).setScope(true);
        String errorRef = errorEventDefinition.attribute("errorRef");
        Error error = null;
        ErrorEventDefinition definition = new ErrorEventDefinition(nestedErrorEventActivity.getId());
        if (errorRef != null) {
            error = this.errors.get(errorRef);
            definition.setErrorCode(error == null ? errorRef : error.getErrorCode());
        }
        this.addErrorEventDefinition(definition, catchingScope);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseBoundaryErrorEventDefinition(errorEventDefinition, interrupting, activity, nestedErrorEventActivity);
        }
    }

    protected void addErrorEventDefinition(ErrorEventDefinition errorEventDefinition, ScopeImpl catchingScope) {
        ArrayList<ErrorEventDefinition> errorEventDefinitions = (ArrayList<ErrorEventDefinition>)catchingScope.getProperty(PROPERTYNAME_ERROR_EVENT_DEFINITIONS);
        if (errorEventDefinitions == null) {
            errorEventDefinitions = new ArrayList<ErrorEventDefinition>();
            catchingScope.setProperty(PROPERTYNAME_ERROR_EVENT_DEFINITIONS, errorEventDefinitions);
        }
        errorEventDefinitions.add(errorEventDefinition);
        Collections.sort(errorEventDefinitions, ErrorEventDefinition.comparator);
    }

    protected List<ActivityImpl> getAllChildActivitiesOfType(String type, ScopeImpl scope) {
        ArrayList<ActivityImpl> children = new ArrayList<ActivityImpl>();
        for (ActivityImpl childActivity : scope.getActivities()) {
            if (type.equals(childActivity.getProperty("type"))) {
                children.add(childActivity);
            }
            children.addAll(this.getAllChildActivitiesOfType(type, childActivity));
        }
        return children;
    }

    protected boolean isChildActivity(ActivityImpl activityToCheck, ActivityImpl possibleParentActivity) {
        for (ActivityImpl child : possibleParentActivity.getActivities()) {
            if (!child.getId().equals(activityToCheck.getId()) && !this.isChildActivity(activityToCheck, child)) continue;
            return true;
        }
        return false;
    }

    protected void addTimerDeclaration(ScopeImpl scope, TimerDeclarationImpl timerDeclaration) {
        ArrayList<TimerDeclarationImpl> timerDeclarations = (ArrayList<TimerDeclarationImpl>)scope.getProperty(PROPERTYNAME_TIMER_DECLARATION);
        if (timerDeclarations == null) {
            timerDeclarations = new ArrayList<TimerDeclarationImpl>();
            scope.setProperty(PROPERTYNAME_TIMER_DECLARATION, timerDeclarations);
        }
        timerDeclarations.add(timerDeclaration);
    }

    protected void addVariableDeclaration(ScopeImpl scope, VariableDeclaration variableDeclaration) {
        ArrayList<VariableDeclaration> variableDeclarations = (ArrayList<VariableDeclaration>)scope.getProperty(PROPERTYNAME_VARIABLE_DECLARATIONS);
        if (variableDeclarations == null) {
            variableDeclarations = new ArrayList<VariableDeclaration>();
            scope.setProperty(PROPERTYNAME_VARIABLE_DECLARATIONS, variableDeclarations);
        }
        variableDeclarations.add(variableDeclaration);
    }

    public ActivityImpl parseSubProcess(Element subProcessElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(subProcessElement, scope);
        activity.setAsync(this.isAsync(subProcessElement));
        activity.setExclusive(this.isExclusive(subProcessElement));
        Boolean isTriggeredByEvent = this.parseBooleanAttribute(subProcessElement.attribute("triggeredByEvent"), false);
        activity.setProperty("triggeredByEvent", isTriggeredByEvent);
        activity.setScope(isTriggeredByEvent == false);
        activity.setActivityBehavior(new SubProcessActivityBehavior());
        this.parseScope(subProcessElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseSubProcess(subProcessElement, scope, activity);
        }
        return activity;
    }

    private ActivityImpl parseTransaction(Element transactionElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(transactionElement, scope);
        activity.setAsync(this.isAsync(transactionElement));
        activity.setExclusive(this.isExclusive(transactionElement));
        activity.setScope(true);
        activity.setActivityBehavior(new TransactionActivityBehavior());
        this.parseScope(transactionElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseTransaction(transactionElement, scope, activity);
        }
        return activity;
    }

    public ActivityImpl parseCallActivity(Element callActivityElement, ScopeImpl scope) {
        ActivityImpl activity = this.createActivityOnScope(callActivityElement, scope);
        activity.setAsync(this.isAsync(callActivityElement));
        activity.setExclusive(this.isExclusive(callActivityElement));
        String calledElement = callActivityElement.attribute("calledElement");
        if (calledElement == null) {
            this.addError("Missing attribute 'calledElement'", callActivityElement);
        }
        CallActivityBehavior callActivityBehaviour = null;
        String expressionRegex = "\\$+\\{+.+\\}";
        callActivityBehaviour = calledElement.matches(expressionRegex) ? new CallActivityBehavior(this.expressionManager.createExpression(calledElement)) : new CallActivityBehavior(calledElement);
        Element extentionsElement = callActivityElement.element("extensionElements");
        if (extentionsElement != null) {
            String source;
            Expression expression;
            String target;
            String sourceExpression;
            for (Element listenerElement : extentionsElement.elementsNS("http://activiti.org/bpmn", "in")) {
                sourceExpression = listenerElement.attribute("sourceExpression");
                target = listenerElement.attribute("target");
                if (sourceExpression != null) {
                    expression = this.expressionManager.createExpression(sourceExpression.trim());
                    callActivityBehaviour.addDataInputAssociation(new SimpleDataInputAssociation(expression, target));
                    continue;
                }
                source = listenerElement.attribute("source");
                callActivityBehaviour.addDataInputAssociation(new SimpleDataInputAssociation(source, target));
            }
            for (Element listenerElement : extentionsElement.elementsNS("http://activiti.org/bpmn", "out")) {
                sourceExpression = listenerElement.attribute("sourceExpression");
                target = listenerElement.attribute("target");
                if (sourceExpression != null) {
                    expression = this.expressionManager.createExpression(sourceExpression.trim());
                    callActivityBehaviour.addDataOutputAssociation(new MessageImplicitDataOutputAssociation(target, expression));
                    continue;
                }
                source = listenerElement.attribute("source");
                callActivityBehaviour.addDataOutputAssociation(new MessageImplicitDataOutputAssociation(target, source));
            }
        }
        activity.setScope(true);
        activity.setActivityBehavior(callActivityBehaviour);
        this.parseExecutionListenersOnScope(callActivityElement, activity);
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseCallActivity(callActivityElement, scope, activity);
        }
        return activity;
    }

    public void parseProperties(Element element, ActivityImpl activity) {
        List<Element> propertyElements = element.elements("property");
        for (Element propertyElement : propertyElements) {
            this.parseProperty(propertyElement, activity);
        }
    }

    public void parseProperty(Element propertyElement, ActivityImpl activity) {
        String id = propertyElement.attribute("id");
        String name = propertyElement.attribute("name");
        if (name == null) {
            if (id == null) {
                this.addError("Invalid property usage on line " + propertyElement.getLine() + ": no id or name specified.", propertyElement);
            } else {
                name = id;
            }
        }
        String itemSubjectRef = propertyElement.attribute("itemSubjectRef");
        String type = null;
        if (itemSubjectRef != null) {
            ItemDefinition itemDefinition = this.itemDefinitions.get(itemSubjectRef);
            if (itemDefinition != null) {
                StructureDefinition structure = itemDefinition.getStructureDefinition();
                type = structure.getId();
            } else {
                this.addError("Invalid itemDefinition reference: " + itemSubjectRef + " not found", propertyElement);
            }
        }
        this.parsePropertyCustomExtensions(activity, propertyElement, name, type);
    }

    public void parsePropertyCustomExtensions(ActivityImpl activity, Element propertyElement, String propertyName, String propertyType) {
        String linkExpr;
        String link;
        String destExpr;
        String dst;
        String srcExpr;
        if (propertyType == null) {
            String type = propertyElement.attributeNS("http://activiti.org/bpmn", "type");
            propertyType = type != null ? type : "string";
        }
        VariableDeclaration variableDeclaration = new VariableDeclaration(propertyName, propertyType);
        this.addVariableDeclaration(activity, variableDeclaration);
        activity.setScope(true);
        String src = propertyElement.attributeNS("http://activiti.org/bpmn", "src");
        if (src != null) {
            variableDeclaration.setSourceVariableName(src);
        }
        if ((srcExpr = propertyElement.attributeNS("http://activiti.org/bpmn", "srcExpr")) != null) {
            Expression sourceExpression = this.expressionManager.createExpression(srcExpr);
            variableDeclaration.setSourceExpression(sourceExpression);
        }
        if ((dst = propertyElement.attributeNS("http://activiti.org/bpmn", "dst")) != null) {
            variableDeclaration.setDestinationVariableName(dst);
        }
        if ((destExpr = propertyElement.attributeNS("http://activiti.org/bpmn", "dstExpr")) != null) {
            Expression destinationExpression = this.expressionManager.createExpression(destExpr);
            variableDeclaration.setDestinationExpression(destinationExpression);
        }
        if ((link = propertyElement.attributeNS("http://activiti.org/bpmn", "link")) != null) {
            variableDeclaration.setLink(link);
        }
        if ((linkExpr = propertyElement.attributeNS("http://activiti.org/bpmn", "linkExpr")) != null) {
            Expression linkExpression = this.expressionManager.createExpression(linkExpr);
            variableDeclaration.setLinkExpression(linkExpression);
        }
        for (BpmnParseListener parseListener : this.parseListeners) {
            parseListener.parseProperty(propertyElement, variableDeclaration, activity);
        }
    }

    public void parseSequenceFlow(Element processElement, ScopeImpl scope) {
        for (Element sequenceFlowElement : processElement.elements("sequenceFlow")) {
            String id = sequenceFlowElement.attribute("id");
            String sourceRef = sequenceFlowElement.attribute("sourceRef");
            String destinationRef = sequenceFlowElement.attribute("targetRef");
            ActivityImpl sourceActivity = scope.findActivity(sourceRef);
            ActivityImpl destinationActivity = scope.findActivity(destinationRef);
            if (sourceActivity == null) {
                this.addError("Invalid source '" + sourceRef + "' of sequence flow '" + id + "'", sequenceFlowElement);
                continue;
            }
            if (destinationActivity == null) {
                this.addError("Invalid destination '" + destinationRef + "' of sequence flow '" + id + "'", sequenceFlowElement);
                continue;
            }
            if (sourceActivity.getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) continue;
            if (destinationActivity.getActivityBehavior() instanceof IntermediateCatchEventActivitiBehaviour && destinationActivity.getParentActivity() != null && destinationActivity.getParentActivity().getActivityBehavior() instanceof EventBasedGatewayActivityBehavior) {
                this.addError("Invalid incoming sequenceflow for intermediateCatchEvent with id '" + destinationActivity.getId() + "' connected to an event-based gateway.", sequenceFlowElement);
                continue;
            }
            TransitionImpl transition = sourceActivity.createOutgoingTransition(id);
            this.sequenceFlows.put(id, transition);
            transition.setProperty("name", sequenceFlowElement.attribute("name"));
            transition.setProperty(PROPERTYNAME_DOCUMENTATION, this.parseDocumentation(sequenceFlowElement));
            transition.setDestination(destinationActivity);
            this.parseSequenceFlowConditionExpression(sequenceFlowElement, transition);
            this.parseExecutionListenersOnTransition(sequenceFlowElement, transition);
            for (BpmnParseListener parseListener : this.parseListeners) {
                parseListener.parseSequenceFlow(sequenceFlowElement, scope, transition);
            }
        }
    }

    public void parseSequenceFlowConditionExpression(Element seqFlowElement, TransitionImpl seqFlow) {
        Element conditionExprElement = seqFlowElement.element("conditionExpression");
        if (conditionExprElement != null) {
            String expression = conditionExprElement.getText().trim();
            String type = conditionExprElement.attributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            if (type != null && !type.equals("tFormalExpression")) {
                this.addError("Invalid type, only tFormalExpression is currently supported", conditionExprElement);
            }
            UelExpressionCondition expressionCondition = new UelExpressionCondition(this.expressionManager.createExpression(expression));
            seqFlow.setProperty(PROPERTYNAME_CONDITION_TEXT, expression);
            seqFlow.setProperty(PROPERTYNAME_CONDITION, expressionCondition);
        }
    }

    public void parseExecutionListenersOnScope(Element scopeElement, ScopeImpl scope) {
        Element extentionsElement = scopeElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> listenerElements = extentionsElement.elementsNS("http://activiti.org/bpmn", "executionListener");
            for (Element listenerElement : listenerElements) {
                ExecutionListener listener;
                String eventName = listenerElement.attribute("event");
                if (!this.isValidEventNameForScope(eventName, listenerElement) || (listener = this.parseExecutionListener(listenerElement)) == null) continue;
                scope.addExecutionListener(eventName, listener);
            }
        }
    }

    protected boolean isValidEventNameForScope(String eventName, Element listenerElement) {
        if (eventName != null && eventName.trim().length() > 0) {
            if ("start".equals(eventName) || "end".equals(eventName)) {
                return true;
            }
            this.addError("Attribute 'eventName' must be one of {start|end}", listenerElement);
        } else {
            this.addError("Attribute 'eventName' is mandatory on listener", listenerElement);
        }
        return false;
    }

    public void parseExecutionListenersOnTransition(Element activitiElement, TransitionImpl activity) {
        Element extentionsElement = activitiElement.element("extensionElements");
        if (extentionsElement != null) {
            List<Element> listenerElements = extentionsElement.elementsNS("http://activiti.org/bpmn", "executionListener");
            for (Element listenerElement : listenerElements) {
                ExecutionListener listener = this.parseExecutionListener(listenerElement);
                if (listener == null) continue;
                activity.addExecutionListener(listener);
            }
        }
    }

    public ExecutionListener parseExecutionListener(Element executionListenerElement) {
        ExecutionListener executionListener = null;
        String className = executionListenerElement.attribute("class");
        String expression = executionListenerElement.attribute("expression");
        String delegateExpression = executionListenerElement.attribute("delegateExpression");
        if (className != null) {
            executionListener = new ClassDelegate(className, this.parseFieldDeclarations(executionListenerElement));
        } else if (expression != null) {
            executionListener = new ExpressionExecutionListener(this.expressionManager.createExpression(expression));
        } else if (delegateExpression != null) {
            executionListener = new DelegateExpressionExecutionListener(this.expressionManager.createExpression(delegateExpression));
        } else {
            this.addError("Element 'class' or 'expression' is mandatory on executionListener", executionListenerElement);
        }
        return executionListener;
    }

    public Operation getOperation(String operationId) {
        return this.operations.get(operationId);
    }

    public void parseDiagramInterchangeElements() {
        List<Element> diagrams = this.rootElement.elementsNS("http://www.omg.org/spec/BPMN/20100524/DI", "BPMNDiagram");
        if (!diagrams.isEmpty()) {
            for (Element diagramElement : diagrams) {
                this.parseBPMNDiagram(diagramElement);
            }
        }
    }

    public void parseBPMNDiagram(Element bpmndiagramElement) {
        Element bpmnPlane = bpmndiagramElement.elementNS("http://www.omg.org/spec/BPMN/20100524/DI", "BPMNPlane");
        if (bpmnPlane != null) {
            this.parseBPMNPlane(bpmnPlane);
        }
    }

    public void parseBPMNPlane(Element bpmnPlaneElement) {
        String processId = bpmnPlaneElement.attribute("bpmnElement");
        if (processId != null && !"".equals(processId)) {
            ProcessDefinitionEntity processDefinition = this.getProcessDefinition(processId);
            if (processDefinition != null) {
                processDefinition.setGraphicalNotationDefined(true);
                List<Element> shapes = bpmnPlaneElement.elementsNS("http://www.omg.org/spec/BPMN/20100524/DI", "BPMNShape");
                for (Element shape : shapes) {
                    this.parseBPMNShape(shape, processDefinition);
                }
                List<Element> edges = bpmnPlaneElement.elementsNS("http://www.omg.org/spec/BPMN/20100524/DI", "BPMNEdge");
                for (Element edge : edges) {
                    this.parseBPMNEdge(edge, processDefinition);
                }
            } else {
                this.addError("Invalid reference in 'bpmnElement' attribute, process " + processId + " not found", bpmnPlaneElement);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNPlane ", bpmnPlaneElement);
        }
    }

    public void parseBPMNShape(Element bpmnShapeElement, ProcessDefinitionEntity processDefinition) {
        String activityId = bpmnShapeElement.attribute("bpmnElement");
        if (activityId != null && !"".equals(activityId)) {
            ActivityImpl activity = processDefinition.findActivity(activityId);
            if (activity != null) {
                Element bounds = bpmnShapeElement.elementNS("http://www.omg.org/spec/DD/20100524/DC", "Bounds");
                if (bounds != null) {
                    activity.setX(this.parseDoubleAttribute(bpmnShapeElement, "x", bounds.attribute("x"), true).intValue());
                    activity.setY(this.parseDoubleAttribute(bpmnShapeElement, "y", bounds.attribute("y"), true).intValue());
                    activity.setWidth(this.parseDoubleAttribute(bpmnShapeElement, "width", bounds.attribute("width"), true).intValue());
                    activity.setHeight(this.parseDoubleAttribute(bpmnShapeElement, "height", bounds.attribute("height"), true).intValue());
                } else {
                    this.addError("'Bounds' element is required", bpmnShapeElement);
                }
                String isExpanded = bpmnShapeElement.attribute(PROPERTYNAME_ISEXPANDED);
                if (isExpanded != null) {
                    activity.setProperty(PROPERTYNAME_ISEXPANDED, this.parseBooleanAttribute(isExpanded));
                }
            } else if (!this.elementIds.contains(activityId)) {
                this.addError("Invalid reference in 'bpmnElement' attribute, activity " + activityId + "not found", bpmnShapeElement);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNShape", bpmnShapeElement);
        }
    }

    public void parseBPMNEdge(Element bpmnEdgeElement, ProcessDefinitionEntity processDefinition) {
        String sequenceFlowId = bpmnEdgeElement.attribute("bpmnElement");
        if (sequenceFlowId != null && !"".equals(sequenceFlowId)) {
            TransitionImpl sequenceFlow = this.sequenceFlows.get(sequenceFlowId);
            if (sequenceFlow != null) {
                List<Element> waypointElements = bpmnEdgeElement.elementsNS("http://www.omg.org/spec/DD/20100524/DI", "waypoint");
                if (waypointElements.size() >= 2) {
                    ArrayList<Integer> waypoints = new ArrayList<Integer>();
                    for (Element waypointElement : waypointElements) {
                        waypoints.add(this.parseDoubleAttribute(waypointElement, "x", waypointElement.attribute("x"), true).intValue());
                        waypoints.add(this.parseDoubleAttribute(waypointElement, "y", waypointElement.attribute("y"), true).intValue());
                    }
                    sequenceFlow.setWaypoints(waypoints);
                } else {
                    this.addError("Minimum 2 waypoint elements must be definted for a 'BPMNEdge'", bpmnEdgeElement);
                }
            } else if (!this.elementIds.contains(sequenceFlowId)) {
                this.addError("Invalid reference in 'bpmnElement' attribute, sequenceFlow " + sequenceFlowId + "not found", bpmnEdgeElement);
            }
        } else {
            this.addError("'bpmnElement' attribute is required on BPMNEdge", bpmnEdgeElement);
        }
    }

    public List<ProcessDefinitionEntity> getProcessDefinitions() {
        return this.processDefinitions;
    }

    public ProcessDefinitionEntity getProcessDefinition(String processDefinitionKey) {
        for (ProcessDefinitionEntity processDefinition : this.processDefinitions) {
            if (!processDefinition.getKey().equals(processDefinitionKey)) continue;
            return processDefinition;
        }
        return null;
    }

    @Override
    public BpmnParse name(String name) {
        super.name(name);
        return this;
    }

    @Override
    public BpmnParse sourceInputStream(InputStream inputStream) {
        super.sourceInputStream(inputStream);
        return this;
    }

    @Override
    public BpmnParse sourceResource(String resource, ClassLoader classLoader) {
        super.sourceResource(resource, classLoader);
        return this;
    }

    @Override
    public BpmnParse sourceResource(String resource) {
        super.sourceResource(resource);
        return this;
    }

    @Override
    public BpmnParse sourceString(String string) {
        super.sourceString(string);
        return this;
    }

    @Override
    public BpmnParse sourceUrl(String url) {
        super.sourceUrl(url);
        return this;
    }

    @Override
    public BpmnParse sourceUrl(URL url) {
        super.sourceUrl(url);
        return this;
    }

    public void addStructure(StructureDefinition structure) {
        this.structures.put(structure.getId(), structure);
    }

    public void addService(BpmnInterfaceImplementation bpmnInterfaceImplementation) {
        this.interfaceImplementations.put(bpmnInterfaceImplementation.getName(), bpmnInterfaceImplementation);
    }

    public void addOperation(OperationImplementation operationImplementation) {
        this.operationImplementations.put(operationImplementation.getId(), operationImplementation);
    }

    public Boolean parseBooleanAttribute(String booleanText, boolean defaultValue) {
        if (booleanText == null) {
            return defaultValue;
        }
        return this.parseBooleanAttribute(booleanText);
    }

    public Boolean parseBooleanAttribute(String booleanText) {
        if ("true".equals(booleanText) || "enabled".equals(booleanText) || "on".equals(booleanText) || "active".equals(booleanText) || "yes".equals(booleanText)) {
            return Boolean.TRUE;
        }
        if ("false".equals(booleanText) || "disabled".equals(booleanText) || "off".equals(booleanText) || "inactive".equals(booleanText) || "no".equals(booleanText)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Double parseDoubleAttribute(Element element, String attributename, String doubleText, boolean required) {
        if (required && (doubleText == null || "".equals(doubleText))) {
            this.addError(attributename + " is required", element);
        } else {
            try {
                return Double.parseDouble(doubleText);
            }
            catch (NumberFormatException e) {
                this.addError("Cannot parse " + attributename + ": " + e.getMessage(), element);
            }
        }
        return -1.0;
    }

    protected boolean isExclusive(Element element) {
        return "true".equals(element.attributeNS("http://activiti.org/bpmn", "exclusive", String.valueOf(true)));
    }

    protected boolean isAsync(Element element) {
        return "true".equals(element.attributeNS("http://activiti.org/bpmn", "async"));
    }
}

