/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmScope;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeUtil {
    public static ExecutionEntity findScopeExecution(ExecutionEntity execution, PvmScope scopeActivity) {
        if (scopeActivity instanceof PvmProcessDefinition) {
            return execution.getProcessInstance();
        }
        ActivityImpl currentActivity = execution.getActivity();
        ExecutionEntity candiadateExecution = null;
        ExecutionEntity originalExecution = execution;
        while (execution != null) {
            currentActivity = execution.getActivity();
            if (scopeActivity.getActivities().contains(currentActivity) || scopeActivity.equals(currentActivity)) {
                candiadateExecution = execution;
            } else if (currentActivity != null && currentActivity.contains((ActivityImpl)scopeActivity)) break;
            execution = execution.getParent();
        }
        if (originalExecution == candiadateExecution && originalExecution.getActivity().isScope() && !originalExecution.getActivity().equals(scopeActivity)) {
            candiadateExecution = originalExecution.getParent();
        }
        return candiadateExecution;
    }

    public static ActivityImpl findInParentScopesByBehaviorType(ActivityImpl activity, Class<? extends ActivityBehavior> behaviorType) {
        while (activity != null) {
            for (ActivityImpl childActivity : activity.getActivities()) {
                if (!behaviorType.isAssignableFrom(childActivity.getActivityBehavior().getClass())) continue;
                return childActivity;
            }
            activity = activity.getParentActivity();
        }
        return null;
    }

    public static void destroyScope(ActivityExecution execution, String reason) {
        ArrayList<? extends ActivityExecution> executions = new ArrayList<ActivityExecution>(execution.getExecutions());
        for (InterpretableExecution interpretableExecution : executions) {
            if (interpretableExecution.getSubProcessInstance() != null) {
                interpretableExecution.getSubProcessInstance().deleteCascade(reason);
            }
            interpretableExecution.deleteCascade(reason);
        }
    }

    public static void throwCompensationEvent(List<CompensateEventSubscriptionEntity> eventSubscriptions, ActivityExecution execution, boolean async) {
        for (CompensateEventSubscriptionEntity eventSubscription : eventSubscriptions) {
            ExecutionEntity compensatingExecution = null;
            if (eventSubscription.getConfiguration() != null) {
                compensatingExecution = Context.getCommandContext().getExecutionManager().findExecutionById(eventSubscription.getConfiguration());
                compensatingExecution.setParent((InterpretableExecution)execution);
                compensatingExecution.setEventScope(false);
            } else {
                compensatingExecution = (ExecutionEntity)execution.createExecution();
                eventSubscription.setConfiguration(compensatingExecution.getId());
            }
            compensatingExecution.setConcurrent(true);
        }
        Collections.sort(eventSubscriptions, new Comparator<EventSubscriptionEntity>(){

            @Override
            public int compare(EventSubscriptionEntity o1, EventSubscriptionEntity o2) {
                return o2.getCreated().compareTo(o1.getCreated());
            }
        });
        for (CompensateEventSubscriptionEntity compensateEventSubscriptionEntity : eventSubscriptions) {
            compensateEventSubscriptionEntity.eventReceived(null, async);
        }
    }

    public static void createEventScopeExecution(ExecutionEntity execution) {
        ExecutionEntity eventScope = ScopeUtil.findScopeExecution(execution, execution.getActivity().getParent());
        List<CompensateEventSubscriptionEntity> eventSubscriptions = execution.getCompensateEventSubscriptions();
        if (eventSubscriptions.size() > 0) {
            ExecutionEntity eventScopeExecution = eventScope.createExecution();
            eventScopeExecution.setActive(false);
            eventScopeExecution.setConcurrent(false);
            eventScopeExecution.setEventScope(true);
            eventScopeExecution.setActivity(execution.getActivity());
            execution.setConcurrent(false);
            Map<String, Object> variables = execution.getVariablesLocal();
            for (Map.Entry<String, Object> variable : variables.entrySet()) {
                eventScopeExecution.setVariableLocal(variable.getKey(), variable.getValue());
            }
            for (CompensateEventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
                eventSubscriptionEntity = eventSubscriptionEntity.moveUnder(eventScopeExecution);
            }
            CompensateEventSubscriptionEntity eventSubscription = CompensateEventSubscriptionEntity.createAndInsert(eventScope);
            eventSubscription.setActivity(execution.getActivity());
            eventSubscription.setConfiguration(eventScopeExecution.getId());
        }
    }
}

