/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class ParallelMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    public ParallelMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    protected void createInstances(ActivityExecution execution) throws Exception {
        ActivityExecution concurrentExecution;
        int loopCounter;
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances <= 0) {
            throw new ActivitiException("Invalid number of instances: must be positive integer value, but was " + nrOfInstances);
        }
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = execution.createExecution();
            concurrentExecution.setActive(true);
            concurrentExecution.setConcurrent(true);
            concurrentExecution.setScope(false);
            if (this.isExtraScopeNeeded()) {
                ActivityExecution extraScopedExecution = concurrentExecution.createExecution();
                extraScopedExecution.setActive(true);
                extraScopedExecution.setConcurrent(false);
                extraScopedExecution.setScope(true);
                concurrentExecution = extraScopedExecution;
            }
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = (ActivityExecution)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, "loopCounter", loopCounter);
            this.executeOriginalBehavior(concurrentExecution, loopCounter);
        }
    }

    public void leave(ActivityExecution execution) {
        this.callActivityEndListeners(execution);
        int loopCounter = this.getLoopVariable(execution, "loopCounter");
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
        if (this.isExtraScopeNeeded()) {
            ExecutionEntity extraScope = (ExecutionEntity)execution;
            execution = execution.getParent();
            extraScope.remove();
        }
        this.setLoopVariable(execution.getParent(), "nrOfCompletedInstances", nrOfCompletedInstances);
        this.setLoopVariable(execution.getParent(), "nrOfActiveInstances", nrOfActiveInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        executionEntity.inactivate();
        executionEntity.getParent().forceUpdate();
        List<ActivityExecution> joinedExecutions = executionEntity.findInactiveConcurrentExecutions(execution.getActivity());
        if (joinedExecutions.size() == nrOfInstances || this.completionConditionSatisfied(execution)) {
            ArrayList<ExecutionEntity> executionsToRemove = new ArrayList<ExecutionEntity>();
            for (ExecutionEntity childExecution : executionEntity.getParent().getExecutions()) {
                if (!childExecution.isActive()) continue;
                executionsToRemove.add(childExecution);
            }
            for (ExecutionEntity executionToRemove : executionsToRemove) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Execution " + executionToRemove + " still active, " + "but multi-instance is completed. Removing this execution.");
                }
                executionToRemove.inactivate();
                executionToRemove.deleteCascade("multi-instance completed");
            }
            executionEntity.takeAll(executionEntity.getActivity().getOutgoingTransitions(), joinedExecutions);
        }
    }
}

