/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricProcessInstanceQuery;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.HistoricProcessInstanceQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.QueryVariableValue;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.variable.VariableTypes;
import org.apache.commons.lang.time.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricProcessInstanceQueryImpl
extends AbstractQuery<HistoricProcessInstanceQuery, HistoricProcessInstance>
implements HistoricProcessInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String businessKey;
    protected boolean finished = false;
    protected boolean unfinished = false;
    protected String startedBy;
    protected String superProcessInstanceId;
    protected String processDefinitionKey;
    protected Set<String> processInstanceIds;
    protected Date startDateBy;
    protected Date startDateOn;
    protected Date finishDateBy;
    protected Date finishDateOn;
    protected Date startDateOnBegin;
    protected Date startDateOnEnd;
    protected Date finishDateOnBegin;
    protected Date finishDateOnEnd;
    protected List<QueryVariableValue> variables = new ArrayList<QueryVariableValue>();

    public HistoricProcessInstanceQueryImpl() {
    }

    public HistoricProcessInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricProcessInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public HistoricProcessInstanceQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceIds(Set<String> processInstanceIds) {
        if (processInstanceIds == null) {
            throw new ActivitiException("Set of process instance ids is null");
        }
        if (processInstanceIds.isEmpty()) {
            throw new ActivitiException("Set of process instance ids is empty");
        }
        this.processInstanceIds = processInstanceIds;
        return this;
    }

    @Override
    public HistoricProcessInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery processInstanceBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finished() {
        this.finished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery unfinished() {
        this.unfinished = true;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startedBy(String userId) {
        this.startedBy = userId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery superProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startDateBy(Date date) {
        this.startDateBy = this.calculateMidnight(date);
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery startDateOn(Date date) {
        this.startDateOn = date;
        this.startDateOnBegin = this.calculateMidnight(date);
        this.startDateOnEnd = this.calculateBeforeMidnight(date);
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishDateBy(Date date) {
        this.finishDateBy = this.calculateBeforeMidnight(date);
        return this;
    }

    @Override
    public HistoricProcessInstanceQuery finishDateOn(Date date) {
        this.finishDateOn = date;
        this.finishDateOnBegin = this.calculateMidnight(date);
        this.finishDateOnEnd = this.calculateBeforeMidnight(date);
        return this;
    }

    private Date calculateBeforeMidnight(Date date) {
        Date calc = DateUtils.truncate((Date)date, (int)5);
        calc = DateUtils.addDays((Date)calc, (int)1);
        return DateUtils.addSeconds((Date)calc, (int)-1);
    }

    private Date calculateMidnight(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    protected void ensureVariablesInitialized() {
        VariableTypes types = Context.getProcessEngineConfiguration().getVariableTypes();
        for (QueryVariableValue var : this.variables) {
            var.initialize(types);
        }
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceBusinessKey() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.BUSINESS_KEY);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceDuration() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.DURATION);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceStartTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.START_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceEndTime() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.END_TIME);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessDefinitionId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_DEFINITION_ID);
    }

    @Override
    public HistoricProcessInstanceQuery orderByProcessInstanceId() {
        return (HistoricProcessInstanceQuery)this.orderBy(HistoricProcessInstanceQueryProperty.PROCESS_INSTANCE_ID_);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricProcessInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getHistoricProcessInstanceManager().findHistoricProcessInstancesByQueryCriteria(this, page);
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public boolean isOpen() {
        return this.unfinished;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionIdLike() {
        return this.processDefinitionKey + ":%:%";
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public Set<String> getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }
}

