/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.List;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.HistoricActivityInstanceQueryProperty;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricActivityInstanceQueryImpl
extends AbstractQuery<HistoricActivityInstanceQuery, HistoricActivityInstance>
implements HistoricActivityInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected String activityInstanceId;
    protected String processInstanceId;
    protected String executionId;
    protected String processDefinitionId;
    protected String activityId;
    protected String activityName;
    protected String activityType;
    protected String assignee;
    protected boolean finished;
    protected boolean unfinished;

    public HistoricActivityInstanceQueryImpl() {
    }

    public HistoricActivityInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricActivityInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricActivityInstanceManager().findHistoricActivityInstanceCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricActivityInstance> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricActivityInstanceManager().findHistoricActivityInstancesByQueryCriteria(this, page);
    }

    @Override
    public HistoricActivityInstanceQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl activityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl activityType(String activityType) {
        this.activityType = activityType;
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl taskAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl finished() {
        this.finished = true;
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl unfinished() {
        this.unfinished = true;
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl orderByHistoricActivityInstanceDuration() {
        this.orderBy(HistoricActivityInstanceQueryProperty.DURATION);
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl orderByHistoricActivityInstanceEndTime() {
        this.orderBy(HistoricActivityInstanceQueryProperty.END);
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl orderByExecutionId() {
        this.orderBy(HistoricActivityInstanceQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl orderByHistoricActivityInstanceId() {
        this.orderBy(HistoricActivityInstanceQueryProperty.HISTORIC_ACTIVITY_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl orderByProcessDefinitionId() {
        this.orderBy(HistoricActivityInstanceQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl orderByProcessInstanceId() {
        this.orderBy(HistoricActivityInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl orderByHistoricActivityInstanceStartTime() {
        this.orderBy(HistoricActivityInstanceQueryProperty.START);
        return this;
    }

    @Override
    public HistoricActivityInstanceQuery orderByActivityId() {
        this.orderBy(HistoricActivityInstanceQueryProperty.ACTIVITY_ID);
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl orderByActivityName() {
        this.orderBy(HistoricActivityInstanceQueryProperty.ACTIVITY_NAME);
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl orderByActivityType() {
        this.orderBy(HistoricActivityInstanceQueryProperty.ACTIVITY_TYPE);
        return this;
    }

    @Override
    public HistoricActivityInstanceQueryImpl activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public String getOrderBy() {
        return this.orderBy;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }
}

