/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.QueryOperator;
import org.activiti.engine.impl.QueryVariableValue;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.variable.VariableTypes;
import org.activiti.engine.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExecutionVariableQueryImpl<T extends Query<?, ?>, U>
extends AbstractQuery<T, U> {
    private static final long serialVersionUID = 1L;
    protected List<QueryVariableValue> queryVariableValues = new ArrayList<QueryVariableValue>();

    public ExecutionVariableQueryImpl() {
    }

    public ExecutionVariableQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public ExecutionVariableQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public abstract long executeCount(CommandContext var1);

    @Override
    public abstract List<U> executeList(CommandContext var1, Page var2);

    public T variableValueEquals(String name, Object value) {
        this.addVariable(name, value, QueryOperator.EQUALS);
        return (T)this;
    }

    public T variableValueNotEquals(String name, Object value) {
        this.addVariable(name, value, QueryOperator.NOT_EQUALS);
        return (T)this;
    }

    public T variableValueGreaterThan(String name, Object value) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN);
        return (T)this;
    }

    public T variableValueGreaterThanOrEqual(String name, Object value) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN_OR_EQUAL);
        return (T)this;
    }

    public T variableValueLessThan(String name, Object value) {
        this.addVariable(name, value, QueryOperator.LESS_THAN);
        return (T)this;
    }

    public T variableValueLessThanOrEqual(String name, Object value) {
        this.addVariable(name, value, QueryOperator.LESS_THAN_OR_EQUAL);
        return (T)this;
    }

    public T variableValueLike(String name, String value) {
        this.addVariable(name, value, QueryOperator.LIKE);
        return (T)this;
    }

    private void addVariable(String name, Object value, QueryOperator operator) {
        if (name == null) {
            throw new ActivitiException("name is null");
        }
        if (value == null || this.isBoolean(value)) {
            switch (operator) {
                case GREATER_THAN: {
                    throw new ActivitiException("Booleans and null cannot be used in 'greater than' condition");
                }
                case LESS_THAN: {
                    throw new ActivitiException("Booleans and null cannot be used in 'less than' condition");
                }
                case GREATER_THAN_OR_EQUAL: {
                    throw new ActivitiException("Booleans and null cannot be used in 'greater than or equal' condition");
                }
                case LESS_THAN_OR_EQUAL: {
                    throw new ActivitiException("Booleans and null cannot be used in 'less than or equal' condition");
                }
                case LIKE: {
                    throw new ActivitiException("Booleans and null cannot be used in 'like' condition");
                }
            }
        }
        this.queryVariableValues.add(new QueryVariableValue(name, value, operator));
    }

    private boolean isBoolean(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }

    protected void ensureVariablesInitialized() {
        if (!this.queryVariableValues.isEmpty()) {
            VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
            for (QueryVariableValue queryVariableValue : this.queryVariableValues) {
                queryVariableValue.initialize(variableTypes);
            }
        }
    }

    public List<QueryVariableValue> getQueryVariableValues() {
        return this.queryVariableValues;
    }
}

