/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public class QNameUtil {
    public static String qNameToUri(QName qname) {
        String qUri = qname.getNamespaceURI();
        StringBuilder sb = new StringBuilder(qUri);
        if (!qUri.endsWith("#") && !qUri.endsWith("/")) {
            sb.append("#");
        }
        sb.append(qname.getLocalPart());
        return sb.toString();
    }

    public static QName uriToQName(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI is null");
        }
        int index = uri.lastIndexOf("#");
        if (index != -1) {
            String ns = uri.substring(0, index);
            String name = uri.substring(index + 1);
            return new QName(ns, name);
        }
        index = uri.lastIndexOf("/");
        if (index != -1) {
            String ns = uri.substring(0, index + 1);
            String name = uri.substring(index + 1);
            return new QName(ns, name);
        }
        throw new IllegalArgumentException("The URI (" + uri + ") does not contain slash character");
    }

    public static QName getNodeQName(Node node) {
        return new QName(node.getNamespaceURI(), node.getLocalName());
    }

    public static boolean compareQName(QName qname, Node node) {
        return qname.getNamespaceURI().equals(node.getNamespaceURI()) && qname.getLocalPart().equals(node.getLocalName());
    }
}

