/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.util.ClassPathUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JAXBUtil {
    private static final Trace LOGGER = TraceManager.getTrace(JAXBUtil.class);

    public static String getSchemaNamespace(Package pkg) {
        XmlSchema xmlSchemaAnn = pkg.getAnnotation(XmlSchema.class);
        if (xmlSchemaAnn == null) {
            return null;
        }
        return xmlSchemaAnn.namespace();
    }

    public static <T> String getTypeLocalName(Class<T> type) {
        XmlType xmlTypeAnn = type.getAnnotation(XmlType.class);
        if (xmlTypeAnn == null) {
            return null;
        }
        return xmlTypeAnn.name();
    }

    public static <T> QName getTypeQName(Class<T> type) {
        String namespace = JAXBUtil.getSchemaNamespace(type.getPackage());
        String localPart = JAXBUtil.getTypeLocalName(type);
        if (localPart == null) {
            return null;
        }
        return new QName(namespace, localPart);
    }

    public static boolean isElement(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Element) {
            return true;
        }
        return element instanceof JAXBElement;
    }

    public static QName getElementQName(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Element) {
            return DOMUtil.getQName((Element)element);
        }
        if (element instanceof JAXBElement) {
            return ((JAXBElement)element).getName();
        }
        throw new IllegalArgumentException("Not an element: " + element);
    }

    public static String getElementLocalName(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Element) {
            return ((Element)element).getLocalName();
        }
        if (element instanceof JAXBElement) {
            return ((JAXBElement)element).getName().getLocalPart();
        }
        throw new IllegalArgumentException("Not an element: " + element);
    }

    public static String getTextContentDump(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Element) {
            return ((Element)element).getTextContent();
        }
        return element.toString();
    }

    public static Document getDocument(Object element) {
        if (element instanceof Element) {
            return ((Element)element).getOwnerDocument();
        }
        return DOMUtil.getDocument();
    }

    public static Object findElement(List<Object> elements, QName elementName) {
        if (elements == null) {
            return null;
        }
        for (Object element : elements) {
            if (!elementName.equals(JAXBUtil.getElementQName(element))) continue;
            return element;
        }
        return null;
    }

    public static List<Object> listChildElements(Object parentElement) {
        if (parentElement == null) {
            return null;
        }
        List<Object> childElements = new ArrayList<Object>();
        if (parentElement instanceof Element) {
            Element parentEl = (Element)parentElement;
            NodeList childNodes = parentEl.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node item = childNodes.item(i);
                if (item.getNodeType() == 1) {
                    childElements.add(item);
                }
                ++i;
            }
        } else {
            if (parentElement instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)parentElement;
                Object jaxbObject = jaxbElement.getValue();
                Method xsdAnyMethod = JAXBUtil.lookForXsdAnyElementMethod(jaxbObject);
                if (xsdAnyMethod == null) {
                    throw new IllegalArgumentException("No xsd any method in " + jaxbObject);
                }
                Object result = null;
                try {
                    result = xsdAnyMethod.invoke(jaxbObject, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException("Unable to invoke xsd any method " + xsdAnyMethod.getName() + " on " + jaxbObject + ": " + e.getMessage(), e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Unable to invoke xsd any method " + xsdAnyMethod.getName() + " on " + jaxbObject + ": " + e.getMessage(), e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Unable to invoke xsd any method " + xsdAnyMethod.getName() + " on " + jaxbObject + ": " + e.getMessage(), e);
                }
                try {
                    childElements = (List)result;
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("Xsd any method " + xsdAnyMethod.getName() + " on " + jaxbObject + " returned unexpected type " + result.getClass(), e);
                }
            }
            throw new IllegalArgumentException("Not an element: " + parentElement + " (" + parentElement.getClass().getName() + ")");
        }
        return childElements;
    }

    private static Method lookForXsdAnyElementMethod(Object jaxbObject) {
        Class<?> jaxbClass = jaxbObject.getClass();
        Method[] methodArray = jaxbClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Annotation[] annotationArray = method.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                if (annotation.annotationType().isAssignableFrom(XmlAnyElement.class)) {
                    return method;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static Class findClassForType(QName typeName, Package pkg) {
        XmlSchema xmlSchemaAnnotation = pkg.getAnnotation(XmlSchema.class);
        String namespace = xmlSchemaAnnotation.namespace();
        if (namespace == null) {
            throw new IllegalArgumentException("No namespace annotation in " + pkg);
        }
        if (!namespace.equals(typeName.getNamespaceURI())) {
            throw new IllegalArgumentException("Looking for type in namespace " + typeName.getNamespaceURI() + ", but the package annotation indicates namespace " + namespace);
        }
        for (Class clazz : ClassPathUtil.listClasses(pkg)) {
            QName foundTypeQName = JAXBUtil.getTypeQName(clazz);
            if (!typeName.equals(foundTypeQName)) continue;
            return clazz;
        }
        return null;
    }
}

