/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util;

import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassPathUtil {
    public static Trace LOGGER = TraceManager.getTrace(ClassPathUtil.class);

    public static Set<Class> listClasses(Package pkg) {
        return ClassPathUtil.listClasses(pkg.getName());
    }

    public static Set<Class> listClasses(String packageName) {
        HashSet<Class> classes = new HashSet<Class>();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = null;
        try {
            resources = LOGGER.getClass().getClassLoader().getResources(path);
        }
        catch (IOException e) {
            LOGGER.error("Classloader scaning error for " + path, e);
        }
        while (resources.hasMoreElements()) {
            URL candidateUrl = resources.nextElement();
            LOGGER.trace("Candidates from: " + candidateUrl.getPath());
            if ("file".contentEquals(candidateUrl.getProtocol())) {
                classes.addAll(ClassPathUtil.getFromDirectory(candidateUrl, packageName));
                continue;
            }
            if (!"jar".contentEquals(candidateUrl.getProtocol())) continue;
            classes.addAll(ClassPathUtil.getFromJar(candidateUrl, packageName));
        }
        return classes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean extractFileFromClassPath(String src, String dst) {
        InputStream is = ClassPathUtil.class.getClassLoader().getResourceAsStream(src);
        if (is == null) {
            LOGGER.error("Unable to find file {} for extraction to {}", src, dst);
            return false;
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dst);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Unable to open destination file " + dst + ":", e);
            return false;
        }
        byte[] buf = new byte[655360];
        try {
            int len;
            while ((len = is.read(buf)) > 0) {
                try {
                    ((OutputStream)out).write(buf, 0, len);
                }
                catch (IOException e) {
                    LOGGER.error("Unable to write file " + dst + ":", e);
                    return false;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to read file " + src + " from classpath", e);
            return false;
        }
        try {
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            LOGGER.error("Unable to close file " + dst + ":", e);
            return false;
        }
        try {
            is.close();
            return true;
        }
        catch (IOException e) {
            LOGGER.error("This never happend:", e);
            return false;
        }
    }

    private static Collection<? extends Class> getFromJar(URL srcUrl, String packageName) {
        HashSet classes = new HashSet();
        String srcName = srcUrl.getPath().split("!/")[0];
        File jarTmp = null;
        try {
            jarTmp = new File(new URI(srcName));
        }
        catch (URISyntaxException ex) {
            LOGGER.error("Error converting jar " + srcName + " name to URI:", ex);
            return classes;
        }
        if (!jarTmp.isFile()) {
            LOGGER.error("Is {} not a file.", srcName);
        }
        JarFile jar = null;
        try {
            jar = new JarFile(jarTmp);
        }
        catch (IOException ex) {
            LOGGER.error("Error during open JAR " + srcName, ex);
            return classes;
        }
        String path = packageName.replace('.', '/');
        Enumeration<JarEntry> entries = jar.entries();
        LOGGER.trace("PATH:" + path);
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            String name = e.getName().replace('$', '/');
            if (!name.contains(path) || !name.contains(".class") || name.matches(String.valueOf(path) + "/.+/.*.class")) continue;
            LOGGER.trace("JAR Candidate: {}", name);
            try {
                classes.add(Class.forName(name.replace('/', '.').replace(".class", "")));
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOGGER.error("Error during loading class {} from {}. ", name, jar.getName());
            }
        }
        try {
            jar.close();
        }
        catch (IOException ex) {
            LOGGER.error("Error during close JAR {} " + srcName, ex);
            return classes;
        }
        return classes;
    }

    private static Collection<Class> getFromDirectory(URL candidateUrl, String packageName) {
        HashSet<Class> classes = new HashSet<Class>();
        File dir = null;
        try {
            dir = new File(candidateUrl.toURI());
        }
        catch (URISyntaxException e) {
            LOGGER.error("NEVER HAPPEND -- Wrong URI: " + candidateUrl.getPath(), e);
            return classes;
        }
        if (!dir.isDirectory()) {
            LOGGER.warn("   Skip: {} is not a directory", candidateUrl.getPath());
            return classes;
        }
        String[] dirList = dir.list();
        int i = 0;
        while (i < dirList.length) {
            if (dirList[i].contains(".class")) {
                try {
                    LOGGER.trace("DIR Candidate: {}", dirList[i]);
                    classes.add(Class.forName(String.valueOf(packageName) + "." + dirList[i].replace(".class", "")));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    LOGGER.error("Error during loading class {} from {}. ", dirList[i], dir.getAbsolutePath());
                }
            }
            ++i;
        }
        return classes;
    }
}

