/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.io.Serializable;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeValidator<Z extends Comparable<Z> & Serializable>
extends Behavior
implements IValidator<Z> {
    private static final long serialVersionUID = 1L;
    private Z minimum;
    private Z maximum;

    public RangeValidator(Z minimum, Z maximum) {
        this.setRange(minimum, maximum);
    }

    protected RangeValidator() {
    }

    protected final void setRange(Z minimum, Z maximum) {
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public void validate(IValidatable<Z> validatable) {
        Comparable value = (Comparable)validatable.getValue();
        Z min = this.getMinimum();
        Z max = this.getMaximum();
        if (min != null && value.compareTo(min) < 0 || max != null && value.compareTo(max) > 0) {
            ValidationError error = new ValidationError();
            error.addMessageKey(this.resourceKey());
            error.setVariable("minimum", min);
            error.setVariable("maximum", max);
            validatable.error(error);
        }
    }

    public Z getMinimum() {
        return this.minimum;
    }

    public Z getMaximum() {
        return this.maximum;
    }

    protected String resourceKey() {
        return Classes.simpleName(RangeValidator.class);
    }
}

