/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketTesterHelper {
    public static List<ComponentData> getComponentData(Page page) {
        final ArrayList<ComponentData> data = new ArrayList<ComponentData>();
        if (page != null) {
            page.visitChildren(new IVisitor<Component, Void>(){

                public void component(Component component, IVisit<Void> visit) {
                    ComponentData object = new ComponentData();
                    String name = component.getClass().getName();
                    if (name.indexOf("$") > 0) {
                        name = component.getClass().getSuperclass().getName();
                    }
                    name = Strings.lastPathComponent((String)name, (char)':');
                    object.path = component.getPageRelativePath();
                    object.type = name;
                    try {
                        object.value = component.getDefaultModelObjectAsString();
                    }
                    catch (Exception e) {
                        object.value = e.getMessage();
                    }
                    data.add(object);
                }
            });
        }
        return data;
    }

    public static void assertEquals(Collection<?> expects, Collection<?> actuals) {
        if (actuals.size() != expects.size() || !expects.containsAll(actuals) || !actuals.containsAll(expects)) {
            WicketTesterHelper.failWithVerboseMessage(expects, actuals);
        }
    }

    public static void failWithVerboseMessage(Collection<?> expects, Collection<?> actuals) {
        Assert.fail((String)("\nexpect (" + expects.size() + "):\n" + WicketTesterHelper.asLined(expects) + "\nbut was (" + actuals.size() + "):\n" + WicketTesterHelper.asLined(actuals)));
    }

    public static String asLined(Collection<?> objects) {
        StringBuilder lined = new StringBuilder();
        Iterator<?> iter = objects.iterator();
        while (iter.hasNext()) {
            String objectString = iter.next().toString();
            lined.append("   ");
            lined.append(objectString);
            if (!iter.hasNext()) continue;
            lined.append("\n");
        }
        return lined.toString();
    }

    public static AjaxEventBehavior findAjaxEventBehavior(Component component, String event) {
        for (Behavior behavior : component.getBehaviors()) {
            if (!(behavior instanceof AjaxEventBehavior) || !event.equalsIgnoreCase(((AjaxEventBehavior)behavior).getEvent())) continue;
            return (AjaxEventBehavior)behavior;
        }
        return null;
    }

    public static Behavior findBehavior(Component component, Class<? extends Behavior> behaviorClass) {
        for (Behavior behavior : component.getBehaviors()) {
            if (!behaviorClass.isAssignableFrom(behavior.getClass())) continue;
            return behavior;
        }
        return null;
    }

    public static class ComponentData
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        public String path;
        public String type;
        public String value;
    }
}

