/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.string;

import org.apache.wicket.request.Response;
import org.apache.wicket.util.string.Strings;

public class JavaScriptUtils {
    public static final String SCRIPT_OPEN_TAG = "<script type=\"text/javascript\">\n/*<![CDATA[*/\n";
    public static final String SCRIPT_CLOSE_TAG = "\n/*]]>*/\n</script>\n";
    public static final String SCRIPT_CONTENT_PREFIX = "\n/*<![CDATA[*/\n";
    public static final String SCRIPT_CONTENT_SUFFIX = "\n/*]]>*/\n";
    private final Response response;

    public JavaScriptUtils(Response response, String id) {
        this.response = response;
        JavaScriptUtils.writeOpenTag(response, id);
    }

    public JavaScriptUtils(Response response) {
        this.response = response;
        JavaScriptUtils.writeOpenTag(response);
    }

    public static CharSequence escapeQuotes(CharSequence input) {
        CharSequence s = input;
        if (s != null) {
            s = Strings.replaceAll((CharSequence)s, (CharSequence)"'", (CharSequence)"\\'");
            s = Strings.replaceAll((CharSequence)s, (CharSequence)"\"", (CharSequence)"\\\"");
        }
        return s;
    }

    public static void writeJavaScriptUrl(Response response, CharSequence url, String id) {
        JavaScriptUtils.writeJavaScriptUrl(response, url, id, false, null);
    }

    public static void writeJavaScriptUrl(Response response, CharSequence url, String id, boolean defer, String charset) {
        response.write((CharSequence)"<script type=\"text/javascript\" ");
        if (id != null) {
            response.write((CharSequence)("id=\"" + Strings.escapeMarkup((CharSequence)id) + "\" "));
        }
        if (defer) {
            response.write((CharSequence)"defer=\"defer\" ");
        }
        if (charset != null) {
            response.write((CharSequence)("charset=\"" + Strings.escapeMarkup((CharSequence)charset) + "\" "));
        }
        response.write((CharSequence)"src=\"");
        response.write(Strings.escapeMarkup((CharSequence)url));
        response.write((CharSequence)"\"></script>");
        response.write((CharSequence)"\n");
    }

    public static void writeJavaScriptUrl(Response response, CharSequence url) {
        JavaScriptUtils.writeJavaScriptUrl(response, url, null);
    }

    public static void writeJavaScript(Response response, CharSequence text, String id) {
        JavaScriptUtils.writeOpenTag(response, id);
        response.write(text);
        JavaScriptUtils.writeCloseTag(response);
    }

    public static void writeJavaScript(Response response, CharSequence text) {
        JavaScriptUtils.writeJavaScript(response, text, null);
    }

    public static void writeOpenTag(Response response, String id) {
        response.write((CharSequence)"<script type=\"text/javascript\" ");
        if (id != null) {
            response.write((CharSequence)("id=\"" + id + "\""));
        }
        response.write((CharSequence)">");
        response.write((CharSequence)SCRIPT_CONTENT_PREFIX);
    }

    public static void writeOpenTag(Response response) {
        JavaScriptUtils.writeOpenTag(response, null);
    }

    public static void writeCloseTag(Response response) {
        response.write((CharSequence)SCRIPT_CONTENT_SUFFIX);
        response.write((CharSequence)"</script>\n");
    }

    public void write(CharSequence script) {
        this.response.write(script);
    }

    public void println(CharSequence script) {
        this.response.write(script);
    }

    public void close() {
        JavaScriptUtils.writeCloseTag(this.response);
    }
}

