/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator.caching;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.UrlResourceStream;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.util.resource.locator.caching.FileResourceStreamReference;
import org.apache.wicket.util.resource.locator.caching.IResourceStreamReference;
import org.apache.wicket.util.resource.locator.caching.NullResourceStreamReference;
import org.apache.wicket.util.resource.locator.caching.UrlResourceStreamReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingResourceStreamLocator
implements IResourceStreamLocator {
    private final ConcurrentMap<ResourceReference.Key, IResourceStreamReference> cache;
    private final IResourceStreamLocator delegate;

    public CachingResourceStreamLocator(IResourceStreamLocator resourceStreamLocator) {
        Args.notNull((Object)resourceStreamLocator, (String)"resourceStreamLocator");
        this.delegate = resourceStreamLocator;
        this.cache = new ConcurrentHashMap<ResourceReference.Key, IResourceStreamReference>();
    }

    @Override
    public IResourceStream locate(Class<?> clazz, String path) {
        IResourceStream result;
        ResourceReference.Key key = new ResourceReference.Key(clazz.getName(), path, null, null, null);
        IResourceStreamReference resourceStreamReference = (IResourceStreamReference)this.cache.get(key);
        if (resourceStreamReference == null) {
            result = this.delegate.locate(clazz, path);
            this.updateCache(key, result);
        } else {
            result = resourceStreamReference.getReference();
        }
        return result;
    }

    private void updateCache(ResourceReference.Key key, IResourceStream stream) {
        if (null == stream) {
            this.cache.put(key, NullResourceStreamReference.INSTANCE);
        } else if (stream instanceof FileResourceStream) {
            FileResourceStream fileResourceStream = (FileResourceStream)stream;
            this.cache.put(key, new FileResourceStreamReference(fileResourceStream));
        } else if (stream instanceof UrlResourceStream) {
            UrlResourceStream urlResourceStream = (UrlResourceStream)stream;
            this.cache.put(key, new UrlResourceStreamReference(urlResourceStream));
        }
    }

    @Override
    public IResourceStream locate(Class<?> scope, String path, String style, String variation, Locale locale, String extension, boolean strict) {
        IResourceStream result;
        ResourceReference.Key key = new ResourceReference.Key(scope.getName(), path, locale, style, variation);
        IResourceStreamReference resourceStreamReference = (IResourceStreamReference)this.cache.get(key);
        if (resourceStreamReference == null) {
            result = this.delegate.locate(scope, path, style, variation, locale, extension, strict);
            this.updateCache(key, result);
        } else {
            result = resourceStreamReference.getReference();
        }
        return result;
    }

    @Override
    public ResourceNameIterator newResourceNameIterator(String path, Locale locale, String style, String variation, String extension, boolean strict) {
        return this.delegate.newResourceNameIterator(path, locale, style, variation, extension, strict);
    }
}

