/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.response.filter;

import java.util.HashMap;
import org.apache.wicket.Application;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.response.filter.IResponseFilter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxServerAndClientTimeFilter
implements IResponseFilter {
    private static Logger log = LoggerFactory.getLogger(AjaxServerAndClientTimeFilter.class);

    public AppendingStringBuffer filter(AppendingStringBuffer responseBuffer) {
        int headIndex = responseBuffer.indexOf("<head>");
        int bodyIndex = responseBuffer.indexOf("</body>");
        int ajaxStart = responseBuffer.indexOf("<ajax-response>");
        int ajaxEnd = responseBuffer.indexOf("</ajax-response>");
        long timeTaken = System.currentTimeMillis() - RequestCycle.get().getStartTime();
        if (headIndex != -1 && bodyIndex != -1) {
            AppendingStringBuffer endScript = new AppendingStringBuffer(150);
            endScript.append("\n").append("<script type=\"text/javascript\">\n/*<![CDATA[*/\n");
            endScript.append("\nwindow.defaultStatus='");
            endScript.append(this.getStatusString(timeTaken, "ServerAndClientTimeFilter.statustext"));
            endScript.append("';\n").append("\n/*]]>*/\n</script>\n").append("\n");
            responseBuffer.insert(bodyIndex - 1, (Object)endScript);
            responseBuffer.insert(headIndex + 6, "\n<script type=\"text/javascript\">\n/*<![CDATA[*/\n\nvar clientTimeVariable = new Date().getTime();\n\n/*]]>*/\n</script>\n\n");
        } else if (ajaxStart != -1 && ajaxEnd != -1) {
            AppendingStringBuffer startScript = new AppendingStringBuffer(250);
            startScript.append("<evaluate><![CDATA[window.defaultStatus='");
            startScript.append(this.getStatusString(timeTaken, "ajax.ServerAndClientTimeFilter.statustext"));
            startScript.append("';]]></evaluate>");
            responseBuffer.insert(ajaxEnd, startScript.toString());
            responseBuffer.insert(ajaxStart + 15, "<evaluate><![CDATA[clientTimeVariable = new Date().getTime();]]></evaluate>");
        }
        log.info(timeTaken + "ms server time taken for request " + RequestCycle.get().getRequest().getUrl() + " response size: " + responseBuffer.length());
        return responseBuffer;
    }

    private String getStatusString(long timeTaken, String resourceKey) {
        String txt = Application.get().getResourceSettings().getLocalizer().getString(resourceKey, null, "Server parsetime: ${servertime}, Client parsetime: ${clienttime}");
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("clienttime", "' + (new Date().getTime() - clientTimeVariable)/1000 +  's");
        map.put("servertime", (double)timeTaken / 1000.0 + "s");
        return MapVariableInterpolator.interpolate((String)txt, map);
    }
}

