/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.aggregation.ResourceReferenceAndStringData;
import org.apache.wicket.resource.dependencies.AbstractResourceDependentResourceReference;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.Strings;

public class ResourceUtil {
    private ResourceUtil() {
    }

    @Deprecated
    public static void renderTo(IHeaderResponse resp, ResourceReference ref, boolean css, String string) {
        if (css) {
            if (Strings.isEmpty((CharSequence)string)) {
                resp.renderCSSReference(ref);
            } else {
                resp.renderCSSReference(ref, string);
            }
        } else if (Strings.isEmpty((CharSequence)string)) {
            resp.renderJavaScriptReference(ref);
        } else {
            resp.renderJavaScriptReference(ref, string);
        }
    }

    public static void renderTo(IHeaderResponse resp, ResourceReferenceAndStringData data) {
        AbstractResourceDependentResourceReference.ResourceType resourceType = data.getResourceType();
        ResourceReference reference = data.getReference();
        PageParameters parameters = data.getParameters();
        String idOrMedia = data.getIdOrMedia();
        CharSequence content = data.getContent();
        switch (resourceType) {
            case CSS: {
                String condition = data.getCssCondition();
                if (!Strings.isEmpty((CharSequence)content)) {
                    resp.renderCSS(content, idOrMedia);
                    break;
                }
                if (reference == null) {
                    resp.renderCSSReference(data.getUrl(), idOrMedia, condition);
                    break;
                }
                resp.renderCSSReference(reference, parameters, idOrMedia, condition);
                break;
            }
            case JS: {
                boolean defer = data.isJsDefer();
                String charset = data.getCharset();
                if (!Strings.isEmpty((CharSequence)content)) {
                    resp.renderJavaScript(content, idOrMedia);
                    break;
                }
                if (reference == null) {
                    resp.renderJavaScriptReference(data.getUrl(), idOrMedia, defer, charset);
                    break;
                }
                resp.renderJavaScriptReference(reference, parameters, idOrMedia, defer, charset);
                break;
            }
            case PLAIN: {
                resp.renderString(content);
            }
        }
    }

    public static String readString(IResourceStream resourceStream) {
        return ResourceUtil.readString(resourceStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(IResourceStream resourceStream, Charset charset) {
        String string;
        InputStream stream = resourceStream.getInputStream();
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            string = new String(bytes, charset.name());
        }
        catch (Throwable throwable) {
            try {
                resourceStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new WicketRuntimeException("failed to read string from " + resourceStream, e);
            }
            catch (ResourceStreamNotFoundException e) {
                throw new WicketRuntimeException("failed to locate stream from " + resourceStream, e);
            }
        }
        resourceStream.close();
        return string;
    }
}

