/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import org.apache.wicket.Application;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.lang.Args;

public class BookmarkableMapper
extends AbstractBookmarkableMapper {
    private final IPageParametersEncoder pageParametersEncoder;

    public BookmarkableMapper(IPageParametersEncoder pageParametersEncoder) {
        Args.notNull((Object)pageParametersEncoder, (String)"pageParametersEncoder");
        this.pageParametersEncoder = pageParametersEncoder;
    }

    public BookmarkableMapper() {
        this((IPageParametersEncoder)new PageParametersEncoder());
    }

    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Url url = new Url();
        url.getSegments().add(this.getContext().getNamespace());
        url.getSegments().add(this.getContext().getBookmarkableIdentifier());
        url.getSegments().add(info.getPageClass().getName());
        this.encodePageComponentInfo(url, info.getPageComponentInfo());
        return this.encodePageParameters(url, info.getPageParameters(), this.pageParametersEncoder);
    }

    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        if (Application.exists() && Application.get().getSecuritySettings().getEnforceMounts()) {
            return null;
        }
        Url url = request.getUrl();
        if (this.matches(url)) {
            PageComponentInfo info = this.getPageComponentInfo(url);
            String className = (String)url.getSegments().get(2);
            Class<? extends IRequestablePage> pageClass = this.getPageClass(className);
            if (pageClass != null && IRequestablePage.class.isAssignableFrom(pageClass)) {
                PageParameters pageParameters = this.extractPageParameters(request, 3, this.pageParametersEncoder);
                return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
            }
        }
        return null;
    }

    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return true;
    }

    public int getCompatibilityScore(Request request) {
        int score = 0;
        Url url = request.getUrl();
        if (this.matches(url)) {
            score = Integer.MAX_VALUE;
        }
        return score;
    }

    private boolean matches(Url url) {
        return url.getSegments().size() >= 3 && this.urlStartsWith(url, new String[]{this.getContext().getNamespace(), this.getContext().getBookmarkableIdentifier()});
    }
}

