/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.mock;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.wicket.util.value.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockHttpSession
implements HttpSession,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ValueMap attributes = new ValueMap();
    private final transient ServletContext context;
    private final long creationTime = System.currentTimeMillis();
    private final String id = UUID.randomUUID().toString().replace(':', '_').replace('-', '_');
    private long lastAccessedTime = 0L;
    private boolean temporary = true;

    public MockHttpSession(ServletContext context) {
        this.context = context;
    }

    public Object getAttribute(String name) {
        return this.attributes.get((Object)name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public int getMaxInactiveInterval() {
        return 0;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    @Deprecated
    public String[] getValueNames() {
        String[] result = new String[this.attributes.size()];
        return this.attributes.keySet().toArray(result);
    }

    public void invalidate() {
        this.attributes.clear();
    }

    public boolean isNew() {
        return false;
    }

    @Deprecated
    public void putValue(String name, Object o) {
        this.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove((Object)name);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void setMaxInactiveInterval(int i) {
    }

    public void timestamp() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public final boolean isTemporary() {
        return this.temporary;
    }

    public final void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }
}

