/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.model.util;

import java.io.Serializable;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericBaseModel<T>
implements IModel<T> {
    private static final long serialVersionUID = 1L;
    private T object;

    @Override
    public T getObject() {
        return this.object;
    }

    @Override
    public void setObject(T object) {
        if (!(object instanceof Serializable)) {
            object = this.createSerializableVersionOf(object);
        }
        this.object = object;
    }

    protected abstract T createSerializableVersionOf(T var1);

    @Override
    public void detach() {
        if (this.object instanceof IDetachable) {
            ((IDetachable)this.object).detach();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Model:classname=[");
        sb.append(this.getClass().getName()).append("]");
        sb.append(":object=[").append(this.object).append("]");
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.object});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericBaseModel)) {
            return false;
        }
        GenericBaseModel that = (GenericBaseModel)obj;
        return Objects.equal(this.object, that.object);
    }
}

