/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.WildcardListModel;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChoice<T, E>
extends FormComponent<T> {
    private static final long serialVersionUID = 1L;
    private IModel<? extends List<? extends E>> choices;
    private IChoiceRenderer<? super E> renderer;

    public AbstractChoice(String id) {
        this(id, new WildcardListModel(new ArrayList()), new ChoiceRenderer());
    }

    public AbstractChoice(String id, List<? extends E> choices) {
        this(id, new WildcardListModel<E>(choices), new ChoiceRenderer());
    }

    public AbstractChoice(String id, List<? extends E> choices, IChoiceRenderer<? super E> renderer) {
        this(id, new WildcardListModel<E>(choices), renderer);
    }

    public AbstractChoice(String id, IModel<T> model, List<? extends E> choices) {
        this(id, model, new WildcardListModel<E>(choices), new ChoiceRenderer());
    }

    public AbstractChoice(String id, IModel<T> model, List<? extends E> choices, IChoiceRenderer<? super E> renderer) {
        this(id, model, new WildcardListModel<E>(choices), renderer);
    }

    public AbstractChoice(String id, IModel<? extends List<? extends E>> choices) {
        this(id, choices, new ChoiceRenderer());
    }

    public AbstractChoice(String id, IModel<? extends List<? extends E>> choices, IChoiceRenderer<? super E> renderer) {
        super(id);
        this.choices = this.wrap(choices);
        this.setChoiceRenderer(renderer);
    }

    public AbstractChoice(String id, IModel<T> model, IModel<? extends List<? extends E>> choices) {
        this(id, model, choices, new ChoiceRenderer());
    }

    public AbstractChoice(String id, IModel<T> model, IModel<? extends List<? extends E>> choices, IChoiceRenderer<? super E> renderer) {
        super(id, model);
        this.choices = this.wrap(choices);
        this.setChoiceRenderer(renderer);
    }

    public List<? extends E> getChoices() {
        List<? extends E> choices;
        List<? extends E> list = choices = this.choices != null ? this.choices.getObject() : null;
        if (choices == null) {
            throw new NullPointerException("List of choices is null - Was the supplied 'Choices' model empty?");
        }
        return choices;
    }

    public final AbstractChoice<T, E> setChoices(IModel<? extends List<? extends E>> choices) {
        if (this.choices != null && this.choices != choices && this.isVersioned()) {
            this.addStateChange();
        }
        this.choices = this.wrap(choices);
        return this;
    }

    public final AbstractChoice<T, E> setChoices(List<E> choices) {
        if (this.choices != null && this.isVersioned()) {
            this.addStateChange();
        }
        this.choices = new WildcardListModel<E>(choices);
        return this;
    }

    public final IChoiceRenderer<? super E> getChoiceRenderer() {
        return this.renderer;
    }

    public final AbstractChoice<T, E> setChoiceRenderer(IChoiceRenderer<? super E> renderer) {
        if (renderer == null) {
            renderer = new ChoiceRenderer<E>();
        }
        this.renderer = renderer;
        return this;
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.choices != null) {
            this.choices.detach();
        }
    }

    protected CharSequence getDefaultChoice(String selectedValue) {
        return "";
    }

    protected abstract boolean isSelected(E var1, int var2, String var3);

    protected boolean isDisabled(E object, int index, String selected) {
        return false;
    }

    @Override
    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        List<E> choices = this.getChoices();
        AppendingStringBuffer buffer = new AppendingStringBuffer(choices.size() * 50 + 16);
        String selectedValue = this.getValue();
        buffer.append((Object)this.getDefaultChoice(selectedValue));
        for (int index = 0; index < choices.size(); ++index) {
            E choice = choices.get(index);
            this.appendOptionHtml(buffer, choice, index, selectedValue);
        }
        buffer.append("\n");
        this.replaceComponentTagBody(markupStream, openTag, (CharSequence)buffer);
    }

    protected void appendOptionHtml(AppendingStringBuffer buffer, E choice, int index, String selected) {
        Object objectValue = this.renderer.getDisplayValue(choice);
        Class<?> objectClass = objectValue == null ? null : objectValue.getClass();
        String displayValue = "";
        if (objectClass != null && objectClass != String.class) {
            IConverter<?> converter = this.getConverter(objectClass);
            displayValue = converter.convertToString(objectValue, this.getLocale());
        } else if (objectValue != null) {
            displayValue = objectValue.toString();
        }
        buffer.append("\n<option ");
        this.setOptionAttributes(buffer, choice, index, selected);
        buffer.append(">");
        String display = displayValue;
        if (this.localizeDisplayValues()) {
            display = this.getLocalizer().getString(displayValue, (Component)this, displayValue);
        }
        CharSequence escaped = display;
        if (this.getEscapeModelStrings()) {
            escaped = this.escapeOptionHtml(display);
        }
        buffer.append((Object)escaped);
        buffer.append("</option>");
    }

    protected void setOptionAttributes(AppendingStringBuffer buffer, E choice, int index, String selected) {
        if (this.isSelected(choice, index, selected)) {
            buffer.append("selected=\"selected\" ");
        }
        if (this.isDisabled(choice, index, selected)) {
            buffer.append("disabled=\"disabled\" ");
        }
        buffer.append("value=\"");
        buffer.append((Object)Strings.escapeMarkup((CharSequence)this.renderer.getIdValue(choice, index)));
        buffer.append("\"");
    }

    protected CharSequence escapeOptionHtml(String displayValue) {
        return Strings.escapeMarkup((CharSequence)displayValue);
    }

    protected boolean localizeDisplayValues() {
        return false;
    }

    @Override
    public final FormComponent<T> setType(Class<?> type) {
        throw new UnsupportedOperationException("This class does not support type-conversion because it is performed exclusively by the IChoiceRenderer assigned to this component");
    }
}

